#!/usr/local/bin/perl
# save_raid.cgi
# Activate, deactivate, delete or make a filesystem on a raid set

require './raid-lib.pl';
&ReadParse();
$conf = &get_raidtab();
$old = $conf->[$in{'idx'}];

if ($in{'delete'}) {
	# Delete a RAID set
	&lock_file($config{'raidtab'});
	&deactivate_raid($old) if ($old->{'active'});
	&delete_raid($old);
	&unlock_file($config{'raidtab'});
	&webmin_log("delete", undef, $old->{'value'});
	&redirect("");
	}
elsif ($in{'mkfs'}) {
	# Display form for making a filesystem
	&foreign_require("fdisk", "fdisk-lib.pl");
	&header($text{'mkfs_title'}, "");
	print "<hr>\n";

	print "<p>",&text('mkfs_header', "<tt>$old->{'value'}</tt>"),"<br>\n";
	print "<form action=mkfs.cgi>\n";
	print "<input type=hidden name=idx value='$in{'idx'}'>\n";
	print "<table border width=100%>\n";
	print "<tr $tb><td><b>$text{'mkfs_options'}</b></td> </tr>\n";
	print "<tr $cb><td><table width=100%>\n";
	&foreign_call("fdisk", "mkfs_options", "ext2");
	print "</table></td></tr></table>\n";
	print "<input type=submit value='$text{'create'}'></form>\n";

	print "<hr>\n";
	&footer("", $text{'index_return'});
	}
elsif ($in{'start'}) {
	# Start raid device
	&activate_raid($old);
	&webmin_log("start", undef, $old->{'value'});
	&redirect("");
	}
elsif ($in{'stop'}) {
	# Stop raid device
	&deactivate_raid($old);
	&webmin_log("stop", undef, $old->{'value'});
	&redirect("");
	}

