#!/usr/local/bin/perl
# save_grant.cgi
# Update privilege grants on some table/view/index

require './postgresql-lib.pl';
&ReadParse();
$access{'users'} || &error($text{'grant_ecannot'});

# Remove old privileges on object
$s = &execute_sql($in{'db'}, '\z');
foreach $g (@{$s->{'data'}}) {
	if ($g->[0] eq $in{'table'}) {
		$g->[1] =~ s/^\{//; $g->[1] =~ s/\}$//;
		@grant = map { /^"(.*)=(.*)"$/; [ $1, $2 ] }
			     split(/,/, $g->[1]);
		}
	}
foreach $g (@grant) {
	next if (!$g->[1]);
	if ($g->[0] eq '') {
		$who = "public";
		}
	elsif ($g->[0] =~ /group\s+(\S+)/) {
		$who = "group $1";
		}
	else {
		$who = $g->[0];
		}
	&execute_sql_logged($in{'db'}, "revoke all on $in{'table'} from $who");
	}

# Grant new privileges
for($i=0; defined($in{"user_$i"}); $i++) {
	@what = split(/\0/, $in{"what_$i"});
	next if (!$in{"user_$i"} || !@what);
	&execute_sql_logged($in{'db'}, "grant ".join(",", @what)." on ".
				       $in{'table'}." to ".$in{"user_$i"});
	}

&webmin_log("grant", undef, $in{'table'}, \%in);
&redirect("list_grants.cgi");

