#!/usr/local/bin/perl
# edit_host.cgi
# Display a form for editing or creating an allowed host

require './postgresql-lib.pl';
&ReadParse();
if ($in{'new'}) {
	$type = $in{'new'};
	&header($text{"host_create"}, "");
	$host = { 'type' => $type, 'netmask' => '0.0.0.0',
		  'auth' => 'trust', 'db' => 'all' };
	}
else {
	@all = &get_hba_config();
	$host = $all[$in{'idx'}];
	$type = $host->{'type'};
	&header($text{"host_edit"}, "");
	}
print "<hr>\n";

print "<form action=save_host.cgi>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<input type=hidden name=new value='$in{'new'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'user_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

$mode = $type eq 'local' ? 3 :
	$host->{'netmask'} eq '0.0.0.0' ? 0 :
	$host->{'netmask'} eq '255.255.255.255' ? 1 : 2;
print "<tr> <td valign=top><b>$text{'host_address'}</b></td> <td colspan=2>\n";
printf "<input type=radio name=addr_mode value=3 %s> %s<br>\n",
	$mode == 3 ? 'checked' : '', $text{'host_local'};

printf "<input type=radio name=addr_mode value=0 %s> %s<br>\n",
	$mode == 0 ? 'checked' : '', $text{'host_any'};

printf "<input type=radio name=addr_mode value=1 %s> %s\n",
	$mode == 1 ? 'checked' : '', $text{'host_single'};
printf "<input name=host size=20 value='%s'><br>\n",
	$mode == 1 ? $host->{'address'} : '';

printf "<input type=radio name=addr_mode value=2 %s> %s\n",
	$mode == 2 ? 'checked' : '', $text{'host_network'};
printf "<input name=network size=20 value='%s'> %s\n",
	$mode == 2 ? $host->{'address'} : '', $text{'host_netmask'};
printf "<input name=netmask size=20 value='%s'></td> </tr>\n",
	$mode == 2 ? $host->{'netmask'} : '';

print "<tr> <td><b>$text{'host_db'}</b></td>\n";
print "<td colspan=2><select name=db>\n";
printf "<option value=all %s>&lt;$text{'host_all'}&gt;\n",
	$host->{'db'} eq 'all' ? 'selected' : '';
printf "<option value=sameuser %s>&lt;$text{'host_same'}&gt;\n",
	$host->{'db'} eq 'sameuser' ? 'selected' : '';
foreach $d (&list_databases()) {
	printf "<option %s>%s\n", $host->{'db'} eq $d ? 'selected' : '', $d;
	}
print "</select></td> </tr>\n";

print "<tr> <td valign=top><b>$text{'host_auth'}</b></td> <td valign=top>\n";
foreach $a ('password', 'crypt', 'trust', 'reject', 'ident', 'krb4', 'krb5') {
	printf "<input type=radio name=auth value=%s %s> %s\n",
		$a, $host->{'auth'} eq $a ? 'checked' : '', $text{"host_$a"};
	$arg = $host->{'auth'} eq $a ? $host->{'arg'} : undef;
	if ($a eq 'password') {
		print "<br>&nbsp;&nbsp;&nbsp;\n";
		printf "<input type=checkbox name=passwordarg value=1 %s> %s\n",
			$arg ? 'checked' : '', $text{'host_passwordarg'};
		print "<input name=password size=20 value='$arg'>\n";
		}
	elsif ($a eq 'ident') {
		print "<br>&nbsp;&nbsp;&nbsp;\n";
		printf "<input type=checkbox name=identarg value=1 %s> %s\n",
			$arg ? 'checked' : '', $text{'host_identarg'};
		print "<input name=ident size=10 value='$arg'>\n";
		}
	print "<br>\n";
	if ($a eq 'reject') {
		print "</td><td valign=top>\n";
		}
	}
print "</td></tr>\n";

print "</table></td></tr></table>\n";
print "<table width=100%><tr>\n";
if ($in{'new'}) {
	print "<td><input type=submit value='$text{'create'}'></td>\n";
	}
else {
	print "<td><input type=submit value='$text{'save'}'></td>\n";
	print "<td align=right><input type=submit name=delete ",
	      "value='$text{'delete'}'></td>\n";
	}
print "</tr></table>\n";

print "<hr>\n";
&footer("list_hosts.cgi", $text{'host_return'});

