#!/usr/local/bin/perl
# index.cgi
# Webmin index page for Caldera's theme. Contains two frames, with the
# categories and modules always at the top and the CGIs at the bottom

require './web-lib.pl';
&init_config();
$hostname = &get_system_hostname();
$ver = &get_webmin_version();
if ($gconfig{'real_os_type'}) {
	$ostr = "$gconfig{'real_os_type'} $gconfig{'real_os_version'}";
	}
else {
	$ostr = "$gconfig{'os_type'} $gconfig{'os_version'}";
	}

# Find the category with the most modules
&read_acl(\%acl);
opendir(DIR, ".");
$user = $base_remote_user;
$risk = $gconfig{'risk_'.$user};
foreach $d (readdir(DIR)) {
	local %minfo;
	if ($d !~ /^config-/ && (%minfo = &get_module_info($d))) {
		if (!&check_os_support(\%minfo)) {
			# This OS is not supported!
			next;
			}
		if ($risk) {
			# Check module risk level
			next if ($risk ne 'high' && $minfo{'risk'} &&
				 $minfo{'risk'} !~ /$risk/);
			}
		else {
			# Check specific ACL
			next if (!$acl{$user,$d} && !$acl{$user,"*"});
			}
		local $c = $minfo{'category'} ? $minfo{'category'} : 'other';
		$count{$c}++;
		$maxcat = $count{$c} if ($count{$c} > $maxcat);
		}
	}
closedir(DIR);
$rows = 60 + (int(($maxcat-1) / 3)+1)*25;

# Display the frameset
&PrintHeader();
print "<!doctype html public \"-//W3C//DTD HTML 3.2 Final//EN\">\n";
print "<html><head><title>",&text('main_title', $ver, $hostname, $ostr),
      "</title></head>\n";
print "<frameset rows='$rows,*' border=0>\n";
print "<frame scrolling=no noresize src='index_top.cgi' name=top>\n";
print "<frame scrolling=auto noresize src='index_body.cgi' name=body>\n";
print "</frameset></html>\n";

