// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        inetaddr.h
// 
// Purpose:     
// 
// Created:     5 Jul 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: inetaddr.h,v 1.3 1997/01/29 16:18:52 gorasche Exp $
// 
// $Log: inetaddr.h,v $
// Revision 1.3  1997/01/29 16:18:52  gorasche
// include for bool data type for MSVC++
//
// Revision 1.2  1996/10/03 15:59:07  jfasch
// adaptions due to moving it from the previous location in DcCommon to HgUtilities
//
// Revision 1.1  1996/07/08 13:16:36  jfasch
// Initial revision
//
// 
// </file> 
#ifndef hg_utils_inetaddr_h
#define hg_utils_inetaddr_h

#ifdef WIN32
#include "types.h"
#else
#include <sys/types.h>
#endif
#include <netinet/in.h>

class INETAddress : public sockaddr_in {
public:
   INETAddress() ;
   INETAddress (const char* hostaddr, int port) ; /* addr in numbers-and-dots, port in host byte order */
   INETAddress (const sockaddr_in&) ;

   INETAddress& operator = (const sockaddr_in&) ;

   const char* host() const ; // my sockaddr_in.sin_addr, converted by inet_ntoa()
   int port() const ; // my sockaddr_in.sin_port after ntohs() (i.e., in host byte order)

   bool operator == (const INETAddress&) const ;
   bool operator <  (const INETAddress&) const ;
   bool operator != (const INETAddress& a) const { return !operator==(a); }

   bool ok() const { return sin_addr.s_addr || sin_port; }
   bool operator !() const { return !ok(); }
   operator void*() const { return (void*)ok(); }
} ;
inline class ostream& operator << (class ostream& s, const INETAddress&) {
   return s ;
}



#endif
