/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <RealSlider.h>

const int RealSlider::range_ = 200;

//-----------------------------------------------------------------
RealSlider::RealSlider( QWidget *parent, const char *name )
  : QSlider( 0, range_, 10, 50, Qt::Horizontal, parent, name )
{
  min_ = 0.0;
  max_ = 100.0;
}

//-----------------------------------------------------------------
RealSlider::~RealSlider()
{
}

//-----------------------------------------------------------------
void RealSlider::setRange( TReal min, TReal max )
{
  ASSERT( max > min );
  min_ = min;
  max_ = max;
}

//-----------------------------------------------------------------
void RealSlider::setCurrent( TReal current )
{
  int value = (int) floor( 0.5 + ( current - min_ ) / ( max_ - min_ ) * range_ );
  setValue( value );
}

//-----------------------------------------------------------------
TReal RealSlider::current()
{
  TReal delta = max_ - min_;
  TReal current = min_ + ( delta * value() ) / range_;
  return current;
}

//-----------------------------------------------------------------
QString RealSlider::rangeStr()
{
  QString rangeStr;
  QString temp;
  rangeStr.setNum( min_ );
  rangeStr += ":";
  temp.setNum( current() );
  rangeStr += temp + ":";
  temp.setNum( max_ );
  rangeStr += temp;
  return rangeStr;
}
