/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <Vccs.h>

#include <Strings.h>
#include <TwoPorts.h>

#include "../images/vccs.xpm"

QPixmap* Vccs::pixmap_ = 0;

//-----------------------------------------------------------------
Vccs::Vccs( const QPoint& center )
  : Component( center )
{
}

//-----------------------------------------------------------------
Vccs::~Vccs()
{
}

//-----------------------------------------------------------------
const QString& Vccs::getCatagory() const
{
  return Strings::LumpedCatagory;
}

//-----------------------------------------------------------------
const QString& Vccs::getName() const
{
  return Strings::VccsName;
}

//-----------------------------------------------------------------
const QPixmap& Vccs::getPixmap() const
{
  if (!pixmap_)
    {
      pixmap_ = new QPixmap( vccs_xpm );
    }
  return *pixmap_;
}

//-----------------------------------------------------------------
void Vccs::initComponent()
{
  boundingRect_ = QRect(-24, -16, 48, 32);
  addNode( +24, -16 );
  addNode( +24, +16 );
  addNode( -24, -16 );
  addNode( -24, +16 );
  addAttribute( Strings::AttrTransConductance, "G" );
}

//-----------------------------------------------------------------
void Vccs::drawSymbol(QPainter* p)
{
  p->drawLine(-24,-16,-16,-16);
  p->drawLine(-24,+16,-16,+16);
  p->drawLine(24,-16,8,-16);
  p->lineTo(8,-12);
  p->drawEllipse(-4,-12, 24, 24);
  p->drawLine(24,16,8,16);
  p->lineTo(8,12);
  p->drawLine(8,8,8,-8);
  p->drawLine(11,5, 8,8);
  p->lineTo(5,5);
  p->drawLine(-16,-10,-16,-4);
  p->drawLine(-13,-7,-19,-7);
  p->drawLine(-13,+7,-19,+7);
}

//-----------------------------------------------------------------
bool Vccs::initSweep()
{
  bool changed = FALSE;
  TReal g = g_;
  
  g_ = getAttributeValue( "G" );
  
  if ( g != g_)
    {
      changed = TRUE;
    }
  return changed;
}

//-----------------------------------------------------------------
void Vccs::addToAdmittanceMatrix( TReal, Matrix* yn )
{
  TComplex y = TComplex( g_, 0 );
  uint nodes [4];
  for ( uint i=0; i<4; i++ )
    {
      nodes[i] = node(i)->getNodeNumber();
    }
  yn->insertGm( y, nodes );
}
