/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <InductorQ.h>

#include <Strings.h>

#include "../images/inductorq.xpm"

#include <iostream.h>

QPixmap* InductorQ::pixmap_ = 0;

//-----------------------------------------------------------------
InductorQ::InductorQ( const QPoint& center )
  : Component( center )
{
}

//-----------------------------------------------------------------
InductorQ::~InductorQ()
{
}

//-----------------------------------------------------------------
const QString& InductorQ::getCatagory() const
{
  return Strings::LumpedCatagory;
}

//-----------------------------------------------------------------
const QString& InductorQ::getName() const
{
  return Strings::InductorQName;
}

//-----------------------------------------------------------------
const QPixmap& InductorQ::getPixmap() const
{
  if (!pixmap_)
    {
      pixmap_ = new QPixmap(inductorq_xpm);
    }
  return *pixmap_;
}

//-----------------------------------------------------------------
void InductorQ::initComponent()
{
  boundingRect_ = QRect(-16, -8, 32, 16);
  addNode(-24,0);
  addNode(24,0);
  addAttribute( Strings::AttrInductance, "L" );
  addAttribute( Strings::AttrQFactor, "Q" );
}

//-----------------------------------------------------------------
void InductorQ::drawSymbol(QPainter* p)
{
  p->save();
  p->drawLine(-24,0,-14,0);
  p->drawLine(14,0,24,0);
  p->drawArc(-14,-6,12,12,2880,-2880);
  p->drawArc(-6,-6,12,12,2880,-2880);
  p->drawArc(+2,-6,12,12,2880,-2880);
  p->drawArc(-6,-6,4,12,0,-2880);
  p->drawArc(+2,-6,4,12,0,-2880);
  QPen pen = p->pen();
  pen.setStyle( Qt::DashLine );
  p->setPen( pen );
  p->drawLine( -14,8, 14,8 );
  p->restore();
}

//-----------------------------------------------------------------
bool InductorQ::initSweep()
{
  TReal l = l_;
  TReal q = q_;
  l_ = getAttributeValue( "L" );
  l_ = l_ * getDimensionValue( Strings::InductanceDim );
  q_ = getAttributeValue( "Q" );
  return ( (l_ != l) || (q_ != q) );
}

//-----------------------------------------------------------------
void InductorQ::addToAdmittanceMatrix( TReal freq, Matrix* yn )
{
  TReal X = freq * l_;
  TReal R = q_ * X;
  TComplex y( 1/R, -1/X );
  yn->insertComponent( y, node(0)->getNodeNumber(), node(1)->getNodeNumber() );
}
