/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <GraphUtils.h>

#include <qpainter.h>
#include <qpointarray.h>

//----------------------------------------------------------------------------
QColor GraphUtils::getColor(int index)
{
  QColor color;
  switch ((index+6) % 12)
    {
    case 0:
      color.setRgb(255,0,0);
      break;
    case 1:
      color.setRgb(0,255,0);
      break;
    case 2:
      color.setRgb(0,0,255);
      break;
    case 3:
      color.setRgb(0,255,255);
      break;
    case 4:
      color.setRgb(255,0,255);
      break;
    case 5:
      color.setRgb(255,255,0);
      break;
    case 6:
      color.setRgb(128,0,0);
      break;
    case 7:
      color.setRgb(0,128,0);
      break;
    case 8:
      color.setRgb(0,0,128);
      break;
    case 9:
      color.setRgb(0,128,128);
      break;
    case 10:
      color.setRgb(128,0,128);
      break;
    case 11:
      color.setRgb(128,128,0);
      break;
    }
  return color;
}

//----------------------------------------------------------------------------
void GraphUtils::drawMarker(QPainter *p, int markerCount, int x, int y, int side)
{
  QPointArray shape;
  
  switch (markerCount % 4)
    {
    case 0: //Square
      {
        shape.resize( 5 );
        shape.setPoint( 0, -side,-side );
        shape.setPoint( 1, -side, side );
        shape.setPoint( 2,  side, side );
        shape.setPoint( 3,  side,-side );
        shape.setPoint( 4, -side,-side );
        break;
      }
    case 1: //Diamond
      {
        shape.resize( 5 );
        shape.setPoint( 0, 0, -side*2 );
        shape.setPoint( 1, -side, 0 );
        shape.setPoint( 2, 0, side*2 );
        shape.setPoint( 3, side, 0 );
        shape.setPoint( 4, 0, -side*2 );
        break;
      }
    case 2: //Circle
      {
        shape.makeEllipse(-side, -side, 2*side, 2*side);
        break;
      }
    case 3: //Funny thing
      {
        shape.resize( 5 );
        shape.setPoint(0,-side,-side);
        shape.setPoint(1,side,side);
        shape.setPoint(2,-side,side);
        shape.setPoint(3,side,-side);
        shape.setPoint(4,-side,-side);
        break;
      }
    default: //Should never get here
      {
        shape.resize( 5 );
        shape.setPoint(0,-side,-side);
        shape.setPoint(1,side,side);
        shape.setPoint(2,-side,side);
        shape.setPoint(3,side,-side);
        shape.setPoint(4,-side,-side);
        break;
      }
    }

  shape.translate(x,y);
  p->drawPolyline(shape);
}

//----------------------------------------------------------------------------
void GraphUtils::drawCursor(QPainter *p, int xp, int yp, int s)
{
  p->moveTo(xp, yp - s);
  p->lineTo(xp, yp + s);
  p->moveTo(xp - s, yp);
  p->lineTo(xp + s, yp);
  drawMarker(p, 2, xp, yp, s);
}
