/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <DimensionDefinition.h>
#include <Types.h>

//-----------------------------------------------------------------
DimensionDefinition::DimensionDefinition()
  : activeValue_(0)
{
  valuesList_.setAutoDelete( TRUE );  
}

//-----------------------------------------------------------------
DimensionDefinition::~DimensionDefinition() 
{
}

//-----------------------------------------------------------------
uint DimensionDefinition::nrEntries()
{
  return valuesList_.count();
}

//-----------------------------------------------------------------
const QString& DimensionDefinition::entryName( uint index )
{
  const Entry* entry = valuesList_.at( index );
  ASSERT( entry != 0 );
  return entry->name_;
}

//-----------------------------------------------------------------
const TReal DimensionDefinition::entryValue( uint index )
{
  const Entry* entry = valuesList_.at( index );
  ASSERT( entry != 0 );
  return entry->value_;
}

//-----------------------------------------------------------------
void DimensionDefinition::addEntry( const QString& name, TReal value )
{
  Entry* entry = new Entry();
  entry->name_ = name;
  entry->value_ = value;
  valuesList_.append( entry );
}

//-----------------------------------------------------------------
void DimensionDefinition::setActiveValue(const QString& name)
{
  Entry* entry = 0;
  for ( entry=valuesList_.first(); entry != 0; entry=valuesList_.next() )
    {
      if ( entry->name_ == name )
	{
	  break;
	}
    }
  ASSERT( entry != 0 );
  activeValue_ = entry; 
}

//-----------------------------------------------------------------
const QString& DimensionDefinition::getActiveValueName() const
{
  ASSERT( activeValue_ != 0 ); 
  return activeValue_->name_;
}

//-----------------------------------------------------------------
TReal DimensionDefinition::getActiveValue() const
{ 
  ASSERT( activeValue_ != 0 );
  return activeValue_->value_; 
}

  
