#ifndef VECTORFONT_H
#define VECTORFONT_H

#include <qmap.h>
#include <qlist.h>
#include <qpointarray.h>

class QPoint;
class QPainter;

class VectorChar
{
public:
  VectorChar();
  ~VectorChar();
private:
  void addPoly( int size, int firstx, int firsty, ... );
  void draw(QPainter* p);
private:
  QList<QPointArray> polyList_;
  friend class VectorFont;
};

class VectorFont
{
public:
  static VectorFont* instance();
  ~VectorFont();

  void draw(const QChar& character, QPainter* p, QPoint& point);
  void drawText(const QString& text, QPainter* p, QPoint point);

  static int textWidth(const QString& text);

private:
  VectorFont();
  void initialize();

private:
  static VectorFont* instance_;
  static const int charWidth_;
  QMap<char, VectorChar> charMap_;
};

#endif
