/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2001 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef TYPES_H
#define TYPES_H

#include <math.h>
#include <qarray.h>

#ifndef _WS_WIN_
#include <complex.h>
#else
#include <complex>
#endif

typedef double TReal;
typedef QArray<TReal> Vector;

#ifdef _WS_WIN_
typedef std::complex<TReal> TComplex;
#else
typedef complex<TReal> TComplex;
#endif

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#endif
