/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef SUBSTRATEWINDOW_H
#define SUBSTRATEWINDOW_H

#include <qmap.h>
#include <qlist.h>
#include <qdialog.h>
#include <qstring.h>

class QLabel;
class QLineEdit;
class SmithView;
class QComboBox;
class QVBoxLayout;
class SubstrateDefinition;

class SubstrateWindow : public QDialog
{
  Q_OBJECT;
public:
  SubstrateWindow( QWidget* parent, const char * name=0 );
  virtual ~SubstrateWindow();

  void enableNameField( bool );
  void update( const QString& name,
	       const SubstrateDefinition& sub );

private slots:
  void ok();
  void cancel();
  void substrateTypeChanged( int );

private:
  double getValue( const QString& );

private:
  QVBoxLayout* topLayout_;
  QLineEdit* substrateName_;
  QComboBox* substrateType_;
  QLabel* imageLabel_;
  QLineEdit* er_;
  QLineEdit* h_;
  QLineEdit* t_;
  QLineEdit* rho_;
};

#endif

