/*
 * Copyright (C) 2003  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>

#include "ViewPDF.h"
#include "AppController.h"


/*
 * Function protoypes. Wy is this still necessary?
 */
void createMenu();


/*
 * Basic-Initialization and Application startup.
 */
int main(int argc, const char *argv[])
{
   id NSApp;

   NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];

   [AppController sharedController];

   NSApp = [NSApplication sharedApplication];

   createMenu();

   [NSApp setDelegate: [AppController sharedController]];
   
   [NSApp run];

   [[AppController sharedController] release];
   [NSApp release];
   [pool release];

   return EXIT_SUCCESS;
}


/*
 * Create the Applications Menu.
 */
void createMenu()
{
   NSMenu* menu;
   NSMenu* info;
   NSMenu* document;
   NSMenu* edit;
   NSMenu* format;
   NSMenu* navigate;
   NSMenu* display;
   NSMenu* find;
   NSMenu* windows;
   NSMenu* services;

   SEL action = @selector(method:);

   // Application Menu
   menu = [[NSMenu alloc] initWithTitle: APP_NAME];

   [menu addItemWithTitle: @"Info" action: action keyEquivalent: @""];
   [menu addItemWithTitle: @"Document" action: action keyEquivalent: @""];
   [menu addItemWithTitle: @"Edit" action: action keyEquivalent: @""];
   [menu addItemWithTitle: @"Navigate" action: action keyEquivalent: @""];
   [menu addItemWithTitle: @"Display" action: action keyEquivalent: @""];
   //[menu addItemWithTitle: @"Format" action: action keyEquivalent: @""];
   [menu addItemWithTitle: @"Find" action: action keyEquivalent: @""];
   //[menu addItemWithTitle: @"Print" action: @selector(printDocument:) keyEquivalent: @"p"];
   [menu addItemWithTitle: @"Windows" action:action keyEquivalent:@""];
   [menu addItemWithTitle: @"Services" action: action keyEquivalent:@""];
   [menu addItemWithTitle: @"Hide" action: @selector(hide:) keyEquivalent: @"h"];
   [menu addItemWithTitle: @"Quit" action: @selector(terminate:) keyEquivalent: @"q"];

   // Info Menu
   info = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: info forItem: [menu itemWithTitle: @"Info"]];

   [info addItemWithTitle:_(@"Info Panel...") action: @selector(showInfoPanel:)
        keyEquivalent:@""];
   [[info itemWithTitle: @"Info Panel..."] setTarget: [AppController sharedController]];

   //[info addItemWithTitle: @"Preferences" action: @selector(showPrefs:)
   //      keyEquivalent: @""];
   //[[info itemWithTitle: @"Preferences"] setTarget: [AppController sharedController]];

   // Document Menu
   document = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: document forItem: [menu itemWithTitle: @"Document"]];
   
   [document addItemWithTitle: @"Open... " action: @selector(openDocument:)
             keyEquivalent: @"o"];
   [document addItemWithTitle: @"Close" action: @selector(performClose:)
             keyEquivalent: @""];

   // Edit Menu
   edit = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: edit forItem: [menu itemWithTitle: @"Edit"]];

   [edit addItemWithTitle:_(@"Copy") action:@selector(copy:) keyEquivalent:@"c"];

   // Navigation Menu
   navigate = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: navigate forItem: [menu itemWithTitle: @"Navigate"]];

   [navigate addItemWithTitle: @"Next Page" action: @selector(nextPage:)
             keyEquivalent: @"d"];
   [navigate addItemWithTitle: @"Previous Page" action: @selector(previousPage:)
             keyEquivalent: @"b"];
   [navigate addItemWithTitle: @"First Page" action: @selector(firstPage:)
             keyEquivalent: @"B"];
   [navigate addItemWithTitle: @"Last Page" action: @selector(lastPage:)
             keyEquivalent: @"D"];
   [navigate addItemWithTitle: @"Set Bookmark" action: @selector(setBookmark:)
             keyEquivalent: @"J"];
   [navigate addItemWithTitle: @"Go to last Bookmark" action: @selector(gotoLastBookmark:)
             keyEquivalent: @"j"];
   [navigate addItemWithTitle: @"Document Outline" action: @selector(showOutlinePanel:)
             keyEquivalent: @"O"];

   // Display Menu
   display = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: display forItem: [menu itemWithTitle: @"Display"]];
   
   [display addItemWithTitle: @"Zoom in" action: @selector(zoomIn:)
            keyEquivalent: @"+"];
   [display addItemWithTitle: @"Zoom out" action: @selector(zoomOut:)
            keyEquivalent: @"-"];
   [display addItemWithTitle: @"Original Size" action: @selector(zoomToRealSize:)
            keyEquivalent: @"."];
   [display addItemWithTitle: @"Fit in Window" action: @selector(sizePageToFit:)
            keyEquivalent: @"i"];
   [display addItemWithTitle: @"Fit width" action: @selector(sizePageToFitWidth:)
            keyEquivalent: @"I"];
   //[display addItemWithTitle: @"Fit Window" action: @selector(sizeWindowToFit:)
   //         keyEquivalent: @"A"];
   [display addItemWithTitle: @"Toggle Toolbar Visibility"
            action: @selector(toggleToolbarVisible:) keyEquivalent: @"t"];

   // Format Menu
   format = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: format forItem: [menu itemWithTitle: @"Format"]];

   [format addItemWithTitle: @"Page Layout" action: @selector(showPageLayoutPanel:)
           keyEquivalent: @""];

   // Find Menu
   find = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: find forItem: [menu itemWithTitle: @"Find"]];
   
   [find addItemWithTitle: @"Find Panel" action: @selector(showFindPanel:)
         keyEquivalent: @"f"];
   [find addItemWithTitle: @"Next" action: @selector(findNext:)
         keyEquivalent: @"g"];
   [find addItemWithTitle: @"Previous" action: @selector(findPrevious:)
         keyEquivalent: @"G"];

   // Windows Menu
   windows = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: windows forItem: [menu itemWithTitle: @"Windows"]];

   [windows addItemWithTitle: @"Arrange"  action:@selector(arrangeInFront:)
            keyEquivalent:@""];
   [windows addItemWithTitle: @"Miniaturize" action:@selector(performMiniaturize:)
            keyEquivalent:@"m"];
   [windows addItemWithTitle: @"Close" action:@selector(performClose:)
            keyEquivalent:@"w"];

   // Services Menu
   services = [[[NSMenu alloc] init] autorelease];
   [menu setSubmenu: services forItem: [menu itemWithTitle: @"Services"]];


   [[NSApplication sharedApplication] setMainMenu: menu];
   [[NSApplication sharedApplication] setServicesMenu: services];
   [[NSApplication sharedApplication] setWindowsMenu: windows];
}
