/*
 * Copyright (C) 2004  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <AppKit/NSEvent.h>
#include <AppKit/NSWindow.h>
#include "FindView.h"

/**
 * Non-Public methods.
 */
@interface FindView (Private)
- (void) _centerVerticallyInView: (NSView*)aView;
@end


@implementation FindView

- (id) initWithFrame: (NSRect)aFrame
{
   if ((self = [super initWithFrame: aFrame]))
   {
      [self setAutoresizesSubviews: NO];

      text = [[NSTextField alloc] init];
      [text setFrame: NSMakeRect(5, 0, 200, 24)];
      [self _centerVerticallyInView: text];
      [self addSubview: text];
      RELEASE(text);

      NSLog(@"DEBUG %@", [[text nextResponder] description]);
   }

   return self;
}


- (void) dealloc
{
   [super dealloc];
}


- (void) activate
{
   [[text window] makeFirstResponder: text];
}


- (void) deactivate
{
   return;
}

@end


/* ----------------------------------------------------- */
/*  Category Private                                     */
/* ----------------------------------------------------- */

@implementation FindView (Private)

/*
 * Center a view vertically in this view.
 */
- (void) _centerVerticallyInView: (NSView*)aView
{
   NSRect newFrame;
   
   newFrame = NSMakeRect(NSMinX([aView frame]),
                         (NSHeight([self frame]) / 2) - (NSHeight([aView frame]) / 2),
                         NSWidth([aView frame]),
                         NSHeight([aView frame]));

   [aView setFrame: newFrame];
}

@end

