//=======================================================================
// V IDE Make Class - all the stuff needed to create
// makefiles, and run make.
//  Copyright (C) 1995-2000  Bruce E. Wampler
//
//  This program is part of the V C++ GUI Framework example programs.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  (see COPYING) along with this program; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=======================================================================

#include <v/vfilesel.h>
#include <v/vnotice.h>

#include "videapp.h"

#include "videcmdw.h"

#include "videmake.h"

    static int filterIndex = 0;
    static char* filter[] =
      {
        "Make*;make*;Make*.*;make*.*",
        "*",
        0
      };

//=====================>>> videMake::videMake <<<===========================
  videMake::videMake()
  {
    _stop = 0;
    cmdw = ((videApp*)theApp)->GetMsgWindow();

    makeTimer = new makeAuxTimer(this);	// create timer
    makeProc = new vPipedProcess();	// create process object
  }

//=====================>>> videMake::~videMake <<<===========================
  videMake::~videMake()
  {
    makeTimer->TimerStop();
    delete makeTimer;
    makeProc->killProcess();
    delete makeProc;
  }

//=====================>>> videMake::DoMake <<<===========================
  int videMake::DoMake(videCmdWindow* parent, char* makecmd, char* what)
  {
    // New version of DoMake for V 1.11, 1.12 - uses new vPipedProcess class
    char cmd[maxFileNameSize];
    vOS vos;
    int isBorland = ((videApp*)theApp)->getCompiler() == bcc;

    char* mkpath = ((videApp*)theApp)->GetMkFile();
    cmdw = ((videApp*)theApp)->GetMsgWindow();

    if (!*mkpath)
      {
        vNoticeDialog note((vWindow*)cmdw);
        note.Notice("No Makefile specified. Use Select Makefile or Open Project first.");
        return 0;
      }

    if (isBorland)
	(void)fixBackSlash(mkpath,isBorland);
    else
	fixSlash(mkpath);

    cmdw->RaiseWindow();
    cmdw->SetRdOnly(0);
    if (isBorland)
	(cmdw->GetTextEd())->SetFileType(bccError);
    else
	(cmdw->GetTextEd())->SetFileType(gccError);

    // Now, change dir

    changeDir(mkpath);
    
    // build command again without what part
    strcpy(cmd,makecmd);

    if (isBorland)
	strcat(cmd, " -f");             // -f for file
    else
	strcat(cmd, " -f ");		// -n for dry run, -f for file
#ifdef V_VersionWindows
    if (strstr(mkpath," ") != 0)	// has space in name
      {
	strcat(cmd, "\"");		// add quotes for space
	strcat(cmd, mkpath);		// the name of the make file.
	strcat(cmd, "\"");
      }
    else
#endif
    strcat(cmd, mkpath);		// the name of the make file.

    if (what && *what)
      {
	strcat(cmd," ");
	strcat(cmd,what);
      }

    cmdw->AddLine(cmd);

    theApp->CheckEvents();
    _stop = 0;			// not stopping

    strcpy(makeOutLine,"  ! ");		// set up output line
    makeOutNext = 4;

    // ok, have everything ready to go in cmd...

    if (!makeProc->startPipedProcess(cmd))
      {
	cmdw->AddLine("Unable to create make process....");
	cmdw->AddLine(cmd);
	return 0;
      }

    // Now, start the timer to monitor make progress

    makeTimer->TimerSet(300);		// update 3 times a second

    // make is now running and handled by its timer

    return 1;
  }

//==================>>> videMake::checkMakeProgress <<<======================
  void videMake::checkMakeProgress()
  {
    // this will try to echo the output of the Make, and terminate the
    // make on _stop or when done.
    int bytesRead;

    char chrin[10] = "";

    // First, read any characters output
    for ( ; ; )		// read all debugger output available
      {
	// first, see if any output is available...
	bytesRead = makeProc->readChar(chrin);
	if (bytesRead == 0)		// nothing to read!
	    break;
	if (*chrin == '\r')		// ignore these
	     continue;
	else if (*chrin == '\n')		// end of line
	  {
	    makeOutLine[makeOutNext] = 0;
	    if (strstr(makeOutLine,": ") != 0)	// error line
		cmdw->AddLine(makeOutLine);
	    else				// normal line
	      {
		makeOutLine[2] = '>';
		cmdw->AddLine(&makeOutLine[2]);
	      }
	    strcpy(makeOutLine,"  ! ");
	    makeOutNext = 4;
	  }
	else
	  {
	    makeOutLine[makeOutNext++] = *chrin;
	    if (makeOutNext >= makeOutMax)
	      {
		makeOutLine[makeOutNext] = 0;
		if (strstr(makeOutLine,": ") != 0)	// error line
		    cmdw->AddLine(makeOutLine);
		else				// normal line
		  {
		    makeOutLine[2] = '>';
		    cmdw->AddLine(&makeOutLine[2]);
		  }
		strcpy(makeOutLine,"  ! ");
		makeOutNext = 4;
	      }
	  }
      }

    // Second, check for stop
    theApp->CheckEvents();
    if (_stop)
      {
	_stop = 0;
	makeTimer->TimerStop();
	cmdw->AddLine("---- Make Aborted ----");
	cmdw->SetRdOnly(1);
	cmdw->RaiseWindow();
	theApp->CheckEvents();
	makeProc->killProcess();
	return;
      }

    // Third, see if make is finished
    if ( !makeProc->stillRunning() )	// signaled, means done
      {
	makeTimer->TimerStop();
	if (makeProc->getExitCode() != 0)
	    cmdw->AddLine("---- Make had errors. Right click error line to open file.");
	else
	    cmdw->AddLine("---- Make finished ----");
	cmdw->SetRdOnly(1);
	cmdw->RaiseWindow();
	theApp->CheckEvents();
      }

  }


//=======================>>> myAuxTimer::TimerTick <<<=======================
  void makeAuxTimer::TimerTick()
  {
    makeIt->checkMakeProgress();
  }

