//=======================================================================
//  This program is part of the V C++ GUI Framework example programs.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  (see COPYING) along with this program; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//	prefmdlg.cpp:	Source for toolsModalDialog class
//=======================================================================

#include "videapp.h"	// for defs of emulation, etc.
#include "toolsmdlg.h"

    enum {
	lblTMainMsg = 8888,
	lblT1,
	txiT1,
	lblT2,
	txiT2,
	lblT3,
	txiT3,
	lblT4,
	txiT4,
	lblT5,
	txiT5,
	lblT6,
	txiT6,
	lblT7,
	txiT7,
	lblT8,
	txiT8,
	lblTHelp,

	lblHlpMainMsg,
	lblHlp0,
	txiHlp0,
	lblHlp1,
	txiHlp1,
	lblHlp2,
	txiHlp2,
	lblHlp3,
	txiHlp3,
	lblHlp4,
	txiHlp4,
	lblHlp5,
	txiHlp5,
	lblHlp6,
	txiHlp6,
	lblHlp7,
	txiHlp7,
	lblHlp8,
	txiHlp8,
	lblHlp9,
	txiHlp9,
	lblHlpHelp,

	toolsLastOne
    };

    static DialogCmd toolsDefaultCmds[] =
      {
	{C_Label, lblTMainMsg, 0,"Edit Tool Definitions",NoList,CA_None,isSens,NoFrame, 0, 0},

	{C_Label, lblT1, 0, "Tool 1: ",NoList,CA_None,isSens,NoFrame,
		0, lblTMainMsg},
	{C_TextIn, txiT1,0," ",NoList,CA_Large,isSens,NoFrame,
		lblT1,lblTMainMsg,0,"Command definition for Tool"},

	{C_Label, lblT2, 0, "Tool 2: ",NoList,CA_None,isSens,NoFrame,
		0, txiT1},
	{C_TextIn, txiT2,0," ",NoList,CA_Large,isSens,NoFrame,
		lblT2,txiT1,0,"Command definition for Tool"},

	{C_Label, lblT3, 0, "Tool 3: ",NoList,CA_None,isSens,NoFrame,
		0, txiT2},
	{C_TextIn, txiT3,0," ",NoList,CA_Large,isSens,NoFrame,
		lblT3,txiT2,0,"Command definition for Tool"},

	{C_Label, lblT4, 0, "Tool 4: ",NoList,CA_None,isSens,NoFrame,
		0, txiT3},
	{C_TextIn, txiT4,0," ",NoList,CA_Large,isSens,NoFrame,
		lblT4,txiT3,0,"Command definition for Tool"},

	{C_Label, lblT5, 0, "Tool 5: ",NoList,CA_None,isSens,NoFrame,
		0, txiT4},
	{C_TextIn, txiT5,0," ",NoList,CA_Large,isSens,NoFrame,
		lblT5,txiT4,0,"Command definition for Tool"},

	{C_Label, lblT6, 0, "Tool 6: ",NoList,CA_None,isSens,NoFrame,
		0, txiT5},
	{C_TextIn, txiT6,0," ",NoList,CA_Large,isSens,NoFrame,
		lblT6,txiT5,0,"Command definition for Tool"},

	{C_Label, lblT7, 0, "Tool 7: ",NoList,CA_None,isSens,NoFrame,
		0, txiT6},
	{C_TextIn, txiT7,0," ",NoList,CA_Large,isSens,NoFrame,
		lblT7,txiT6,0,"Command definition for Tool"},

	{C_Label, lblT8, 0, "Tool 8: ",NoList,CA_None,isSens,NoFrame,
		0, txiT7},
	{C_TextIn, txiT8,0," ",NoList,CA_Large,isSens,NoFrame,
		lblT8,txiT7,0,"Command definition for Tool"},

	{C_Label, lblTHelp, 0,
	"Definition in form: \"Menu text=command args\"",
	  NoList,CA_None,isSens,NoFrame,0, txiT8},
    
	
	{C_Button, M_Cancel, 0, " Cancel ",NoList,CA_None,
	    isSens,NoFrame,0, lblTHelp},
	{C_Button, M_OK, 0, " OK ", NoList, CA_DefaultButton,
	    isSens, NoFrame, M_Cancel, lblTHelp},

	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
    };

    static DialogCmd helpDefaultCmds[] =
      {
	{C_Label, lblHlpMainMsg, 0,"Edit Help Definitions",NoList,CA_None,isSens,NoFrame, 0, 0},

	{C_Label, lblHlp0, 0, "Help File 0: ",NoList,CA_None,isSens,NoFrame,
		0, lblHlpMainMsg},
	{C_TextIn, txiHlp0,0," ",NoList,CA_Large,isSens,NoFrame,
		lblHlp0,lblHlpMainMsg,0,"Name of help file"},

	{C_Label, lblHlp1, 0, "Help File 1: ",NoList,CA_None,isSens,NoFrame,
		0, lblHlp0},
	{C_TextIn, txiHlp1,0," ",NoList,CA_Large,isSens,NoFrame,
		lblHlp1,lblHlp0,0,"Name of help file"},

	{C_Label, lblHlp2, 0, "Help File 2: ",NoList,CA_None,isSens,NoFrame,
		0, txiHlp1},
	{C_TextIn, txiHlp2,0," ",NoList,CA_Large,isSens,NoFrame,
		lblHlp2,txiHlp1,0,"Name of help file"},

	{C_Label, lblHlp3, 0, "Help File 3: ",NoList,CA_None,isSens,NoFrame,
		0, txiHlp2},
	{C_TextIn, txiHlp3,0," ",NoList,CA_Large,isSens,NoFrame,
		lblHlp3,txiHlp2,0,"Name of help file"},

	{C_Label, lblHlp4, 0, "Help File 4: ",NoList,CA_None,isSens,NoFrame,
		0, txiHlp3},
	{C_TextIn, txiHlp4,0," ",NoList,CA_Large,isSens,NoFrame,
		lblHlp4,txiHlp3,0,"Name of help file"},

	{C_Label, lblHlp5, 0, "Help File 5: ",NoList,CA_None,isSens,NoFrame,
		0, txiHlp4},
	{C_TextIn, txiHlp5,0," ",NoList,CA_Large,isSens,NoFrame,
		lblHlp5,txiHlp4,0,"Name of help file"},

	{C_Label, lblHlp6, 0, "Help File 6: ",NoList,CA_None,isSens,NoFrame,
		0, txiHlp5},
	{C_TextIn, txiHlp6,0," ",NoList,CA_Large,isSens,NoFrame,
		lblHlp6,txiHlp5,0,"Name of help file"},

	{C_Label, lblHlp7, 0, "Help File 7: ",NoList,CA_None,isSens,NoFrame,
		0, txiHlp6},
	{C_TextIn, txiHlp7,0," ",NoList,CA_Large,isSens,NoFrame,
		lblHlp7,txiHlp6,0,"Name of help file"},

	{C_Label, lblHlp8, 0, "Help File 8: ",NoList,CA_None,isSens,NoFrame,
		0, txiHlp7},
	{C_TextIn, txiHlp8,0," ",NoList,CA_Large,isSens,NoFrame,
		lblHlp8,txiHlp7,0,"Name of help file"},

	{C_Label, lblHlp9, 0, "Help File 9: ",NoList,CA_None,isSens,NoFrame,
		0, txiHlp8},
	{C_TextIn, txiHlp9,0," ",NoList,CA_Large,isSens,NoFrame,
		lblHlp9,txiHlp8,0,"Name of help file"},

	{C_Label, lblHlpHelp, 0,
	"Definition in form: \"Menu text=helpfile.htm\"",
	  NoList,CA_None,isSens,NoFrame,0, txiHlp9},
    
	
	{C_Button, M_Cancel, 0, " Cancel ",NoList,CA_None,
	    isSens,NoFrame,0, lblHlpHelp},
	{C_Button, M_OK, 0, " OK ", NoList, CA_DefaultButton,
	    isSens, NoFrame, M_Cancel, lblHlpHelp},

	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
    };

//##################################################################################
//##################################################################################

//======================>>> toolsModalDialog::toolsModalDialog <<<==================
  toolsModalDialog::toolsModalDialog(vBaseWindow* bw, char* title) :
    vModalDialog(bw, title)
  {
    cmdWin = (videCmdWindow*)bw;

    AddDialogCmds(toolsDefaultCmds);		// add the predefined commands
  }

//===================>>> toolsModalDialog::~toolsModalDialog <<<====================
  toolsModalDialog::~toolsModalDialog()
  {
    UserDebug(Destructor,"toolsModalDialog::~toolsModalDialog() destructor\n")
  }

//====================>>> toolsModalDialog::setTools <<<====================
  int toolsModalDialog::setTools(char* msg)
  {
    ItemVal ans,rval;

    char buff[maxFileNameSize];

    ans = ShowModalDialog(msg,rval);
    if (ans == M_Cancel)
	return 0;

    // *** Code to process dialog values here

    GetTextIn(txiT1,buff,maxFileNameSize);
    ((videApp*)theApp)->setTool(0,buff);
    GetTextIn(txiT2,buff,maxFileNameSize);
    ((videApp*)theApp)->setTool(1,buff);
    GetTextIn(txiT3,buff,maxFileNameSize);
    ((videApp*)theApp)->setTool(2,buff);
    GetTextIn(txiT4,buff,maxFileNameSize);
    ((videApp*)theApp)->setTool(3,buff);
    GetTextIn(txiT5,buff,maxFileNameSize);
    ((videApp*)theApp)->setTool(4,buff);
    GetTextIn(txiT6,buff,maxFileNameSize);
    ((videApp*)theApp)->setTool(5,buff);
    GetTextIn(txiT7,buff,maxFileNameSize);
    ((videApp*)theApp)->setTool(6,buff);
    GetTextIn(txiT8,buff,maxFileNameSize);
    ((videApp*)theApp)->setTool(7,buff);
    
    return ans == M_OK;
  }

//====================>>> toolsModalDialog::DialogDisplayed <<<====================
  void toolsModalDialog::DialogDisplayed()
  {
    // Set dialog values to current values

    SetString(txiT1,((videApp*)theApp)->getTool(0));
    SetString(txiT2,((videApp*)theApp)->getTool(1));
    SetString(txiT3,((videApp*)theApp)->getTool(2));
    SetString(txiT4,((videApp*)theApp)->getTool(3));
    SetString(txiT5,((videApp*)theApp)->getTool(4));
    SetString(txiT6,((videApp*)theApp)->getTool(5));
    SetString(txiT7,((videApp*)theApp)->getTool(6));
    SetString(txiT8,((videApp*)theApp)->getTool(7));
  }

//====================>>> toolsModalDialog::DialogCommand <<<====================
  void toolsModalDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
  {

//    switch (id)		// We will do some things depending on value
//      {
//      }

    vModalDialog::DialogCommand(id,retval,ctype);
  }
  
//##################################################################################

//======================>>> helpModalDialog::helpModalDialog <<<==================
  helpModalDialog::helpModalDialog(vBaseWindow* bw, char* title) :
    vModalDialog(bw, title)
  {
    cmdWin = (videCmdWindow*)bw;

    AddDialogCmds(helpDefaultCmds);		// add the predefined commands
  }

//===================>>> helpModalDialog::~helpModalDialog <<<====================
  helpModalDialog::~helpModalDialog()
  {
    UserDebug(Destructor,"helpModalDialog::~helpModalDialog() destructor\n")
  }

//====================>>> helpModalDialog::setTools <<<====================
  int helpModalDialog::setupHelp(char* msg)
  {
    ItemVal ans,rval;

    char buff[maxFileNameSize];

    ans = ShowModalDialog(msg,rval);
    if (ans == M_Cancel)
	return 0;

    // *** Code to process dialog values here

    GetTextIn(txiHlp0,buff,maxFileNameSize);
    ((videApp*)theApp)->setHelpFile(0,buff);
    GetTextIn(txiHlp1,buff,maxFileNameSize);
    ((videApp*)theApp)->setHelpFile(1,buff);
    GetTextIn(txiHlp2,buff,maxFileNameSize);
    ((videApp*)theApp)->setHelpFile(2,buff);
    GetTextIn(txiHlp3,buff,maxFileNameSize);
    ((videApp*)theApp)->setHelpFile(3,buff);
    GetTextIn(txiHlp4,buff,maxFileNameSize);
    ((videApp*)theApp)->setHelpFile(4,buff);
    GetTextIn(txiHlp5,buff,maxFileNameSize);
    ((videApp*)theApp)->setHelpFile(5,buff);
    GetTextIn(txiHlp6,buff,maxFileNameSize);
    ((videApp*)theApp)->setHelpFile(6,buff);
    GetTextIn(txiHlp7,buff,maxFileNameSize);
    ((videApp*)theApp)->setHelpFile(7,buff);
    GetTextIn(txiHlp8,buff,maxFileNameSize);
    ((videApp*)theApp)->setHelpFile(8,buff);
    GetTextIn(txiHlp8,buff,maxFileNameSize);
    ((videApp*)theApp)->setHelpFile(9,buff);
    
    return ans == M_OK;
  }

//====================>>> helpModalDialog::DialogDisplayed <<<====================
  void helpModalDialog::DialogDisplayed()
  {
    // Set dialog values to current values

    SetString(txiHlp0,((videApp*)theApp)->getHelpFile(0));
    SetString(txiHlp1,((videApp*)theApp)->getHelpFile(1));
    SetString(txiHlp2,((videApp*)theApp)->getHelpFile(2));
    SetString(txiHlp3,((videApp*)theApp)->getHelpFile(3));
    SetString(txiHlp4,((videApp*)theApp)->getHelpFile(4));
    SetString(txiHlp5,((videApp*)theApp)->getHelpFile(5));
    SetString(txiHlp6,((videApp*)theApp)->getHelpFile(6));
    SetString(txiHlp7,((videApp*)theApp)->getHelpFile(7));
    SetString(txiHlp8,((videApp*)theApp)->getHelpFile(8));
    SetString(txiHlp9,((videApp*)theApp)->getHelpFile(9));
  }

//====================>>> helpModalDialog::DialogCommand <<<====================
  void helpModalDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
  {

//    switch (id)		// We will do some things depending on value
//      {
//      }

    vModalDialog::DialogCommand(id,retval,ctype);
  }
  
  
