/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_logo.h>
#include <vdkb/vdkb.h>
#include <config.h>

DEFINE_SIGNAL_MAP(VDKBLogo,VDKForm)
  ON_SIGNAL(timer,timer_tick_signal,OnTimer)
END_SIGNAL_MAP
static char buff[256];
/*
 */
VDKBLogo::VDKBLogo(VDKForm* owner):
  VDKForm(owner,NULL,v_box,GTK_WINDOW_POPUP)
{
}
/*
 */
VDKBLogo::~VDKBLogo() {}
/*
 */
void
VDKBLogo::OnShow(VDKForm*)
{
  struct stat info;
  char local[128];
  /*
    this useful trick permits to process all pending events
    before entering into time-consuming operations
    such as one below (loading a big and higly coloured pixmap)
  */
  sprintf(local,"%s %s\n%s",PACKAGE,VERSION,_("Loading logo pixmap.."));
  ShowMessage(local);
  while(gtk_events_pending())
    gtk_main_iteration();

  VDKBuilder* app = (VDKBuilder*) Application();
  sprintf(buff,"%s/.vdkb/%s",(char*) app->user_home,VDKB_LOGO);
  if (stat(buff,&info) == -1)
    sprintf(buff,"%s/%s",VDKB_DATADIR,VDKB_LOGO);
  VDKRawPixmap *rawpixmap = new VDKRawPixmap(this,buff);
  VDKPoint size(rawpixmap->Width(),rawpixmap->Height());
  Visible = false;
  SetFormSize(size);
  VDKPixmap *pixmap = new VDKPixmap(this,(char*) NULL);
  pixmap->SetPixmap(rawpixmap);
  frame->RemoveObject(label);
  frame ->Add(pixmap);
  timer = new VDKTimer(this,4000,true);
  Show(GTK_WIN_POS_CENTER);
}
/*
 */
void
VDKBLogo::Setup()
{
  gtk_window_position(GTK_WINDOW(Window()),GTK_WIN_POS_CENTER);
  Box()->BorderWidth(0);
  frame = new VDKFrame(this);
  frame->BorderWidth(0);
  frame->Shadow = shadow_out;
  label = new VDKLabel(this, _("VDKBuilder: Initializing..."));
  frame->Add(label,r_justify);
  Add(frame);
}

/*
 */
bool
VDKBLogo::OnTimer(VDKObject*)
{
Close();
return true;
}
/*
 */
void
VDKBLogo::ShowMessage(char* msg)
{
  label->Caption = msg;
}

