/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.3
 * July 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_grid.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_objinspect.h>
#include <vdkb/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb/vdkb_tabledlg.h>
#include <vdkb/vdkb_scrolled.h>
#include <vdkb/vdkb_fixed.h>

/*
================================
symbolic constants to templatize
a bit
================================
*/
// for methods and other stuff
#define CLASS VDKBGrid
// put here vdk class name string
#define VDK_CLASS "VDKGrid"
// put here vdk class name
#define VDK_ANCESTOR  VDKGrid
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "grid"
// for common events
extern char* wi_widget_prompts[];
static char buff[128];

int CLASS::Counter = 0;
/*
 properties
 */
char* vdkgrid_props[] =
{
COLWIDTH,ROWHEIGHT,
ROWS_INTERNAL,COLUMNS_INTERNAL,
COLVISIBLE,ROWVISIBLE,
EDITABLE,VIEWPORT_INTERNAL,
0
};

//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
///////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner, int rows, int cols,
		   bool editable):
  VDK_ANCESTOR(owner,rows,cols,editable,name),VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time
  Counter++;
   for(t=0; vdkgrid_props[t]; t++)
    proplist.add(VDKBProperty(vdkgrid_props[t]));

  SetPropValue(JUSTIFY_INTERNAL,"l_justify");
  SetPropValue(EXPAND_INTERNAL,CHECK_TRUE);
  SetPropValue(FILL_INTERNAL,CHECK_TRUE);
  sprintf(buff,"%d",rows);
  SetPropValue(ROWS_INTERNAL,buff);
  sprintf(buff,"%d",cols);
  SetPropValue(COLUMNS_INTERNAL,buff);
  SetPropValue(EDITABLE,editable ? CHECK_TRUE : CHECK_FALSE);
  SetPropValue(VIEWPORT_INTERNAL,CHECK_FALSE);
  SetPropValue(COLVISIBLE,CHECK_TRUE);
  SetPropValue(ROWVISIBLE,CHECK_TRUE);
  // assign this to VDKBObject <object> member.
  object = this;
  // connects events.
  CONNECT_COMMON_EVENTS;
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
  // connect global selection button in order to stop clicked signal
  // emission too.
  GtkSheet* sheet = GTK_SHEET(ObjectFromVDK()->Widget());
  gtk_widget_set_sensitive(sheet->button,0);
  gtk_signal_connect(GTK_OBJECT(sheet->button),"clicked",
		     GTK_SIGNAL_FUNC(CLASS::OnGlobalButtonClicked),
		     (gpointer) NULL);
}

void
CLASS::OnGlobalButtonClicked(GtkWidget* wid, gpointer gp)
{
  gtk_signal_emit_stop_by_name(GTK_OBJECT(wid), "clicked");
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;",
	  PROP_ROWS_INTERNAL, (char*) GetProp(ROWS_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_COLUMNS_INTERNAL,(char*) GetProp(COLUMNS_INTERNAL));
  fprintf(fp,"\n\t%s%s;",
	  PROP_EDITABLE,(char*) GetProp(EDITABLE));
  bool viewport = dynamic_cast<VDKBScrolled*>(parentobj) != NULL;
  fprintf(fp,"\n\t%s%s;",
	  PROP_VIEWPORT_INTERNAL,viewport ? CHECK_TRUE :CHECK_FALSE);
  fprintf(fp,"\n\t%s%s;",
	  PROP_ROWVISIBLE,(char*) GetProp(ROWVISIBLE));
  fprintf(fp,"\n\t%s%s;",
	  PROP_COLVISIBLE,(char*) GetProp(COLVISIBLE));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
On return:
0 - successfull
1 - unsupported widget
2 - target is not a container
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  int r = 8,c = 4;
  Vdkb_tabledlgForm* dlg;
  CLASS* Grid = NULL;

  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2;
  else
    {
      dlg = new Vdkb_tabledlgForm(owner,NULL,&r,&c);
      dlg->Setup();
      dlg->ShowModal();
      // user cancelled
      if (!r || !c)
	return 3;
      else
	Grid = new CLASS(buff,owner,r,c);
    }
  // add widget to form
  return owner->AddToSelf(Grid,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  // gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  source = new char[4096];
  // rows, columns
  int rows = 8,cols = 4;
  if(parser.GetParam(arg,buffer,PROP_ROWS_INTERNAL))
    rows = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_COLUMNS_INTERNAL))
    cols = atoi(arg);
  bool  editable = false;
  if(parser.GetParam(arg,buffer,PROP_EDITABLE))
    editable = !strcmp(arg,CHECK_TRUE);
  sprintf(tmp,"\n%s = new %s(this,%d,%d,%s);",
	  obj_name,
	  VDK_CLASS,
	  rows,cols,
	  editable ? CHECK_TRUE : CHECK_FALSE);
  strcpy(source,tmp);
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  // prepares arguments to add widget to container
  char justify[16],expand[16],fill[16],padding[16];
  bool viewport = false;
  if(parser.GetParam(arg,buffer,PROP_VIEWPORT_INTERNAL))
    viewport = !strcmp(arg,CHECK_TRUE);
  if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
     parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
     parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
     parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
    {
      sprintf(tmp,"\n%s->%s(%s,%s,%s,%s,%s);",
	      obj_parent,
	      viewport ? "AddWithoutViewport" : "Add",
	      obj_name,justify,expand,fill,padding);
      strcat(source,tmp);
    }
  else
    {
      sprintf(tmp,"\n%s->%s(%s);",
	      obj_parent,
	      viewport ? "AddWithoutViewport" : "Add",
	      obj_name);
      strcat(source,tmp);
    }

  if(parser.GetParam(arg,buffer,PROP_ROWVISIBLE) &&
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s = %s;",
	     obj_name,ROWVISIBLE,arg);
     strcat(source,tmp);
   }
  if(parser.GetParam(arg,buffer,PROP_COLVISIBLE) &&
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s = %s;",
	     obj_name,COLVISIBLE,arg);
     strcat(source,tmp);
   }
  // visible property must be wrote after adding it to a parent
  // container. That's the reason why is written here and not
  // in vdkb_object class as should be.
  // written only if == false
  if(parser.GetParam(arg,buffer,PROP_VISIBLE) &&
     !strcmp(arg,CHECK_FALSE))
   {
     sprintf(tmp,"\n%s->%s = %s;",obj_name,VISIBLE,arg);
     strcat(source,tmp);
   }
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner,
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char arg[32];
  CLASS* Grid;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return false;
  int rows = 8,cols = 4;
  if(parser.GetParam(arg,buffer, PROP_ROWS_INTERNAL))
    rows = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_COLUMNS_INTERNAL))
    cols = atoi(arg);
  bool  editable = false;
  if(parser.GetParam(arg,buffer,PROP_EDITABLE))
    editable = !strcmp(arg,CHECK_TRUE);
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ?
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      Grid = new CLASS(obj_name,owner,rows,cols,editable);
      if(parser.GetParam(arg,buffer,PROP_ROWVISIBLE) &&
	 strcmp(arg,NIHIL_PROP))
	{
	  Grid->SetPropValue(ROWVISIBLE,arg);
	  Grid->RowTitleVisible = !strcmp(arg,CHECK_TRUE);
	}
      if(parser.GetParam(arg,buffer,PROP_COLVISIBLE) &&
	 strcmp(arg,NIHIL_PROP))
	{
	  Grid->SetPropValue(COLVISIBLE,arg);
	  Grid->ColumnTitleVisible = !strcmp(arg,CHECK_TRUE);
	}
      // pack widget to container
      return owner->PackToSelf(Grid, container, buffer, parser);
    }
  else
    return false;
}

/*
 */
VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  VDKString True = CHECK_TRUE;
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  VDKTable *table = new VDKTable(inspector,2,2);
  table->SetSize(219,-1);

  rowvisible = new VDKCheckButton(inspector,_(wi_widget_prompts[37]));
  table->AddToCell(rowvisible,0,0);
  rowvisible->Checked = GetProp(ROWVISIBLE) == True;
  rowvisible->Parent(this);
  SignalConnect(rowvisible,"toggled",&CLASS::OnSetRowVisible);

  colvisible = new VDKCheckButton(inspector,_(wi_widget_prompts[38]));
  table->AddToCell(colvisible,0,1);
  colvisible->Checked = GetProp(COLVISIBLE) == True;
  colvisible->Parent(this);
  SignalConnect(colvisible,"toggled",&CLASS::OnSetColVisible);

  editable_check = new VDKCheckButton(inspector,_(wi_widget_prompts[2]));
  table->AddToCell(editable_check,1,0);
  editable_check->Checked = GetProp(EDITABLE) == True;
  editable_check->Parent(this);
  SignalConnect(editable_check,"toggled",&CLASS::OnSetEditable);

  bframe->Add(table,l_justify,false,false,false);
  return bframe;
}

/*
 */
bool
CLASS::OnSetRowVisible(VDKObject*)
{
  SetPropValue(ROWVISIBLE,
	       rowvisible->Checked ? CHECK_TRUE : CHECK_FALSE);
  RowTitleVisible = rowvisible->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}

/*
 */
bool
CLASS::OnSetColVisible(VDKObject*)
{
  SetPropValue(COLVISIBLE,
	       colvisible->Checked ? CHECK_TRUE : CHECK_FALSE);
  ColumnTitleVisible = colvisible->Checked ? true : false;
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetEditable(VDKObject*)
{
  SetPropValue(EDITABLE,
	       editable_check->Checked ? CHECK_TRUE : CHECK_FALSE);
  inspector->FormNeedToBeChanged();
  return true;
}




