/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef TOOLELEMENTS_H
#define TOOLELEMENTS_H

gboolean tool_physic_getElementFromZ(gchar **name, float *radcov, int zele);
gboolean tool_physic_getElementFromSymbol(int *zele, float *radcov, gchar *symbol);

/**
 * ToolUnits:
 * @unit_undefined: the units are undefined.
 * @unit_bohr: the length are given in Bohr (1ang = 0.529177Bohr);
 * @unit_angstroem: the length are given in angstroems ;
 * @unit_nanometer: the length are given in nanometers.
 * @nb_units: private.
 *
 * The possible length units defined in V_Sim. The special case
 * @unit_undefined means that a unit must be defined before any
 * conversion operations may be done.
 *
 * Since: 3.5
 */
typedef enum
  {
    unit_undefined,
    unit_bohr,
    unit_angstroem,
    unit_nanometer,
    /*< private >*/
    nb_units
  } ToolUnits;
const gchar** tool_physic_getUnitNames(void);
float tool_physic_getUnitValueInMeter(ToolUnits unit);
ToolUnits tool_physic_getUnitFromName(const gchar *name);


#endif
