/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "panelDataFile.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include <gtk_main.h>
#include <visu_object.h>
#include <visu_tools.h>
#include <visu_gtk.h>
#include <visu_configFile.h>
#include <support.h>
#include <coreTools/toolConfigFile.h>
#include <extraFunctions/dataFile.h>
#include <extraGtkFunctions/gtk_numericalEntryWidget.h>
#include <extraGtkFunctions/gtk_toolPanelWidget.h>
#include <extraGtkFunctions/gtk_shadeComboBoxWidget.h>

/* Local variables. */
static GtkWidget *panelDataFile;
static int nbColumns;
static gboolean panelDataFileIsInitiated;
static gboolean flagDataFileIsLoaded;
static gboolean flagDisableCallbacks;
static gchar *fileExt;
static gchar *currentDataFile;

#define RED_DATA_LABEL   _("R")
#define GREEN_DATA_LABEL _("G")
#define BLUE_DATA_LABEL  _("B")
#define HUE_DATA_LABEL   _("H")
#define SAT_DATA_LABEL   _("S")
#define VAL_DATA_LABEL   _("V")

char* labelRGB[3];
char* labelHSV[3];

#define COL_ONE          "1."
#define COL_COORD_X      _("coord. x")
#define COL_COORD_Y      _("coord. y")
#define COL_COORD_Z      _("coord. z")
#define N_STATIC_COLS    4

#define COLOR_PREVIEW_WIDTH  120
#define COLOR_PREVIEW_HEIGHT 15
#define COLOR_PREVIEW_BITS   8

#define COLOR_TRANSFORMATION_WIDTH  60
#define COLOR_TRANSFORMATION_HEIGHT 40

#define MIN_MAX_NO_DATA_FILE _("<span style=\"italic\">No data file loaded</span>")
#define DATA_FILE_NO_FILE_MESSAGE _("No data file")

#define FLAG_PARAMETER_FILEEXT   "dataFile_fileExtension"
#define DESC_PARAMETER_FILEEXT   "The extension used for data file ; chain e.g. '.dat'"
#define PARAMETER_FILEEXT_DEFAULT    ".dat"

/* Local methods. */
static void createInteriorDataFile();
static void updateNormalisationWidgets(VisuData *data);
static void updateStatusBar(gchar *file, int nb);
static void updateColourWidgets(VisuData *data);
static void updatePostWidgets(VisuData *data);
static void makeColorPreview(VisuData *data);

/* Linkable widgets */
static GtkWidget *vBoxDataFileOption, *vboxNormalize;
static GtkWidget *openDataFileButton;
static GtkWidget *checkbuttonData;
static GtkWidget *checkbuttonAutoLoad;
static GtkWidget *statusbarDataFile;
static guint statusDataFileContextId;
static GtkWidget *expanderNormalize, *expanderPostProcessing;
static GtkWidget *radioNormalized;
static GtkWidget *radioMinMax;
static GtkWidget *entryDataMax;
static GtkWidget *entryDataMin;
static GtkWidget *spinbuttonDataChA[3];
static GtkWidget *spinbuttonDataChB[3];
static GtkWidget *comboboxDataCh[4];
static GtkWidget *radiobuttonDataRGB;
static GtkWidget *radiobuttonDataHSV;
static GtkWidget *labelChannel[3];
static GdkPixbuf *pixbufColorPreview;
static GtkWidget *colorPreview;
static GtkWidget *labelPreview;
static GtkWidget *readMinMaxValues;
static GtkWidget *comboPreSetColorRange;
static GtkWidget *checkHideMinValues;
static GtkWidget *spinHideMinValues;
static GtkWidget *entryHideMinValues;
static GtkWidget *entryFileExtension;
static GtkWidget *tableLinearShade;
static GtkWidget *checkScaleRadius;

/* Signals that need to be suspended */
static gulong signalCheckDataFile;
static gulong signalComboColumnId[4];
static gulong signalSpinDataChA[3];
static gulong signalSpinDataChB[3];
static gulong signalComboShade;
static gulong signalRadioRGB;
static gulong signalRadioHSV;
static gulong signalAskForHide;

/* Callbacks */
static void visuFileReset(GObject *obj, VisuData *dataObj, gpointer data);
static void onDataNew(GObject *obj, VisuData *dataObj, gpointer data);
static void loadDataFile(GtkButton *button, gpointer data);
static void useDataFileColor(GtkToggleButton *toggle, gpointer data);
static void onScaleTypeChange(GtkToggleButton *toggle, gpointer data);
static void onEntryMinMaxChangeValue(NumericalEntry *entry,
				     double oldValue, gpointer data);
static void onSpinChChangeValue(GtkSpinButton *spinbutton, gpointer user_data);
static void onComboColChange(GtkComboBox *combo, gpointer data);
static void onColorTypeChange(GtkToggleButton *toggle, gpointer data);
static void onColorPreSetChange(ShadeComboBox *combo, Shade *shade, gpointer data);
static void onSpinHideMinValuesChange(GtkSpinButton *spin, gpointer data);
static void onEntryHideMinValuesChange(NumericalEntry *entry,
				       double oldValue, gpointer data);
static void onCheckHideMinValuesChange(GtkToggleButton *toggle, gpointer data);
static void onCheckScaleRadiusChange(GtkToggleButton *toggle, gpointer data);
static void onComboScaleChange(GtkComboBox *combo, gpointer data);
static void onAskForHideNodes(VisuData *visuData, gboolean *redraw, gpointer data);
static void onDataFileEnter(ToolPanel *toolPanel, gpointer data);

/* Local methods. */
static void applyHideMinValues(VisuData *visuData, gboolean askRedraw);
static gboolean readFileExt(gchar **lines, int nbLines, int position,
				 VisuData *dataObj, GError **error);
static void exportParameters(GString *data, VisuData* dataObj);



ToolPanel* panelDataFileInit()
{
  char *cl = _("Colorize with data");
  char *tl = _("Data color");
  VisuConfigFileEntry *resourceEntry;

  labelRGB[0] = RED_DATA_LABEL;
  labelRGB[1] = GREEN_DATA_LABEL;
  labelRGB[2] = BLUE_DATA_LABEL;
  labelHSV[0] = HUE_DATA_LABEL;
  labelHSV[1] = SAT_DATA_LABEL;
  labelHSV[2] = VAL_DATA_LABEL;

  panelDataFile = toolPanelNew_withIconFromPath("Panel_colorise", cl, tl,
						"stock-data_20.png");
  if (!panelDataFile)
    return (ToolPanel*)0;
  toolPanelSet_dockable(TOOL_PANEL(panelDataFile), TRUE);
						 
  /* Local variables */
  checkbuttonData = gtk_check_button_new_with_mnemonic(_("_Use color scheme"));
  entryFileExtension = (GtkWidget*)0;
  tableLinearShade   = (GtkWidget*)0;
  panelDataFileIsInitiated = FALSE;
  flagDataFileIsLoaded = FALSE;
  flagDisableCallbacks = FALSE;
  fileExt = g_strdup(PARAMETER_FILEEXT_DEFAULT);
  currentDataFile = (gchar*)0;

  /* Dealing with parameters. */
  resourceEntry = visuConfigFileAdd_entry(VISU_CONFIGFILE_PARAMETER,
					  FLAG_PARAMETER_FILEEXT,
					  DESC_PARAMETER_FILEEXT,
					  1, readFileExt);
  visuConfigFileSet_version(resourceEntry, 3.4f);
  visuConfigFileAdd_exportFunction(VISU_CONFIGFILE_PARAMETER,
				   exportParameters);

  /* Local callbacks. */
  g_signal_connect(G_OBJECT(panelDataFile), "page-entered",
		   G_CALLBACK(onDataFileEnter), (gpointer)0);

  return TOOL_PANEL(panelDataFile);
}

static void createInteriorDataFile()
{
  GtkWidget *containerDataFilePanel;
  GtkWidget *scrolledwindow1;
  GtkWidget *viewport1;
  GtkWidget *vbox;
  GtkWidget *vboxLimits, *vboxTransformation, *vboxPostProcessing;
  GtkWidget *hbox3;
  GtkWidget *alignment2;
  GtkWidget *hbox8;
  GSList *radioNormalized_group = NULL;
  GtkWidget *alignment3;
  GtkWidget *table2;
  GtkWidget *label7;
  GtkWidget *label8;
  GtkWidget *hbox6;
  GSList *radiobuttonDataRGB_group = NULL;
  GtkWidget *label;
  GtkWidget *label14;
  GtkWidget *label15;
  GtkWidget *label16;
  GtkWidget *label20;
  GtkWidget *label21;
  GtkObject *spinbuttonDataChA1_adj;
  GtkObject *spinbuttonDataChA2_adj;
  GtkObject *spinbuttonDataChA3_adj;
  GtkObject *spinbuttonDataChB1_adj;
  GtkObject *spinbuttonDataChB2_adj;
  GtkObject *spinbuttonDataChB3_adj;
  GtkWidget *expanderTransformation;
  GtkWidget *hrule;
  GtkWidget *hboxPreSetColorRange;
  gint i;
  VisuData *dataObj;
#if GTK_MINOR_VERSION < 12
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();
#endif

  DBG_fprintf(stderr, "Panel DataFile : creating subpanel.\n");

  containerDataFilePanel = gtk_vbox_new (FALSE, 0);

  gtk_box_pack_start (GTK_BOX (containerDataFilePanel), checkbuttonData, FALSE, FALSE, 0);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (containerDataFilePanel), scrolledwindow1, TRUE, TRUE, 0);

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), viewport1);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (viewport1), vbox);
  vBoxDataFileOption = vbox;
  gtk_widget_set_sensitive(vBoxDataFileOption, FALSE);

  /********************/
  /* The Data subset. */
  /********************/
  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox3, FALSE, FALSE, 0);

  checkbuttonAutoLoad = gtk_check_button_new_with_mnemonic(_("_Auto load data"));
  gtk_box_pack_end(GTK_BOX(hbox3), checkbuttonAutoLoad, FALSE, FALSE, 0);
  gtk_widget_set_tooltip_text(checkbuttonAutoLoad,
			_("Try to load a data file whenever a new V_Sim file is loaded."
			  " For example, if 'example.ascii' has just been opened, V_Sim"
			  " will look for 'example.dat' and will apply it."));

  openDataFileButton = gtk_button_new_from_stock (GTK_STOCK_OPEN);
  gtk_widget_set_tooltip_text(openDataFileButton,
		       _("Choose a file to read the colorization data from."));
  gtk_box_pack_start(GTK_BOX(hbox3), openDataFileButton, FALSE, FALSE, 0);
  
  entryFileExtension = gtk_entry_new();
  gtk_entry_set_width_chars(GTK_ENTRY(entryFileExtension), 4);
  gtk_entry_set_text(GTK_ENTRY(entryFileExtension), fileExt);
  gtk_box_pack_start(GTK_BOX(hbox3), entryFileExtension, FALSE, FALSE, 5);
  gtk_widget_set_tooltip_text(entryFileExtension,
		       _("File extension used for the autoload option, its value is"
			 " saved in the parameter file (see 'dataFile_fileExt')."));

  vboxNormalize = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), vboxNormalize, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vboxNormalize), hbox3, FALSE, FALSE, 0);

  label = gtk_label_new(_("Normalize input: "));
  gtk_widget_set_name(label, "label_head");
  gtk_misc_set_alignment (GTK_MISC (label), 0., 0.5);
  gtk_box_pack_start (GTK_BOX (hbox3), label, TRUE, TRUE, 0);

  radioNormalized = gtk_radio_button_new_with_mnemonic (NULL, _("auto"));
  gtk_box_pack_start (GTK_BOX (hbox3), radioNormalized, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radioNormalized), radioNormalized_group);
  radioNormalized_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radioNormalized));

  radioMinMax = gtk_radio_button_new_with_mnemonic (NULL, _("manual"));
  gtk_box_pack_start (GTK_BOX (hbox3), radioMinMax, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radioMinMax), radioNormalized_group);
  radioNormalized_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radioMinMax));

  expanderNormalize = gtk_expander_new(_("More information"));
  gtk_box_pack_start(GTK_BOX(vboxNormalize), expanderNormalize, FALSE, FALSE, 0);

  alignment3 = gtk_alignment_new(0.5, 0.5, 1, 1);
  gtk_alignment_set_padding(GTK_ALIGNMENT(alignment3), 0, 0, 15, 0);
  gtk_container_add(GTK_CONTAINER(expanderNormalize), alignment3);

  vboxLimits = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(alignment3), vboxLimits);

  label = gtk_label_new(_("<b>Input data bounds:</b>"));
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0., 0.5);
  gtk_box_pack_start(GTK_BOX(vboxLimits), label, FALSE, FALSE, 0);

  alignment3 = gtk_alignment_new(0.5, 0.5, 0.8, 1);
  gtk_box_pack_start(GTK_BOX(vboxLimits), alignment3, FALSE, FALSE, 0);

  table2 = gtk_table_new (1, 4, FALSE);
  gtk_container_add (GTK_CONTAINER (alignment3), table2);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 3);

  entryDataMax = numericalEntry_new(1.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryDataMax), 6);
  gtk_table_attach (GTK_TABLE (table2), entryDataMax, 3, 4, 0, 1,
                    GTK_FILL | GTK_EXPAND, (GtkAttachOptions)0, 0, 0);
  gtk_widget_set_sensitive(entryDataMax, FALSE);

  entryDataMin = numericalEntry_new(-1.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryDataMin), 6);
  gtk_table_attach (GTK_TABLE (table2), entryDataMin, 1, 2, 0, 1,
                    GTK_FILL | GTK_EXPAND, (GtkAttachOptions)0, 0, 0);
  gtk_widget_set_sensitive(entryDataMin, FALSE);

  label7 = gtk_label_new (_("Min:"));
  gtk_table_attach (GTK_TABLE (table2), label7, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label7), 1, 0.5);

  label8 = gtk_label_new (_("Max:"));
  gtk_table_attach (GTK_TABLE (table2), label8, 2, 3, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label8), 1, 0.5);

  label = gtk_label_new(_("<b>Read min/max values:</b>"));
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_misc_set_alignment(GTK_MISC(label), 0., 0.5);
  gtk_box_pack_start(GTK_BOX(vboxLimits), label, FALSE, FALSE, 0);

  readMinMaxValues = gtk_alignment_new (0.5, 0.5, 0.8, 1);
  gtk_box_pack_start (GTK_BOX(vboxLimits), readMinMaxValues, FALSE, FALSE, 0);

  label = gtk_label_new(MIN_MAX_NO_DATA_FILE);
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_misc_set_alignment(GTK_MISC(label), 0.5, 0.5);
  gtk_container_add(GTK_CONTAINER(readMinMaxValues), label);


  /* Bar */
  alignment2 = gtk_alignment_new(0.5, 0.5, 0.3, 0);
  gtk_box_pack_start(GTK_BOX(vbox), alignment2, FALSE, FALSE, 8);
  hrule = gtk_hseparator_new();
  gtk_container_add(GTK_CONTAINER(alignment2), hrule);

  /***********************/
  /* Transformation part */
  /***********************/
  label = gtk_label_new(_("Define the color scheme:"));
  gtk_widget_set_name(label, "label_head");
  gtk_misc_set_alignment (GTK_MISC (label), 0., 0.5);
  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

  hboxPreSetColorRange = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hboxPreSetColorRange, FALSE, FALSE, 0);

  label = gtk_label_new(_("Use preset:"));
  gtk_misc_set_alignment(GTK_MISC(label), 0., 0.5);
  gtk_box_pack_start(GTK_BOX(hboxPreSetColorRange), label, TRUE, TRUE, 0);
  
  comboPreSetColorRange = shadeComboBox_new(FALSE);
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboPreSetColorRange), -1);
  gtk_box_pack_start(GTK_BOX (hboxPreSetColorRange), comboPreSetColorRange, FALSE, FALSE, 0);

  expanderTransformation = gtk_expander_new(_("More options"));
  gtk_expander_set_expanded(GTK_EXPANDER(expanderTransformation), FALSE);
  gtk_box_pack_start(GTK_BOX (vbox), expanderTransformation, FALSE, FALSE, 0);

  alignment3 = gtk_alignment_new(0.5, 0.5, 1, 1);
  gtk_alignment_set_padding(GTK_ALIGNMENT(alignment3), 0, 0, 15, 0);
  gtk_container_add(GTK_CONTAINER(expanderTransformation), alignment3);

  vboxTransformation = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(alignment3), vboxTransformation);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vboxTransformation), hbox6, FALSE, FALSE, 0);

  label = gtk_label_new(_("<b>Colour space: </b>"));
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label), 0., 0.5);
  gtk_box_pack_start (GTK_BOX (hbox6), label, TRUE, TRUE, 0);

  radiobuttonDataRGB = gtk_radio_button_new_with_mnemonic (NULL, _("RGB"));
  gtk_box_pack_start (GTK_BOX (hbox6), radiobuttonDataRGB, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobuttonDataRGB), radiobuttonDataRGB_group);
  radiobuttonDataRGB_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobuttonDataRGB));

  radiobuttonDataHSV = gtk_radio_button_new_with_mnemonic (NULL, _("HSV"));
  gtk_box_pack_start (GTK_BOX (hbox6), radiobuttonDataHSV, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobuttonDataHSV), radiobuttonDataRGB_group);
  radiobuttonDataRGB_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobuttonDataHSV));

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobuttonDataHSV), TRUE);

  tableLinearShade = gtk_table_new (3, 7, FALSE);
  gtk_box_pack_start (GTK_BOX (vboxTransformation), tableLinearShade, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (tableLinearShade), 3);
  gtk_table_set_row_spacings (GTK_TABLE (tableLinearShade), 3);

  labelChannel[0] = gtk_label_new (_("R"));
  gtk_table_attach (GTK_TABLE (tableLinearShade), labelChannel[0], 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (labelChannel[0]), 0, 0.5);

  labelChannel[1] = gtk_label_new (_("G"));
  gtk_table_attach (GTK_TABLE (tableLinearShade), labelChannel[1], 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (labelChannel[1]), 0, 0.5);

  labelChannel[2] = gtk_label_new (_("B"));
  gtk_table_attach (GTK_TABLE (tableLinearShade), labelChannel[2], 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (labelChannel[2]), 0, 0.5);

  label14 = gtk_label_new ("=");
  gtk_table_attach (GTK_TABLE (tableLinearShade), label14, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  label14 = gtk_label_new ("=");
  gtk_table_attach (GTK_TABLE (tableLinearShade), label14, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  label14 = gtk_label_new ("=");
  gtk_table_attach (GTK_TABLE (tableLinearShade), label14, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label15 = gtk_label_new ("+");
  gtk_table_attach (GTK_TABLE (tableLinearShade), label15, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  label15 = gtk_label_new ("+");
  gtk_table_attach (GTK_TABLE (tableLinearShade), label15, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  label15 = gtk_label_new ("+");
  gtk_table_attach (GTK_TABLE (tableLinearShade), label15, 3, 4, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label16 = gtk_label_new ("\303\227");
  gtk_table_attach (GTK_TABLE (tableLinearShade), label16, 5, 6, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label20 = gtk_label_new ("\303\227");
  gtk_table_attach (GTK_TABLE (tableLinearShade), label20, 5, 6, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label21 = gtk_label_new ("\303\227");
  gtk_table_attach (GTK_TABLE (tableLinearShade), label21, 5, 6, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  spinbuttonDataChA1_adj = gtk_adjustment_new (1, -99, 99, 0.01, 0.1, 0.);
  spinbuttonDataChA[0] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChA1_adj), 0.001, 2);
  gtk_table_attach (GTK_TABLE (tableLinearShade), spinbuttonDataChA[0], 4, 5, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChA[0]), TRUE);

  spinbuttonDataChA2_adj = gtk_adjustment_new (1, -99, 99, 0.01, 0.1, 0.);
  spinbuttonDataChA[1] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChA2_adj), 0.001, 2);
  gtk_table_attach (GTK_TABLE (tableLinearShade), spinbuttonDataChA[1], 4, 5, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChA[1]), TRUE);

  spinbuttonDataChA3_adj = gtk_adjustment_new (1, -99, 99, 0.01, 0.1, 0.);
  spinbuttonDataChA[2] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChA3_adj), 0.001, 2);
  gtk_table_attach (GTK_TABLE (tableLinearShade), spinbuttonDataChA[2], 4, 5, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChA[2]), TRUE);

  spinbuttonDataChB1_adj = gtk_adjustment_new (0, -99, 99, 0.01, 0.1, 0.);
  spinbuttonDataChB[0] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChB1_adj), 0.001, 2);
  gtk_table_attach (GTK_TABLE (tableLinearShade), spinbuttonDataChB[0], 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChB[0]), TRUE);

  spinbuttonDataChB2_adj = gtk_adjustment_new (0, -99, 99, 0.01, 0.1, 0.);
  spinbuttonDataChB[1] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChB2_adj), 0.001, 2);
  gtk_table_attach (GTK_TABLE (tableLinearShade), spinbuttonDataChB[1], 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChB[1]), TRUE);

  spinbuttonDataChB3_adj = gtk_adjustment_new (0, -99, 99, 0.01, 0.1, 0.);
  spinbuttonDataChB[2] = gtk_spin_button_new (GTK_ADJUSTMENT (spinbuttonDataChB3_adj), 0.001, 2);
  gtk_table_attach (GTK_TABLE (tableLinearShade), spinbuttonDataChB[2], 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spinbuttonDataChB[2]), TRUE);

  for (i = 0; i < 3; i++)
    {
      comboboxDataCh[i] = gtk_combo_box_new_text ();
      gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxDataCh[i]), COL_ONE);
      gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxDataCh[i]), COL_COORD_X);
      gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxDataCh[i]), COL_COORD_Y);
      gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxDataCh[i]), COL_COORD_Z);
      gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxDataCh[i]), 0);
      gtk_table_attach (GTK_TABLE (tableLinearShade), comboboxDataCh[i], 6, 7, i, i + 1,
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			(GtkAttachOptions) (GTK_FILL), 0, 0);
    }

  hbox8 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox8, FALSE, FALSE, 0);

  label = gtk_label_new(_("Color range preview: "));
  gtk_box_pack_start (GTK_BOX (hbox8), label, FALSE, FALSE, 0);

  pixbufColorPreview = gdk_pixbuf_new(GDK_COLORSPACE_RGB, FALSE,
				      COLOR_PREVIEW_BITS,
				      COLOR_PREVIEW_WIDTH,
				      COLOR_PREVIEW_HEIGHT);
  colorPreview = create_pixmap ((GtkWidget*)0, NULL);
  gtk_widget_set_size_request (colorPreview, COLOR_PREVIEW_WIDTH,
			       COLOR_PREVIEW_HEIGHT);
  gtk_box_pack_start (GTK_BOX (hbox8), colorPreview, TRUE, TRUE, 0);

  labelPreview = gtk_label_new(_("<span style=\"italic\">No preview available</span>"));
  gtk_label_set_use_markup(GTK_LABEL(labelPreview), TRUE);
  gtk_box_pack_start (GTK_BOX (hbox8), labelPreview, TRUE, TRUE, 0);

  /* Bar */
  alignment2 = gtk_alignment_new(0.5, 0.5, 0.3, 0);
  gtk_box_pack_start(GTK_BOX(vbox), alignment2, FALSE, FALSE, 8);
  hrule = gtk_hseparator_new();
  gtk_container_add(GTK_CONTAINER(alignment2), hrule);

  /***********************/
  /* Post treatment part */
  /***********************/
  expanderPostProcessing = gtk_expander_new(_("Post processing:"));
  gtk_widget_set_sensitive(expanderPostProcessing, FALSE);
  gtk_widget_set_name(gtk_expander_get_label_widget(GTK_EXPANDER(expanderPostProcessing)),
		      "label_head");
  gtk_expander_set_expanded(GTK_EXPANDER(expanderPostProcessing), TRUE);
  gtk_box_pack_start(GTK_BOX(vbox), expanderPostProcessing, FALSE, FALSE, 0);

  vboxPostProcessing = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(expanderPostProcessing), vboxPostProcessing);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vboxPostProcessing), hbox3, FALSE, FALSE, 0);

  checkHideMinValues = gtk_check_button_new_with_mnemonic(_("_Hide elements"));
  gtk_box_pack_start(GTK_BOX(hbox3), checkHideMinValues, FALSE, FALSE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkHideMinValues), FALSE);
  
  label = gtk_label_new(_(" whose value from"));
  gtk_box_pack_start(GTK_BOX(hbox3), label, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vboxPostProcessing), hbox3, FALSE, FALSE, 0);

  label = gtk_label_new(_("col. "));
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_box_pack_start(GTK_BOX(hbox3), label, TRUE, TRUE, 0);

  /* The 2 here is to avoid a GTK bug in 2.4. */
  spinHideMinValues = gtk_spin_button_new_with_range(1, 2, 1);
  gtk_box_pack_start(GTK_BOX(hbox3), spinHideMinValues, FALSE, FALSE, 0);

  label = gtk_label_new(_(" is lower than "));
  gtk_box_pack_start(GTK_BOX(hbox3), label, FALSE, FALSE, 0);

  entryHideMinValues = numericalEntry_new(1.);
  gtk_entry_set_width_chars(GTK_ENTRY(entryHideMinValues), 10);
  gtk_box_pack_start(GTK_BOX(hbox3), entryHideMinValues, FALSE, FALSE, 0);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vboxPostProcessing), hbox3, FALSE, FALSE, 0);

  checkScaleRadius = gtk_check_button_new_with_mnemonic(_("_Scale shape according to "));
  gtk_box_pack_start(GTK_BOX(hbox3), checkScaleRadius, FALSE, FALSE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkScaleRadius), FALSE);
  
  comboboxDataCh[i] = gtk_combo_box_new_text ();
/*   gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxDataCh[i]), COL_ONE); */
/*   gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxDataCh[i]), COL_COORD_X); */
/*   gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxDataCh[i]), COL_COORD_Y); */
/*   gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxDataCh[i]), COL_COORD_Z); */
/*   gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxDataCh[i]), 0); */
  gtk_box_pack_start(GTK_BOX(hbox3), comboboxDataCh[i], TRUE, TRUE, 0);

  /**************/
  /* Status bar */
  /**************/

  statusbarDataFile = gtk_statusbar_new();
  gtk_box_pack_end(GTK_BOX(containerDataFilePanel),
		   statusbarDataFile, FALSE, FALSE, 0);
  gtk_statusbar_set_has_resize_grip (GTK_STATUSBAR (statusbarDataFile), FALSE);
  statusDataFileContextId =
    gtk_statusbar_get_context_id(GTK_STATUSBAR(statusbarDataFile),
				 _("Description of loaded data file."));
  gtk_statusbar_push(GTK_STATUSBAR(statusbarDataFile), statusDataFileContextId,
		     DATA_FILE_NO_FILE_MESSAGE);

  gtk_widget_show_all(containerDataFilePanel);
  gtk_widget_hide(colorPreview);

  /********************/
  /* Create callbacks */
  /********************/
  g_signal_connect(G_OBJECT(openDataFileButton), "clicked",
		   G_CALLBACK(loadDataFile), (gpointer)0);
  signalCheckDataFile =
    g_signal_connect(G_OBJECT(checkbuttonData), "toggled",
		     G_CALLBACK(useDataFileColor), (gpointer)0);

  g_signal_connect(VISU_INSTANCE, "dataLoaded",
		   G_CALLBACK(visuFileReset), (gpointer)0);
  g_signal_connect(VISU_INSTANCE, "dataNew",
		   G_CALLBACK(onDataNew), (gpointer)0);
  g_signal_connect(G_OBJECT(radioNormalized), "toggled",
		   G_CALLBACK(onScaleTypeChange), (gpointer)dataFile_normalize);
  g_signal_connect(G_OBJECT(radioMinMax), "toggled",
		   G_CALLBACK(onScaleTypeChange), (gpointer)dataFile_minMax);
  g_signal_connect(G_OBJECT(entryDataMin), "value-changed",
		   G_CALLBACK(onEntryMinMaxChangeValue), (gpointer)0);
  g_signal_connect(G_OBJECT(entryDataMax), "value-changed",
		   G_CALLBACK(onEntryMinMaxChangeValue), (gpointer)1);
  for (i = 0; i < 3; i++)
    {
      signalSpinDataChA[i] =
	g_signal_connect(G_OBJECT(spinbuttonDataChA[i]), "value-changed",
			 G_CALLBACK(onSpinChChangeValue), GINT_TO_POINTER(i + 3));
      signalSpinDataChB[i] =
	g_signal_connect(G_OBJECT(spinbuttonDataChB[i]), "value-changed",
			 G_CALLBACK(onSpinChChangeValue), GINT_TO_POINTER(i));
      signalComboColumnId[i] =
	g_signal_connect(G_OBJECT(comboboxDataCh[i]), "changed",
			 G_CALLBACK(onComboColChange), GINT_TO_POINTER(i));
    }
  signalRadioRGB = g_signal_connect(G_OBJECT(radiobuttonDataRGB), "toggled",
				    G_CALLBACK(onColorTypeChange),
				    GINT_TO_POINTER(shade_colorModeRGB));
  signalRadioHSV = g_signal_connect(G_OBJECT(radiobuttonDataHSV), "toggled",
				    G_CALLBACK(onColorTypeChange),
				    GINT_TO_POINTER(shade_colorModeHSV));

  signalComboShade = g_signal_connect(G_OBJECT(comboPreSetColorRange),
				      "shade-selected",
				      G_CALLBACK(onColorPreSetChange), (gpointer)0);

  g_signal_connect(G_OBJECT(checkHideMinValues), "toggled",
		   G_CALLBACK(onCheckHideMinValuesChange), (gpointer)0);
  g_signal_connect(G_OBJECT(entryHideMinValues), "value-changed",
		   G_CALLBACK(onEntryHideMinValuesChange), (gpointer)0);
  g_signal_connect(G_OBJECT(spinHideMinValues), "value-changed",
		   G_CALLBACK(onSpinHideMinValuesChange), (gpointer)0);
  g_signal_connect(G_OBJECT(checkScaleRadius), "toggled",
		   G_CALLBACK(onCheckScaleRadiusChange), comboboxDataCh[3]);
  signalComboColumnId[3] =
    g_signal_connect(G_OBJECT(comboboxDataCh[3]), "changed",
		     G_CALLBACK(onComboScaleChange), checkScaleRadius);

  /* If there's a dataObj loaded, we missed the dataReadyForRendering signal,
     then we add the callback for NodeAskForShowHide manually. */
  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (dataObj)
    signalAskForHide = g_signal_connect(G_OBJECT(dataObj), "NodeAskForShowHide",
					G_CALLBACK(onAskForHideNodes), (gpointer)0);

  DBG_fprintf(stderr, " | Creation OK.\n");

  gtk_container_add(GTK_CONTAINER(panelDataFile), containerDataFilePanel);
}

static void updateNormalisationWidgets(VisuData *data)
{
  GtkWidget *childMinMax;
  int nbColumns;
  int i;
  GtkWidget *table, *label;
  GString *labelStr;
  float minMax[2];

  DBG_fprintf(stderr, "Panel DataFile: update widgets for normalisation.\n");

  /* empty the child of the alignment */
  childMinMax = gtk_bin_get_child(GTK_BIN(readMinMaxValues));
  if (childMinMax)
    gtk_widget_destroy(childMinMax);

  /* Special case without VisuData or without stored data. */
  if (!data || !dataFileGet_file(data))
    {
      label = gtk_label_new(MIN_MAX_NO_DATA_FILE);
      gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
      gtk_widget_show(label);
      gtk_misc_set_alignment(GTK_MISC(label), 0.5, 0.5);
      gtk_container_add(GTK_CONTAINER(readMinMaxValues), label);

      return;
    }

  /* Update the radio buttons. */
  switch (dataFileGet_scaleType(data))
    {
    case dataFile_normalize:
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radioNormalized), TRUE);
      break;
    case dataFile_minMax:
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radioMinMax), TRUE);
      break;
    default:
      break;
    }

  /* Update the min max entries. */
  numericalEntrySet_value(NUMERICAL_ENTRY(entryDataMin),
			  dataFileGet_min(data));
  numericalEntrySet_value(NUMERICAL_ENTRY(entryDataMax),
			  dataFileGet_max(data));

  /* Update the table of min/max values. */
  nbColumns = dataFileGet_nbColumns(data);
  g_return_if_fail(nbColumns > 0);

  table = gtk_table_new(nbColumns + 1, 3, FALSE);
  label = gtk_label_new(_("Column number"));
  gtk_widget_set_name(label, "label_head");
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1, GTK_SHRINK, GTK_SHRINK, 2, 0);
  label = gtk_label_new(_("Min value"));
  gtk_widget_set_name(label, "label_head");
  gtk_table_attach(GTK_TABLE(table), label, 1, 2, 0, 1, GTK_EXPAND, GTK_SHRINK, 2, 0);
  label = gtk_label_new(_("Max value"));
  gtk_widget_set_name(label, "label_head");
  gtk_table_attach(GTK_TABLE(table), label, 2, 3, 0, 1, GTK_EXPAND, GTK_SHRINK, 2, 0);

  labelStr = g_string_new("");
  for (i = 0; i < nbColumns; i++)
    {
      g_string_printf(labelStr, _("Column %d"), i + 1);
      label = gtk_label_new(labelStr->str);
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, i + 1, i + 2,
		       GTK_SHRINK, GTK_SHRINK, 2, 0);

      if (dataFileGet_fileMinMaxFromColumn(data, minMax, i))
	{
	  g_string_printf(labelStr, "%g", minMax[0]);
	  label = gtk_label_new(labelStr->str);
	  gtk_label_set_selectable(GTK_LABEL(label), TRUE);
	  gtk_table_attach(GTK_TABLE(table), label, 1, 2, i + 1, i + 2,
			   GTK_EXPAND, GTK_SHRINK, 2, 0);

	  g_string_printf(labelStr, "%g", minMax[1]);
	  label = gtk_label_new(labelStr->str);
	  gtk_label_set_selectable(GTK_LABEL(label), TRUE);
	  gtk_table_attach(GTK_TABLE(table), label, 2, 3, i + 1, i + 2,
			   GTK_EXPAND, GTK_SHRINK, 2, 0);
	}
      else
	g_warning("Can't retrieve min/max values for column %d.\n", i);
    }
  gtk_widget_show_all(table);
  g_string_free(labelStr, TRUE);

  gtk_container_add(GTK_CONTAINER(readMinMaxValues), table);
}
static void updateColourWidgets(VisuData *data)
{
  int i, j;
  GString *label;
  int *selected, scale;
  float *vectA, *vectB;
  Shade *shade;

  DBG_fprintf(stderr, "Panel dataFile: rebuilding colour widgets.\n");
  /* empty combobox */
  g_signal_handler_block(G_OBJECT(comboboxDataCh[0]), signalComboColumnId[0]);
  g_signal_handler_block(G_OBJECT(comboboxDataCh[1]), signalComboColumnId[1]);
  g_signal_handler_block(G_OBJECT(comboboxDataCh[2]), signalComboColumnId[2]);
  g_signal_handler_block(G_OBJECT(comboboxDataCh[3]), signalComboColumnId[3]);
  for (i = 0; i < 3; i++)
    {
      for (j = nbColumns + N_STATIC_COLS - 1; j > N_STATIC_COLS - 1; j--)
	gtk_combo_box_remove_text(GTK_COMBO_BOX(comboboxDataCh[i]), j);
      gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxDataCh[i]), 0);
      DBG_fprintf(stderr, "Panel dataFile: reset channel %d.\n", i);
    }
  for (j = nbColumns - 1; j > - 1; j--)
    gtk_combo_box_remove_text(GTK_COMBO_BOX(comboboxDataCh[3]), j);
  if (data)
    {
      shade = dataFileGet_shade(data);
      if (shade)
	{
	  if (shadeGet_mode(shade) == shade_modeLinear)
	    {
	      shadeGet_linearCoeff(shade, &vectA, &vectB);
	      /* Update the vectors. */
	      gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChA[0]),
					vectA[0]);
	      gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChA[1]),
					vectA[1]);
	      gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChA[2]),
					vectA[2]);
	      gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChB[0]),
					vectB[0]);
	      gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChB[1]),
					vectB[1]);
	      gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChB[2]),
					vectB[2]);
	    }
	  gtk_widget_set_sensitive(tableLinearShade,
				   (shadeGet_mode(shade) == shade_modeLinear));
	}
      /* Rebuild the column comboboxes. */
      nbColumns = dataFileGet_nbColumns(data);
      if (nbColumns > 0)
	{
	  label = g_string_new("");
	  for (j = 0; j < nbColumns; j++)
	    {
	      g_string_printf(label, _("Col. %d"), j + 1);
	      for (i = 0; i < 4; i++)
		gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxDataCh[i]), label->str);
	    }
	  g_string_free(label, TRUE);
	}
      selected = dataFileGet_colUsed(data);
      if (selected)
	{
	  for (i = 0; i < 3; i++)
	    {
	      DBG_fprintf(stderr, "Panel dataFile: Channel %d has selection %d.\n",
			  i, selected[i]);
	      gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxDataCh[i]),
				       selected[i] + N_STATIC_COLS);
	    }
	}
      scale = dataFileGet_scalingUsed(data);
      if (scale != -N_STATIC_COLS)
	gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxDataCh[3]),
				 scale + N_STATIC_COLS);
      if (shade)
	{
	  /* Change the colour scheme. */
	  switch (shadeGet_colorMode(shade))
	    {
	    case shade_colorModeRGB:
	      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobuttonDataRGB),
					   TRUE);
	      for (i = 0; i < 3; i++)
		gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelRGB[i]);
	      break;
	    case shade_colorModeHSV:
	      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobuttonDataHSV),
					   TRUE);
	      for (i = 0; i < 3; i++)
		gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelHSV[i]);
	      break;
	    default:
	      break;
	    }
	  /* Update the preset combo. */
	  g_signal_handler_block(G_OBJECT(comboPreSetColorRange), signalComboShade);
	  shadeComboBoxSet_selectionByShade(SHADE_COMBOX(comboPreSetColorRange),
					    shade);
	  g_signal_handler_unblock(G_OBJECT(comboPreSetColorRange), signalComboShade);
	}
    }
  g_signal_handler_unblock(G_OBJECT(comboboxDataCh[0]), signalComboColumnId[0]);
  g_signal_handler_unblock(G_OBJECT(comboboxDataCh[1]), signalComboColumnId[1]);
  g_signal_handler_unblock(G_OBJECT(comboboxDataCh[2]), signalComboColumnId[2]);
  g_signal_handler_unblock(G_OBJECT(comboboxDataCh[3]), signalComboColumnId[3]);
  /* Update the color preview. */
  makeColorPreview(data);
}
static void updatePostWidgets(VisuData *data)
{
  int nb;
  GtkAdjustment *adj;

  DBG_fprintf(stderr, "Panel dataFile: update post-processing widgets.\n");

  nb = (data)?MAX(dataFileGet_nbColumns(data), 1):1;

  adj = gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spinHideMinValues));
  gtk_adjustment_clamp_page(adj, 1, nb);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinHideMinValues), 1);
}
static void makeColorPreview(VisuData *data)
{
  int *valCols;
  int i, j;
  gboolean different;
  int rowstride, x, y;
  guchar *pixels, *p;
  float rgbValues[COLOR_PREVIEW_WIDTH][4];
  float fromVal[3];
  Shade *shade;

  if (!data)
    {
      gtk_image_set_from_pixbuf(GTK_IMAGE(colorPreview), NULL);
      gtk_widget_hide(colorPreview);
      gtk_widget_show(labelPreview);
      return;
    }

  valCols = dataFileGet_colUsed(data);
  if (!valCols)
    return;

  different =
    (valCols[0] != - N_STATIC_COLS && valCols[1] != - N_STATIC_COLS && valCols[0] != valCols[1]) ||
    (valCols[1] != - N_STATIC_COLS && valCols[2] != - N_STATIC_COLS && valCols[1] != valCols[2]) ||
    (valCols[0] != - N_STATIC_COLS && valCols[2] != - N_STATIC_COLS && valCols[0] != valCols[2]);
  if (different)
    {
      gtk_image_set_from_pixbuf(GTK_IMAGE(colorPreview), NULL);
      gtk_widget_hide(colorPreview);
      gtk_widget_show(labelPreview);
    }
  else
    {
      DBG_fprintf(stderr, "Panel dataFile: making color preview bitmap.\n");
      rowstride = gdk_pixbuf_get_rowstride(pixbufColorPreview);
      pixels = gdk_pixbuf_get_pixels(pixbufColorPreview);
      shade = dataFileGet_shade(data);

      for (i = 0; i < COLOR_PREVIEW_WIDTH; i++)
	{
	  for (j = 0; j < 3; j++)
	    fromVal[j] = (valCols[j] != -N_STATIC_COLS)?(float)i / (float)(COLOR_PREVIEW_WIDTH - 1):1.;
	  shadeGet_RGBFromValues(shade, rgbValues[i], fromVal);
/* 	  fprintf(stderr, "% d ----> %f %f %f -> %f %f %f\n",i, fromVal[0], fromVal[1], fromVal [2], rgbValues[i][0], rgbValues[i][1], rgbValues[i][2]); */
	}

      for (y = 0; y < COLOR_PREVIEW_HEIGHT; y++)
	for (x = 0; x < COLOR_PREVIEW_WIDTH; x++)
	  {
	    p = pixels + y * rowstride + x * 3;
	    p[0] = (guchar)(rgbValues[x][0] * 255);
	    p[1] = (guchar)(rgbValues[x][1] * 255);
	    p[2] = (guchar)(rgbValues[x][2] * 255);
	  }
      gtk_image_set_from_pixbuf(GTK_IMAGE(colorPreview), pixbufColorPreview);

      gtk_widget_hide(labelPreview);
      gtk_widget_show(colorPreview);
    }
}

static void updateStatusBar(gchar* file, int nbColumns)
{
  gchar *fileUTF8, *basename;
  GString *message;

  /* Create the text of the status bar or empty it. */

  gtk_statusbar_pop(GTK_STATUSBAR(statusbarDataFile),
		    statusDataFileContextId);
  /* Create the text of the status bar or empty it. */
  if (file)
    {
      basename = g_path_get_basename(file);
      fileUTF8 = g_filename_to_utf8(basename, -1, NULL, NULL, NULL);
      g_free(basename);
      g_return_if_fail(fileUTF8);

      message = g_string_new("");
      if (nbColumns > 0)
	g_string_append_printf(message, _("%s: %d column(s)"),
			       fileUTF8, nbColumns);
      else
	g_string_append_printf(message, _("%s: file error"),
				   fileUTF8);
      gtk_statusbar_push(GTK_STATUSBAR(statusbarDataFile),
			 statusDataFileContextId,
			 message->str);
      g_string_free(message, TRUE);
      g_free(fileUTF8);
    }
  else
      gtk_statusbar_push(GTK_STATUSBAR(statusbarDataFile),
			 statusDataFileContextId,
			 DATA_FILE_NO_FILE_MESSAGE);
}
gboolean panelDataFileLoad_file(VisuData *visuData, gchar *file, gboolean *new)
{
  GString *message;
  int errors;

  DBG_fprintf(stderr, "Panel dataFile : loading a new file '%s'.\n", file);
  g_return_val_if_fail(visuData && file && new, 0);

  /* If panel has still not been loaded, we do it now. */
  if (!panelDataFileIsInitiated)
    {
      panelDataFileIsInitiated = TRUE;
      createInteriorDataFile();
    }
  
  message = g_string_new("");
  flagDataFileIsLoaded = dataFileSet_file(visuData, file, new, message, &errors);

  /* Raise the error dialog if necessary. */
  if (errors)
    visuGtkRaise_warningLong(_("Loading a data file"), message->str, (GtkWindow*)0);
  g_string_free(message, TRUE);

  if (flagDataFileIsLoaded)
    {
      /* Set if the colours are used. */
      dataFileSet_used
	(visuData, gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)));
      /* Force applying hidding status if needed. */
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)))
	applyHideMinValues(visuData, FALSE);
    }
  gtk_widget_set_sensitive(expanderPostProcessing, flagDataFileIsLoaded);

  DBG_fprintf(stderr, "Panel dataFile: load OK.\n");
  return flagDataFileIsLoaded;
}
void panelDataFileUpdate(VisuData *dataObj)
{
  gchar *file;

  DBG_fprintf(stderr, "Panel dataFile: update the widgets"
	      " depending on the data %p.\n", (gpointer)dataObj);

  if (!dataObj)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbuttonData), FALSE);

  file = (dataObj)?dataFileGet_file(dataObj):(gchar*)0;

  gtk_widget_set_sensitive(vBoxDataFileOption, (dataObj != (VisuData*)0));
  gtk_widget_set_sensitive(expanderPostProcessing, (file != (gchar*)0));

  /* Update flags. */
  if (currentDataFile)
    g_free(currentDataFile);
  currentDataFile = (dataObj)?g_strdup(file):(gchar*)0;

  /* Update the widgets of this panel if necessary. */
  if (dataObj)
    updateStatusBar(file, dataFileGet_nbColumns(dataObj));
  else
    updateStatusBar(file, 0);
  updateNormalisationWidgets(dataObj);
  updateColourWidgets(dataObj);
  updatePostWidgets(dataObj);
}

/*************/
/* Callbacks */
/*************/
static void visuFileReset(GObject *obj _U_, VisuData *dataObj, gpointer data _U_)
{
  char* file;
  gchar* fileCpy, *fileExtPosition;
  GString *dataFile;
  int res, nbColumns;
  float minVal, maxVal;
  int dataNormalize;
  int colUsed[3];
  gboolean new;
  Shade *shade, *tmpSh;
  VisuData *dataOld;

  DBG_fprintf(stderr, "Panel dataFile: caught 'dataLoaded' signal.\n");
  if (dataObj)
    {
      /* Store old values, may be useful if data file is autoloaded. */
      DBG_fprintf(stderr, "Panel dataFile: Saving current colour values.\n");
      dataOld = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
      tmpSh = (dataOld)?dataFileGet_shade(dataOld):(Shade*)0;
      shade = (tmpSh)?shadeCopy(tmpSh):(Shade*)0;

      colUsed[0] = gtk_combo_box_get_active(GTK_COMBO_BOX(comboboxDataCh[0])) -
	N_STATIC_COLS;
      colUsed[1] = gtk_combo_box_get_active(GTK_COMBO_BOX(comboboxDataCh[1])) -
	N_STATIC_COLS;
      colUsed[2] = gtk_combo_box_get_active(GTK_COMBO_BOX(comboboxDataCh[2])) -
	N_STATIC_COLS;
      minVal = numericalEntryGet_value(NUMERICAL_ENTRY(entryDataMin));
      maxVal = numericalEntryGet_value(NUMERICAL_ENTRY(entryDataMax));
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radioNormalized)))
	dataNormalize = dataFile_normalize;
      else
	dataNormalize = dataFile_minMax;
	  
      /* Check the autoload flag. */
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonAutoLoad)))
	{
	  /* Compute the name of the data
	     file from the rendered filename. */
	  file = visuDataGet_file(dataObj, 0, (FileFormat**)0);
	  fileCpy = g_strdup(file);
	  fileExtPosition = g_strrstr(fileCpy, ".");
	  if (fileExtPosition)
	    *fileExtPosition = '\0';
	  dataFile = g_string_new("");
	  g_string_printf(dataFile, "%s%s", fileCpy,
			  gtk_entry_get_text(GTK_ENTRY(entryFileExtension)));
	  DBG_fprintf(stderr, "Panel DataFile : try to load a new data file"
		      " ('%s') from the name of the rendered file.\n", dataFile->str);
	  res = panelDataFileLoad_file(dataObj, dataFile->str, &new);
	  g_string_free(dataFile, TRUE);
	  g_free(fileCpy);
	}
      else
	res = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData));

      if (res)
	{
	  DBG_fprintf(stderr, "Panel dataFile: restore colour"
		      " values from previous.\n");
	  /* Reuse previous colUsed values. */
	  if (shade)
	    dataFileSet_shade(dataObj, shade);
	  nbColumns = dataFileGet_nbColumns(dataObj);
	  if (colUsed[0] < nbColumns)
	    dataFileSet_colUsed(dataObj, colUsed[0], 0);
	  if (colUsed[1] < nbColumns)
	    dataFileSet_colUsed(dataObj, colUsed[1], 1);
	  if (colUsed[2] < nbColumns)
	    dataFileSet_colUsed(dataObj, colUsed[2], 2);
	  dataFileSet_min(dataObj, minVal);
	  dataFileSet_max(dataObj, maxVal);
	  dataFileSet_scaleType(dataObj, dataNormalize);
	}

      dataFileSet_used
	(dataObj, 
	 gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)));
    }
  if (toolPanelGet_visible(TOOL_PANEL(panelDataFile)))
    {
      flagDisableCallbacks = TRUE;
      panelDataFileUpdate(dataObj);
      flagDisableCallbacks = FALSE;
    }
}
static void onDataNew(GObject *obj _U_, VisuData *dataObj, gpointer data _U_)
{
  /* Add the listener to the 'NodeAskForShowHide' signal. */
  signalAskForHide = g_signal_connect(G_OBJECT(dataObj), "NodeAskForShowHide",
				      G_CALLBACK(onAskForHideNodes), (gpointer)0);
}
static void loadDataFile(GtkButton *button _U_, gpointer data _U_)
{
  GtkWidget *file_selector;
  char *filename;
  char *directory;
  int res;
  VisuData *dataObj;
  gboolean new;
  GtkFileFilter *filter;
  GString *label;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (!dataObj)
    {
      g_warning("Can't click here since no visuData is available.\n");
      return;
    }

  file_selector = gtk_file_chooser_dialog_new(_("Load data file"),
					      toolPanelGet_containerWindow(TOOL_PANEL(panelDataFile)),
					      GTK_FILE_CHOOSER_ACTION_OPEN,
					      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					      GTK_STOCK_OPEN, GTK_RESPONSE_OK,
					      NULL);
  directory = visuGtkGet_lastOpenDirectory();
  if (directory)
    gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(file_selector), directory);
  gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(file_selector),
				       FALSE);
  filter = gtk_file_filter_new();
  label = g_string_new(_("Data files"));
  g_string_append_printf(label, " (*%s)",
			 gtk_entry_get_text(GTK_ENTRY(entryFileExtension)));
  gtk_file_filter_set_name(filter, label->str);
  g_string_printf(label, "*%s", gtk_entry_get_text(GTK_ENTRY(entryFileExtension)));
  gtk_file_filter_add_pattern(filter, label->str);
  g_string_free(label, TRUE);
  gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(file_selector), filter);
  filter = gtk_file_filter_new();
  gtk_file_filter_set_name(filter, _("All files"));
  gtk_file_filter_add_pattern(filter, "*");
  gtk_file_chooser_add_filter(GTK_FILE_CHOOSER(file_selector), filter);

  gtk_widget_set_name(file_selector, "filesel");
  gtk_window_set_position(GTK_WINDOW(file_selector), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_modal (GTK_WINDOW (file_selector), TRUE);

  if (gtk_dialog_run (GTK_DIALOG (file_selector)) == GTK_RESPONSE_OK)
    {
      filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER (file_selector));
      directory = (char*)gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER (file_selector));
      visuGtkSet_lastOpenDirectory(directory, VISU_DIR_DATAFILE);
      g_free(directory);
      gtk_widget_destroy (file_selector);
      DBG_fprintf(stderr, "Panel DataFile: load file '%s'.\n", filename);
      res = panelDataFileLoad_file(dataObj, filename, &new);
      g_free(filename);
      DBG_fprintf(stderr, "Panel DataFile: load OK, new %d.\n", new);
      DBG_fprintf(stderr, "Panel DataFile: update the panel.\n");
      panelDataFileUpdate(dataObj);
      DBG_fprintf(stderr, "Panel DataFile: update OK.\n");
      /* Ask for a redraw */
      if (res)
	{
	  DBG_fprintf(stderr, "Panel DataFile: may ask for redraw.\n");
	  /* Update rendering. */
	  if (new)
	    gtk_combo_box_set_active(GTK_COMBO_BOX(comboPreSetColorRange), 0);
	  else
	    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)))
	      dataFileReDraw(dataObj);
	}
      else
	{
	  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)))
	    applyHideMinValues(dataObj, FALSE);
	  dataFileReDraw(dataObj);
	}
    }
  else
    {
      directory = (char*)gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER (file_selector));
      visuGtkSet_lastOpenDirectory(directory, VISU_DIR_DATAFILE);
      g_free(directory);
      gtk_widget_destroy (file_selector);
    }
}
void panelDataFileSet_use(gboolean used)
{
  VisuData *dataObj;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (!dataObj)
    return;

  dataFileSet_used(dataObj, used);
  g_signal_handler_block(G_OBJECT(checkbuttonData), signalCheckDataFile);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbuttonData), used);
  g_signal_handler_unblock(G_OBJECT(checkbuttonData), signalCheckDataFile);
}
static void useDataFileColor(GtkToggleButton *toggle, gpointer data _U_)
{
  gboolean isOn;
  int res;
  VisuData *dataObj;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  if (!dataObj)
    return;

  isOn = gtk_toggle_button_get_active(toggle);
  res = dataFileSet_used(dataObj, (gboolean)isOn);
  /* Force applying hidding status if needed. */
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)))
    applyHideMinValues(dataObj, FALSE);
  if (res)
    dataFileReDraw(dataObj);
}
static void onDataFileEnter(ToolPanel *toolPanel _U_, gpointer data _U_)
{
  DBG_fprintf(stderr, "Panel dataFile: check values on enter.\n");

  if (!panelDataFileIsInitiated)
    {
      DBG_fprintf(stderr, "Panel dataFile: initialize interior.\n");
  
      panelDataFileIsInitiated = TRUE;
      createInteriorDataFile();
    }

  flagDisableCallbacks = TRUE;
  DBG_fprintf(stderr, "Panel dataFile: set values on enter.\n");
  panelDataFileUpdate(toolPanelGet_visuData(TOOL_PANEL(panelDataFile)));
  flagDisableCallbacks = FALSE;
}
static void onScaleTypeChange(GtkToggleButton *toggle, gpointer data)
{
  int scale, res;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile: change on scale radio buttons.\n");

  if (!gtk_toggle_button_get_active(toggle))
    return;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  g_return_if_fail(dataObj);

  scale = GPOINTER_TO_INT(data);
  g_return_if_fail(scale >= dataFile_normalize && scale <= dataFile_minMax);

  res = dataFileSet_scaleType(dataObj, scale);
  if (scale != dataFile_minMax)
    {
      gtk_widget_set_sensitive(entryDataMax, FALSE);
      gtk_widget_set_sensitive(entryDataMin, FALSE);
    }
  else
    {
      gtk_widget_set_sensitive(entryDataMax, TRUE);
      gtk_widget_set_sensitive(entryDataMin, TRUE);
      gtk_expander_set_expanded(GTK_EXPANDER(expanderNormalize), TRUE);
    }
  if (res)
    dataFileReDraw(dataObj);
}
static void onEntryMinMaxChangeValue(NumericalEntry *entry,
				     double oldValue _U_, gpointer data)
{
  int minMax, res;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile: change on min/max entries.\n");

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  g_return_if_fail(dataObj);

  minMax = GPOINTER_TO_INT(data);
  g_return_if_fail(minMax == 0 || minMax == 1);
  DBG_fprintf(stderr, "Panel Data File: grep value from GtkEntry for"
	      " the minMax value (%d).\n", minMax);

  switch (minMax)
    {
    case 0:
      res = dataFileSet_min(dataObj, numericalEntryGet_value(entry));
      break;
    case 1:
      res = dataFileSet_max(dataObj, numericalEntryGet_value(entry));
      break;
    default:
      res = 0;
      break;
    }
  if (res)
    dataFileReDraw(dataObj);
}
static void onSpinChChangeValue(GtkSpinButton *spinbutton, gpointer user_data)
{
  int pos;
  int res;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile: change on spin vect[%d].\n",
	      GPOINTER_TO_INT(user_data));
  /* Desable preset range since manual chance. */
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboPreSetColorRange), -1);

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  g_return_if_fail(dataObj);

  pos = GPOINTER_TO_INT(user_data);
  g_return_if_fail(pos >= 0 && pos < 6);

  res = shadeSet_linearCoeff(dataFileGet_shade(dataObj),
			     gtk_spin_button_get_value(spinbutton), pos % 3, pos / 3);
  makeColorPreview(dataObj);
  if (res)
    dataFileReDraw(dataObj);
}

static void onComboColChange(GtkComboBox *combo, gpointer data)
{
  int pos;
  int res;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile: change on combo column.\n");
  /* Disable preset range since manual chance. */
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboPreSetColorRange), -1);

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  g_return_if_fail(dataObj);

  pos = GPOINTER_TO_INT(data);
  g_return_if_fail(pos >= 0 && pos < 3);

  res = dataFileSet_colUsed(dataObj, gtk_combo_box_get_active(combo) -
			    N_STATIC_COLS, pos);
  makeColorPreview(dataObj);
  if (res)
    dataFileReDraw(dataObj);
}
static void onColorTypeChange(GtkToggleButton *toggle, gpointer data)
{
  int color, res, i;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile: change on colour type radio buttons.\n");
  /* Desable preset range since manual chance. */
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboPreSetColorRange), -1);

  if (!gtk_toggle_button_get_active(toggle))
    return;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  g_return_if_fail(dataObj);

  color = GPOINTER_TO_INT(data);
  g_return_if_fail(color == shade_colorModeRGB || color == shade_colorModeHSV);

  res = shadeSet_colorMode(dataFileGet_shade(dataObj), color);
  if (color == shade_colorModeRGB)
    for (i = 0; i < 3; i++)
      gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelRGB[i]);
  else
    for (i = 0; i < 3; i++)
      gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelHSV[i]);
  makeColorPreview(dataObj);
  if (res)
    dataFileReDraw(dataObj);
}
gboolean panelDataFileSet_presetShade(Shade *shade)
{
  float *vectA, *vectB;
  int i, j;
  VisuData *dataObj;

  DBG_fprintf(stderr, "Panel dataFile: change the colour transformation"
	      " according to shade %p.\n", (gpointer)shade);
  
  if (!shade)
    return FALSE;

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));

  /* Suspend all combo signals during changes */
  g_signal_handler_block(G_OBJECT(radiobuttonDataRGB), signalRadioRGB);
  g_signal_handler_block(G_OBJECT(radiobuttonDataHSV), signalRadioHSV);
  for (i = 0; i < 3; i++)
    {
      g_signal_handler_block(G_OBJECT(comboboxDataCh[i]), signalComboColumnId[i]);
      g_signal_handler_block(G_OBJECT(spinbuttonDataChA[i]), signalSpinDataChA[i]);
      g_signal_handler_block(G_OBJECT(spinbuttonDataChB[i]), signalSpinDataChB[i]);
    }
  dataFileSet_shade(dataObj, shade);
  switch (shadeGet_colorMode(shade))
    {
    case shade_colorModeRGB:
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobuttonDataRGB), TRUE);
      for (i = 0; i < 3; i++)
	gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelRGB[i]);
      break;
    case shade_colorModeHSV:
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobuttonDataHSV), TRUE);
      for (i = 0; i < 3; i++)
	gtk_label_set_text(GTK_LABEL(labelChannel[i]), labelHSV[i]);
      break;
    default:
      g_warning("Incorrect ShadeColorMode in call of 'onColorPreSetChange'.");
    }
  if (shadeGet_mode(shade) == shade_modeLinear)
    {
      j = (dataFileGet_file(dataObj))?N_STATIC_COLS:3;
      shadeGet_linearCoeff(shade, &vectA, &vectB);
      for (i = 0; i < 3; i++)
	{
	  if (vectA[i] != 0.f &&
	      gtk_combo_box_get_active(GTK_COMBO_BOX(comboboxDataCh[i])) < 1)
	    {
	      dataFileSet_colUsed(dataObj, j - N_STATIC_COLS, i);
	      gtk_combo_box_set_active(GTK_COMBO_BOX(comboboxDataCh[i]), j);
	    }
	  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChA[i]), vectA[i]);
	  gtk_spin_button_set_value(GTK_SPIN_BUTTON(spinbuttonDataChB[i]), vectB[i]);
	}
    }
  gtk_widget_set_sensitive(tableLinearShade,
			   (shadeGet_mode(shade) == shade_modeLinear));

  /* ReActivate all combo signals after changes */
  g_signal_handler_unblock(G_OBJECT(radiobuttonDataRGB), signalRadioRGB);
  g_signal_handler_unblock(G_OBJECT(radiobuttonDataHSV), signalRadioHSV);
  for (i = 0; i < 3; i++)
    {
      g_signal_handler_unblock(G_OBJECT(comboboxDataCh[i]), signalComboColumnId[i]);
      g_signal_handler_unblock(G_OBJECT(spinbuttonDataChA[i]), signalSpinDataChA[i]);
      g_signal_handler_unblock(G_OBJECT(spinbuttonDataChB[i]), signalSpinDataChB[i]);
    }

  makeColorPreview(dataObj);

  return TRUE;
}
static void onColorPreSetChange(ShadeComboBox *combo _U_, Shade *values,
				gpointer data _U_)
{
  if (panelDataFileSet_presetShade(values) &&
      gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)))
    {
      visuData_createAllNodes(toolPanelGet_visuData(TOOL_PANEL(panelDataFile)));
      g_idle_add(visuObjectRedraw, (gpointer)0);
    }
}
static void applyHideMinValues(VisuData *visuData, gboolean askRedraw)
{
  gboolean redraw;
  int col;
  double value;

  g_return_if_fail(visuData);

  /* Wants to change the rendered attributes of Nodes, must
     emit the NodeAskForShowHide signal. */
  DBG_fprintf(stderr, "Panel DataFile : emitting 'NodeAskForShowHide' signal.\n");
  g_signal_handler_block(G_OBJECT(visuData), signalAskForHide);
  visuDataEmit_askForShowHideNodes(visuData, &redraw);
  g_signal_handler_unblock(G_OBJECT(visuData), signalAskForHide);
  DBG_fprintf(stderr, " | returned redraw value %d.\n", redraw);

  /* Get the parameters for hiding mode. */
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)) && 
      dataFileGet_used(visuData))
    col = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinHideMinValues)) - 1;
  else
    col = -1;
  value = numericalEntryGet_value(NUMERICAL_ENTRY(entryHideMinValues));

  redraw = dataFileApply_hideOnMinValue(visuData, col, value) || redraw;

  if (redraw)
    {
      visuDataEmit_nodeRenderedChange(visuData);
      if (askRedraw)
	{
	  visuData_createAllNodes(visuData);
	  g_idle_add(visuObjectRedraw, (gpointer)0);
	}
    }
}
static void onCheckHideMinValuesChange(GtkToggleButton *toggle _U_,
				       gpointer data _U_)
{
  if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)) ||
      flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel DataFile : toggle check"
	      " button to hide elements.\n");
  applyHideMinValues(toolPanelGet_visuData(TOOL_PANEL(panelDataFile)), TRUE);
}
static void onEntryHideMinValuesChange(NumericalEntry *entry,
				       double oldValue _U_, gpointer data _U_)
{
  if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)) ||
      !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)) ||
      flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel DataFile : change value on hide"
	      " min values entry : %f\n", numericalEntryGet_value(entry));
  applyHideMinValues(toolPanelGet_visuData(TOOL_PANEL(panelDataFile)), TRUE);
}
static void onSpinHideMinValuesChange(GtkSpinButton *spinbutton,
				      gpointer user_data _U_)
{
  if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbuttonData)) ||
      !gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)) ||
      flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel DataFile : change value of spin column"
	      " for hide function : %f\n", gtk_spin_button_get_value(spinbutton));
  applyHideMinValues(toolPanelGet_visuData(TOOL_PANEL(panelDataFile)), TRUE);
}
static void onAskForHideNodes(VisuData *visuData, gboolean *redraw,
			      gpointer data _U_)
{
  int col;
  double val;

  /* No data, useless to stay here. */
  if (!flagDataFileIsLoaded)
    return;

  /* Not in used, can safely go out. */
  if (!dataFileGet_used(visuData))
    return;

  DBG_fprintf(stderr, "Panel DataFile: caught the 'NodeAskForShowHide' signal for"
	      " VisuData %p.\n", (gpointer)visuData);

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkHideMinValues)))
    {
      col = (int)gtk_spin_button_get_value(GTK_SPIN_BUTTON(spinHideMinValues)) - 1;
      val = numericalEntryGet_value(NUMERICAL_ENTRY(entryHideMinValues));
      *redraw = dataFileApply_hideOnMinValue(visuData, col, val) || *redraw;
    }
}
static void onCheckScaleRadiusChange(GtkToggleButton *toggle, gpointer data)
{
  int i;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile: change scaling radius appliance.\n");

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  g_return_if_fail(dataObj);

  if (gtk_toggle_button_get_active(toggle))
    {
      i = gtk_combo_box_get_active(GTK_COMBO_BOX(data));
      dataFileSet_scalingUsed(dataObj, (i < 0)?-N_STATIC_COLS:i);
    }
  else
    dataFileSet_scalingUsed(dataObj, -N_STATIC_COLS);

  dataFileReDraw(dataObj);
}
static void onComboScaleChange(GtkComboBox *combo, gpointer data)
{
  int i;
  gboolean val;
  VisuData *dataObj;

  if (flagDisableCallbacks)
    return;

  DBG_fprintf(stderr, "Panel dataFile: change on scaling radius combo.\n");

  dataObj = toolPanelGet_visuData(TOOL_PANEL(panelDataFile));
  g_return_if_fail(dataObj);

  i = gtk_combo_box_get_active(combo);
  val = dataFileSet_scalingUsed(dataObj, (i < 0)?-N_STATIC_COLS:i);
  
  if (val && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(data)))
    dataFileReDraw(dataObj);
}
static gboolean readFileExt(gchar **lines, int nbLines, int position,
			    VisuData *dataObj _U_, GError **error)
{
  g_return_val_if_fail(nbLines == 1, FALSE);

  lines[0] = g_strstrip(lines[0]);

  if (!lines[0][0])
    {
      *error = g_error_new(CONFIG_FILE_ERROR, CONFIG_FILE_ERROR_VALUE,
			   _("Parse error at line %d: 1 string value must appear"
			     " after the %s markup.\n"), position,
			   FLAG_PARAMETER_FILEEXT);
      return FALSE;
    }
  if (fileExt)
    g_free(fileExt);
  fileExt = g_strdup(lines[0]);

  if (entryFileExtension)
    gtk_entry_set_text(GTK_ENTRY(entryFileExtension), fileExt);

  return TRUE;
}
static void exportParameters(GString *data, VisuData* dataObj _U_)
{
  g_string_append_printf(data, "# %s\n", DESC_PARAMETER_FILEEXT);
  g_string_append_printf(data, "%s[gtk]: %s\n\n", FLAG_PARAMETER_FILEEXT,
			 fileExt);
}
