/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD, Damien
	CALISTE, Olivier D'Astier, laboratoire L_Sim, (2001-2005)

	Adresses m�l :
	BILLARD, non joignable par m�l ;
	CALISTE, damien P caliste AT cea P fr.
	D'ASTIER, dastier AT iie P cnam P fr.

	Ce logiciel est un programme informatique servant � visualiser des
	structures atomiques dans un rendu pseudo-3D.

	Ce logiciel est r�gi par la licence CeCILL soumise au droit fran�ais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffus�e par le CEA, le CNRS et l'INRIA
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez acc�der � cet en-t�te signifie que vous avez
	pris connaissance de la licence CeCILL, et que vous en avez accept� les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD and Damien
	CALISTE and Olivier D'Astier, laboratoire L_Sim, (2001-2005)

	E-mail addresses :
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.
	D'ASTIER, dastier AT iie P cnam P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use,
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info".

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef ISOLINE_H
#define ISOLINE_H

#include "surfaces_points.h"

#include <glib.h>

/**
 * Line:
 * @num_sublines: Number of sub_lines composing the Line.
 * @num_vertices: Total number of vertices.
 * @vertex_3dpos: 3D coordinates of each vertex.
 *
 * Structure representing a curved line in 3D.
 */
typedef struct _Line Line;

/**
 * isolineDraw:
 * @line: a set of points forming a line.
 * @rgb: a colour.
 *
 * Call the OpenGL routine that will draw this line.
 */
void isolineDraw(Line *line, float rgb[3]);
float* isolineProject(Line *line, Plane *plane, gint *nSeg);
/**
 * isolineBuild:
 * @isoline: the lines to be computed ;
 * @points: the surface to compute isoline from ;
 * @valOffset: the offset to apply to the data of @points to read the
 * scalarfield values ;
 * @visibilityOffset: the offset to apply to the data of @points to
 * read if the vertex is hidden or not ;
 * @isoValue: the value of the computed isoline.
 *
 * Create on the fly an isoline from the structure points. If the
 * lines are created, @isoline will be allocated and should be freed
 * with isolineFree() after use.
 *
 * Returns: TRUE if the isoline is created.
 */
gboolean isolineBuild(Line **isoline, SurfacesPoints *points,
		      guint valOffset, gint visibilityOffset, double isoValue);

/**
 * isolineFree:
 * @line: a set of lines.
 *
 * Free the line object.
 */
void isolineFree(Line *line);
#endif
