/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_COMMANDLINE_H
#define VISU_COMMANDLINE_H

/* This .h and .c are here to read parameters from the
   command line. */
#include <glib.h>

#include <coreTools/toolOptions.h>

/**
 * parseCommandLine:
 * @argc: the number of arguments.
 * @argv: the values of all arguments.
 *
 * This method is called at startup to parse the command line
 * and store all important information. If --help is given, or an unknown
 * option, a little help is printed on the standard output.
 *
 * Returns: 0 if everything goes well.
 */
int parseCommandLine(int argc, char **argv);

/**
 * commandLineGet_ArgFilename:
 *
 * This method retrieves the first argument. All other arguments are ignored.
 *
 * Returns: the value of the first argument.
 */
char* commandLineGet_ArgFilename();
/**
 * commandLineGet_ArgSpinFileName:
 *
 * This method retrieves the second argument. All other arguments are ignored.
 *
 * Returns: the value of the second argument.
 */
char* commandLineGet_ArgSpinFileName();
/**
 * commandLineGet_ExportFileName:
 *
 * This method retrieves the value of the option --export or -e. This value must
 * be a valid filename, with an extension known by V_Sim to do the export.
 *
 * Returns: the value of the option --export.
 */
char* commandLineGet_ExportFileName();
/**
 * commandLineGet_WithGtk:
 *
 * This method tells V_Sim is the GTK interface is needed or not.
 *
 * Returns: 1 if the interface is needed.
 */
int   commandLineGet_WithGtk();
/**
 * commandLineGet_XWindowGeometry:
 * @width: an integer to stores the desired width.
 * @height: an integer to stores the desired height.
 *
 * This method retrieves the values of the option --geometry or -g.
 * These values must be formatted with the following format : %dx%d and they give
 * the size of the rendering window.
 *
 */
void  commandLineGet_XWindowGeometry(int *width, int *height);
/**
 * commandLineGet_colorizeFileName:
 *
 * This method retrieves the value of the option --colorize or -c. This value must
 * be a valid filename. If this option is called, V_Sim actually enable
 * the colorization, even if parameter file doesn't.
 *
 * Returns: the value of the option --colorize.
 */
gchar* commandLineGet_colorizeFileName();
/**
 * commandLineGet_colorizeColUsed:
 *
 * This method retrieves the value of the option --use-column or -u. This value consists
 * of three integer values.
 *
 * Returns: the three values of the option --use-column, or NULL if this option
 *          is not present.
 */
int* commandLineGet_colorizeColUsed();
/**
 * commandLineGet_colorizePresetColor:
 *
 * DEPRECATED, use commandLineGet_presetColor() instead.
 *
 * Returns: the value of option --color-preset if set, -1 if not.
 */
#define commandLineGet_colorizePresetColor() commandLineGet_presetColor();
/**
 * commandLineGet_presetColor:
 *
 * This method returns the value of option --color-preset.
 *
 * Returns: the value of option --color-preset if set, -1 if not.
 */
int commandLineGet_presetColor();
/**
 * commandLineGet_translation:
 *
 * This method retrieves the value of the option --translate or -t. This value consists
 * of three floating values.
 *
 * Returns: the three values of the option --translate.
 */
float* commandLineGet_translation();
/**
 * commandLineGet_extension:
 *
 * This method retrieves the value of the option --expand or -x. This value consists
 * of three floating values.
 *
 * Returns: the three values of the option --expand.
 */
float* commandLineGet_extension();
/**
 * commandLineGet_planesFileName:
 *
 * This method retrieves the value of the option --planes or -p. This value must
 * be a valid filename.
 *
 * Returns: the value of the option --planes.
 */
gchar* commandLineGet_planesFileName();
/**
 * commandLineGet_spinHidingMode:
 *
 * This method retrieves if the option --hiding-mode or -m has been set.
 *
 * Returns: the value of the option.
 */
int commandLineGet_spinHidingMode();
/**
 * commandLineGet_spinAndAtomic:
 *
 * This method retrieves if the option --spin-and-atomic or -a has been set.
 *
 * Returns: the TRUE if the option exists.
 */
gboolean commandLineGet_spinAndAtomic();
/**
 * commandLineGet_isoValues:
 * @nb: a location to store an integer.
 *
 * This method retrieves the values of the option --ios-values or -v.
 *
 * Returns: an array with the values of a size stored in @nb.
 */
float* commandLineGet_isoValues(int *nb);
/**
 * commandLineGet_isoNames:
 * @nb: a location to store an integer.
 *
 * This method retrieves the names associated to the values of the option --ios-values or -v.
 * It returns an array of size @nb, but not all element are set since names are not
 * mandatory. The @nb value is guarantied to by equal to the one returned by
 * commandLineGet_isoValues();
 *
 * Returns: an array with the values of a size stored in @nb.
 */
gchar** commandLineGet_isoNames(int *nb);
/**
 * commandLineGet_scalarFieldFileName:
 *
 * This method retrieves the filename given by the option --scalar-field or -f.
 *
 * Returns: a filename, the string is owned by V_Sim.
 */
gchar* commandLineGet_scalarFieldFileName();
/**
 * commandLineGet_isoSurfacesFileName:
 *
 * This method retrieves the filename given by the option --iso-surfaces or -i.
 *
 * Returns: a filename, the string is owned by V_Sim.
 */
gchar* commandLineGet_isoSurfacesFileName();
/**
 * commandLineGet_fitToBox:
 *
 * This method gets if the surface should be adapted to the bounding box of the structure.
 *
 * Returns: TRUE if the surface should be fitted.
 */
gboolean commandLineGet_fitToBox();
/**
 * commandLineGet_resourcesFile:
 *
 * This method gets if a resources file has been given.
 *
 * Returns: the name (owned by V_Sim) of the given resources file or NULL if none
 *          was present.
 */
gchar* commandLineGet_resourcesFile();
/**
 * commandLineGet_options:
 *
 * This method gets the contents of all -o options. The value is first parsed as
 * letters to check for a boolean value (F/T), then, a float is used and finally
 * an integer. If nothing parsed, the option is dismissed.
 *
 * Returns: a #OptionTable pointer owned by V_Sim.
 */
OptionTable* commandLineGet_options();
/**
 * commandLineGet_coloredMap:
 * @planeId: a location to store the plane to be used.
 *
 * If the return value is TRUE, then the user requests a coloured map
 * using the given plane. The scalar field is given by
 * '--scalar-filed' option (see commandLineGet_scalarFieldFileName())
 * and the shade by '--color-preset' (see
 * commandLineGet_presetColor()).
 *
 * Returns: TRUE if a coloured map is requested.
 */
gboolean commandLineGet_coloredMap(int *planeId);
/**
 * commandLineGet_logScale:
 *
 * Retrieve if a log scale is required for various plots.
 *
 * Returns: TRUE if '--log-scale' has been given, default is FALSE.
 */
gboolean commandLineGet_logScale();
/**
 * commandLineGet_nIsoLines:
 *
 * Retrieve if the user asked for isolines on the coloured map (see
 * commandLineGet_coloredMap()).
 *
 * Returns: a positive number if some isolines are required, 0 if not.
 */
guint commandLineGet_nIsoLines();
/**
 * commandLineGet_bgImage:
 *
 * Retrieve if the filename to be loaded as a background image.
 *
 * Returns: a string or NULL if option is not used.
 */
gchar* commandLineGet_bgImage();

#endif
