/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef WIRE_H
#define WIRE_H

#include <visu_pairs.h>


/**
 * initPairsWire:
 *
 * This method is used by V_Sim on startup, don't use it on your own.
 *
 * Returns: the wire pair extension.
 */
PairsExtension* initPairsWire();

PairsExtension* pointerToPairExtension_wire;

/**
 * setWireGeneralWidth:
 * @val: a positive integer.
 *
 * The width of line between elements can be chosen by kinds of pairs,
 * but can use a default value for all kinds of pairs when no individual value
 * is available. Use this method to set the default width.
 *
 * Returns: 1 if the calling method should call the visuPairBuild() method, 0 if not.
 */
int setWireGeneralWidth(int val);
/**
 * getWireGeneralWidth:
 *
 * Get the default width for wire pairs (see setWireGeneralWidth() to set this value).
 *
 * Returns: the default width.
 */
int getWireGeneralWidth();
/**
 * setWireWidth:
 * @data: a #PairsData object ;
 * @val: a positive integer.
 *
 * This method allows to change the width of line for a specific pair.
 * When a pair is rendered via with a line, it first checks if that pairs has
 * a specific width value set by this method. If not, it uses the default value.
 * If the specific value is indeed changed, the pairs OpenGl list is not
 * recreated automatically and the calling method should call the visuPairBuild() method
 * according to the return value.
 *
 * Returns: 1 if the calling method should call the visuPairBuild() method, 0 if not.
 */
int setWireWidth(VisuPairData *data, int val);
/**
 * getWireWidth:
 * @data: a #PairsData object.
 *
 * Get the width of the given pair @data. If the given pair has no
 * specific width, the defaul value is returned.
 *
 * Returns: the width of the given pair.
 */
int getWireWidth(VisuPairData *data);
/**
 * setWireNonLinear:
 * @val: a boolean value.
 *
 * If the @val argument is true, the wire drawn as pairs do not
 * use their user-defined color but instead are colored using a
 * function depending on the length. See getLengthSampleForColor()
 * to know how to change this colorization function.
 *
 * Returns: 1 if the calling method should call the visuPairBuild() method, 0 if not.
 */
int setWireNonLinear(int val);
/**
 * getWireNonLinear:
 *
 * Get if color are user-defined or length dependent.
 *
 * Returns: 1 if color is length dependent.
 */
int getWireNonLinear();
/**
 * getLengthSampleForColor:
 * @color: an integer [0;2], coding for RGB channel ;
 * @size: a pointer to an integer.
 *
 * When pairs colors are length dependent, an array is used to store the colorization
 * function. This function is a two variables one, the first variable is the color channel
 * and the second gives the correspondance between [0;1] (length variabtion between
 * pair_min and pair_max) and [0;1] (color variation in the given channel). The color channels
 * must be RGB coded. This method is used to get one of the array for the given channel
 * (@color). The calling method should sample the transformation function and store it
 * in the returned array. Its size is stored in the @size argument.
 *
 * Returns: the star of the transformation array for the given color channel.
 */
float* getLengthSampleForColor(int color, int *size);

/**
 * wireSet_stipple:
 * @data: a #VisuPairData object ;
 * @stipple: a pattern.
 *
 * Change the line pattern of @data.
 *
 * Returns: TRUE if the value is different from previous, then call
 * the visuPairBuild() method.
 */
gboolean wireSet_stipple(VisuPairData *data, guint16 stipple);
/**
 * wireGet_stipple:
 * @data: a #VisuPairData object.
 *
 * Get the line pattern of @data.
 *
 * Returns: a line pattern (default is 65535).
 */
guint16 wireGet_stipple(VisuPairData *data);


#endif
