/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#include "renderingMode.h"

#include <visu_tools.h>
#include <visu_configFile.h>
#include <coreTools/toolConfigFile.h>

#include <GL/gl.h>
#include <GL/glu.h>

#include <string.h>


#define FLAG_PARAMETER_OPENGL_RENDERING "opengl_render"
#define DESC_PARAMETER_OPENGL_RENDERING "Rules the way OpenGl draws objects in general ; 4 possible strings : Wireframe, Flat, Smooth and SmoothAndEdge"
#define PARAMETER_OPENGL_RENDERING_DEFAULT Smooth

static RenderingModeId renderingOption;
static gboolean readOpenGLRendering(gchar **lines, int nbLines, int position,
				    VisuData *dataObj, GError **error);
static gboolean exportParametersRenderingMode(GString *data, int *nbLinesWritten,
					      VisuData *dataObj);

static const char *renderingStrings[nb_renderingModes + 1] =
  {"Wireframe", "Flat", "Smooth", "SmoothAndEdge", (const char*)0};
static const char *renderingStringsI18n[nb_renderingModes + 1];


void openGLInit_renderingMode()
{
  VisuConfigFileEntry *confEntry;

  DBG_fprintf(stderr, "OpenGl RenderingMode : initialization.\n");
  confEntry = visuConfigFileAdd_entry(VISU_CONFIGFILE_PARAMETER,
				      FLAG_PARAMETER_OPENGL_RENDERING,
				      DESC_PARAMETER_OPENGL_RENDERING,
				      1, readOpenGLRendering);
  visuConfigFileAdd_exportFunction(VISU_CONFIGFILE_PARAMETER,
				   exportParametersRenderingMode);

  renderingOption = PARAMETER_OPENGL_RENDERING_DEFAULT;
  renderingStringsI18n[Wireframe    ] = _("Wireframe");
  renderingStringsI18n[Flat         ] = _("Flat");
  renderingStringsI18n[Smooth       ] = _("Smooth");
  renderingStringsI18n[SmoothAndEdge] = _("Smooth & edge");
  renderingStringsI18n[nb_renderingModes] = (const char*)0;
}

/* This function change the value of the parameter renderingOption. */
void openGLApply_renderingMode(RenderingModeId mode)
{
  switch (mode)
    {
    case Wireframe:
      glShadeModel(GL_FLAT);
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
      glLineWidth(1);
      break;
    case Flat:
      glShadeModel(GL_FLAT);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
      break;
    case Smooth:
    case SmoothAndEdge:
      glShadeModel(GL_SMOOTH);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
      break;
    default:
      g_warning("Wrong value for parameter 'mode' in a call"
		" to 'openGLApply_renderingMode'.");
      return;
    }
  DBG_fprintf(stderr, "Rendering Mode : switch rendering mode to '%s'.\n",
	      renderingStrings[mode]);
}
gboolean openGLSet_globalRenderingMode(RenderingModeId value)
{
  g_return_val_if_fail(value < nb_renderingModes, FALSE);
  
  if (value == renderingOption)
    return FALSE;

  renderingOption = value;
  openGLApply_renderingMode(value);

  return 1;
}
/* This function retrieve the value of the parameter renderingOption. */
RenderingModeId openGLGet_globalRenderingOption()
{
  return renderingOption;
}
const char** openGLGet_allRenderingModesI18n()
{
  return renderingStringsI18n;
}
const char** openGLGet_allRenderingModes()
{
  return renderingStrings;
}
gboolean openGLGet_renderingFromName(const char* name, RenderingModeId *id)
{
  g_return_val_if_fail(name && id, FALSE);

  *id = 0;
  while (*id < nb_renderingModes && strcmp(name, renderingStrings[*id]))
    *id += 1;
  return (*id < nb_renderingModes);  
}

static gboolean readOpenGLRendering(gchar **lines, int nbLines, int position,
				    VisuData *dataObj _U_, GError **error)
{
  RenderingModeId id;
  gchar **val;

  g_return_val_if_fail(nbLines == 1, FALSE);

  if (!configFileRead_string(lines[0], position, &val, 1, FALSE, error))
    return FALSE;
  if (!openGLGet_renderingFromName(val[0], &id))
    {
      *error = g_error_new(CONFIG_FILE_ERROR, CONFIG_FILE_ERROR_VALUE,
			   _("Parse error at line %d: the shape '%s' is unknown.\n"),
			   position, val[0]);

      g_strfreev(val);
      return FALSE;
    }
  g_strfreev(val);
  openGLSet_globalRenderingMode(id);
  return TRUE;
}
static gboolean exportParametersRenderingMode(GString *data, int *nbLinesWritten,
					      VisuData *dataObj _U_)
{
  g_string_append_printf(data, "# %s\n", DESC_PARAMETER_OPENGL_RENDERING);
  g_string_append_printf(data, "%s: %s\n\n", FLAG_PARAMETER_OPENGL_RENDERING,
	  renderingStrings[renderingOption]);
  *nbLinesWritten = 3;
  return TRUE;
}
