/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2006)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2006)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef GTK_RENDERINGWINDOW_H
#define GTK_RENDERINGWINDOW_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "visu_data.h"
#include "visu_dump.h"
#include "openGLFunctions/interactive.h"

G_BEGIN_DECLS
/**
 * RENDERING_WINDOW_TYPE
 *
 * Return the associated #GType to the Renderingwindow objects.
 */
#define RENDERING_WINDOW_TYPE         (renderingWindow_get_type())
/**
 * RENDERING_WINDOW:
 *
 * Cast the given object to a #RenderingWindow object.
 */
#define RENDERING_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_CAST((obj), RENDERING_WINDOW_TYPE, RenderingWindow))
/**
 * RENDERING_WINDOW_CLASS
 *
 * Cast the given class to a #RenderingWindowClass object.
 */
#define RENDERING_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), RENDERING_WINDOW_TYPE, RenderingWindowClass))
/**
 * IS_RENDERING_WINDOW
 *
 * Return if the given object is a valid #RenderingWindow object.
 */
#define IS_RENDERING_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), RENDERING_WINDOW_TYPE))
/**
 * IS_RENDERING_WINDOW_CLASS
 *
 * Return if the given class is a valid #RenderingWindowClass class.
 */
#define IS_RENDERING_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), RENDERING_WINDOW_TYPE))

/**
 * RenderingWindow
 *
 * Short form for a #RenderingWindow_struct structure.
 */
typedef struct _RenderingWindow RenderingWindow;
/**
 * RenderingWindowClass
 *
 * Short form for a #RenderingWindowClass_struct structure.
 */
typedef struct _RenderingWindowClass RenderingWindowClass;

/**
 * renderingWindow_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #RenderingWindow objects.
 */
GType          renderingWindow_get_type        (void);
/**
 * renderingWindow_new:
 * @windowRef: the title of the window ;
 * @window_name: the name of the window ;
 * @class_name: the class of the window ;
 * @width: its desired width ;
 * @height: its desired height.
 *
 * A #RenderingWindow widget is a GtkWindow that have an area for
 * OpenGL drawing and a statusBar with many stuff like action buttons,
 * real status bar for notifications, ...
 *
 * Returns: a newly created #RenderingWindow widget.
 */
GtkWidget* renderingWindow_new(char* windowRef, char* window_name,
			       char* class_name, int width, int height);
/**
 * renderingWindowRemove_interactiveEventListener:
 * @window: a valid #RenderingWindow object.
 *
 * Remove all the store signals used for the interactive mode.
 */
void renderingWindowRemove_interactiveEventListener(RenderingWindow *window);
/**
 * renderingWindowSet_observeEventListener:
 * @window: a valid #RenderingWindow object.
 *
 * Bring up the interactive mode listeners (clic, drag...) for observe mode.
 */
void renderingWindowSet_observeEventListener(RenderingWindow *window);
/**
 * renderingWindowSet_pickEventListener:
 * @window: a valid #RenderingWindow object.
 *
 * Bring up the interactive mode listeners (clic, drag...) for pick mode.
 */
void renderingWindowSet_pickEventListener(RenderingWindow *window);
/**
 * renderingWindowSet_interactiveHandlers:
 * @window: a valid #RenderingWindow object ;
 * @inter: a valid #VisuInteractive object.
 *
 * Define the callback routines used when an action (clic, drag...) is
 * done.
 */
void renderingWindowSet_interactiveHandlers(RenderingWindow *window,
					    VisuInteractive *inter);
/**
 * renderingWindowStop_defaultIneractiveMode:
 * @window: a valid #RenderingWindow object.
 *
 * Stop all default interactive mode.
 */
void renderingWindowStop_defaultIneractiveMode(RenderingWindow *window);
/**
 * renderingWindowStart_defaultIneractiveMode:
 * @window: a valid #RenderingWindow object.
 *
 * Start all default interactive mode. It doesn't work if the default interactive
 * mode has been stopped by renderingWindowBlock_defaultIneractiveMode(). Use
 * renderingWindowUnblock_defaultIneractiveMode() instead to restart it.
 */
void renderingWindowStart_defaultIneractiveMode(RenderingWindow *window);
/**
 * renderingWindowBlock_defaultIneractiveMode:
 * @window: a valid #RenderingWindow object.
 *
 * Stop all default interactive mode and prevent tem to restart
 * until renderingWindowUnblock_defaultIneractiveMode() is called.
 */
void renderingWindowBlock_defaultIneractiveMode(RenderingWindow *window);
/**
 * renderingWindowUnblock_defaultIneractiveMode:
 * @window: a valid #RenderingWindow object.
 *
 * Unblock and start the default interactive mode.
 */
void renderingWindowUnblock_defaultIneractiveMode(RenderingWindow *window);
/**
 * renderingWindowPush_message:
 * @window: a valid #RenderingWindow object ;
 * @message: an UTF8 string to print on the status bar.
 *
 * Use this method to add some informations on the status bar.
 */
void renderingWindowPush_message(RenderingWindow *window, gchar *message);
/**
 * renderingWindowPop_message:
 * @window: a valid #RenderingWindow object.
 *
 * Remove the last message.
 */
void renderingWindowPop_message(RenderingWindow *window);
/**
 * renderingWindowGet_openGLAreaSize:
 * @window: a valid #RenderingWindow object ;
 * @width: a location to store the width ;
 * @height: a location to store the height.
 *
 * Retrieve the size of the OpenGL area (not the size of the rendering window).
 */
void renderingWindowGet_openGLAreaSize(RenderingWindow *window,
				       unsigned int *width, unsigned int *height);
/**
 * renderingWindowGet_backgroundImage:
 * @window: a valid #RenderingWindow object ;
 * @rowData: a pointer to be set on the data in memory ;
 * @hasAlphaChannel: a pointer to store if the loaded iage has an alpha channel ;
 * @width: store the width ;
 * @height: store the height.
 *
 * Use this method to load an image in memory (according to GdkPixbuf
 * specification) and retrieve the row data in memory. 
 *
 * Returns: a pointer to GdkPixbuf that is own by the @window object. his image
 *          stay in memory until a call to renderigWindowFree_backgroundImage()
 *          occurs.
 */
GdkPixbuf* renderingWindowGet_backgroundImage(RenderingWindow *window,
					     guchar **rowData, gboolean *hasAlphaChannel,
					     int *width, int *height);
/**
 * renderingWindowFree_backgroundImage:
 * @window: a valid #RenderingWindow object.
 *
 * Free loaded background image if exists.
 */
void renderingWindowFree_backgroundImage(RenderingWindow *window);

/**
 * renderingWindowSet_visuData:
 * @window: a valid #RenderingWindow object ;
 * @data: a #VisuData to render in the given @window (can be NULL).
 *
 * This method is used to attach a #VisuData object to a given window.
 * When, @data is not NULL, this method emit the dataReadyForRendering signal,
 * and all modules that needs to draw something should catch this signal and
 * draw in the rendering window. If @data is NULL, the dataNotReadyForRendering
 * is emitted instead.
 */
void renderingWindowSet_visuData(RenderingWindow *window, VisuData* data);
/**
 * renderingWindowGet_visuData:
 * @window: a valid #RenderingWindow object.
 *
 * This method is used to get the #VisuData attached to a window.
 *
 * Returns: the #VisuData attached to the @window or NULL if none.
 */
VisuData* renderingWindowGet_visuData(RenderingWindow *window);

/**
 * renderingWindowLoad_file:
 * @window: the window the file will by rendered on ;
 * @parent: the parent window for the filechooser dialog.
 *
 * Do as if the load button has been pushed, i.e. open a filechooser
 * dialog on the @parent window, and load the resulting file,
 * refreshing the view if necessary.
 */
void renderingWindowLoad_file(RenderingWindow *window, GtkWindow *parent);

/**
 * renderingWindowDump:
 * @window:a valid #RenderingWindow object ;
 * @format: a #DumpType object, corresponding to the write method ;
 * @fileName: a string that defined the file to write to ;
 * @width: an integer ;
 * @height: an integer ;
 * @error: a location to store some error (not NULL) ;
 * @functionWait: a method to call periodically during the dump ;
 * @data: some pointer on object to be passed to the wait function.
 *
 * Call this method to dump the given @window to a file.
 *
 * Returns: TRUE if everything went right.
 */
gboolean renderingWindowDump(RenderingWindow *window, DumpType *format,
			     const char* fileName, gint width, gint height,
			     GError **error,
			     voidDataFunc functionWait, gpointer data);

/**
 * renderingWindowRedraw:
 * @window: a valid #RenderingWindow object ;
 * @forceRedraw: a boolean.
 *
 * Update the OpenGL area of the rendering window if the opengl option
 * is set to immediate. If not, use @forceRedraw to redraw.
 */
void renderingWindowRedraw(RenderingWindow *window, gboolean forceRedraw);

/**
 * renderingWindowSet_current:
 * @window: a valid #RenderingWindow object ;
 * @force: a boolean.
 *
 * Set the OpenGL area as the current rendering area. If @force is TRUE
 * then the context is switched whatever buffered value.
 */
void renderingWindowSet_current(RenderingWindow *window, gboolean force);


G_END_DECLS

#endif
