/*
    Copyright (C) 2001-2006  Ben Kibbey <bjk@luxsci.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef PASSWD_H
#define PASSWD_H

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_GETSPNAM
#include <shadow.h>
#endif

#ifdef HAVE_ERR_H
#include <err.h>
#endif

#ifndef ALLPERMS
#define ALLPERMS (S_ISUID|S_ISGID|S_ISVTX|S_IRWXU|S_IRWXG|S_IRWXO)
#endif

/* This is the order of options when the 'P' option is specified. It selects
 * all available options. */
#define PASSWD_OPTION_ORDER	"lpugicedsm"
#define PASSWD_OPTION_STRING	"Plpugcedsmi:"

static int amroot;
static char **strings;
static char options[11];	/* NULL terminated. */
static char *gecos_options;

void add_string(char ***, const char *);
char *stamp(time_t, const char *);

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

#endif
