/* ========================================================================== */
/* === umfpack_qsymbolic ==================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_qsymbolic
(
    int n,
    const int Ap [ ],
    const int Ai [ ],
    const int Qinit [ ],
    void **Symbolic,
    const double Control [UMFPACK_CONTROL],
    double Info [UMFPACK_INFO]
) ;

long umfpack_l_qsymbolic
(
    long n,
    const long Ap [ ],
    const long Ai [ ],
    const long Qinit [ ],
    void **Symbolic,
    const double Control [UMFPACK_CONTROL],
    double Info [UMFPACK_INFO]
) ;

/*
int Syntax:

    #include "umfpack.h"
    void *Symbolic ;
    int n, *Ap, *Ai, *Qinit, status ;
    double Control [UMFPACK_CONTROL], Info [UMFPACK_INFO] ;
    status = umfpack_qsymbolic (n, Ap, Ai, Qinit, &Symbolic, Control, Info) ;

long Syntax:

    #include "umfpack.h"
    void *Symbolic ;
    long n, *Ap, *Ai, *Qinit, status ;
    double Control [UMFPACK_CONTROL], Info [UMFPACK_INFO] ;
    status = umfpack_l_qsymbolic (n, Ap, Ai, Qinit, &Symbolic, Control, Info) ;

Purpose:

    Given the nonzero pattern of a sparse matrix A in column-oriented form, and
    a sparsity preserving column preordering Qinit, umfpack_qsymbolic performs
    the symbolic factorization of A*Qinit (or A (:,Qinit) in Matlab notation).
    It also computes the column elimination tree post-ordering.  This is
    identical to umfpack_symbolic, except that colamd is not called and the
    user input column order Qinit is used instead.  Note that in general, the
    Qinit passed to umfpack_qsymbolic will differ from the final Q found in
    umfpack_numeric, because of the column etree postordering done in
    umfpack_qsymbolic and sparsity-preserving modifications made within each
    frontal matrix during umfpack_numeric.

    *** WARNING ***  A poor choice of Qinit can easily cause umfpack_numeric to
    use a huge amount of memory and do a lot of work.  The "default" symbolic
    analysis method is umfpack_symbolic, not this routine.  If you use this
    routine, the performance of UMFPACK is your responsibility;  UMFPACK will
    not try to second-guess a poor choice of Qinit.  If you are unsure about
    the quality of your Qinit, then call both umfpack_symbolic and
    umfpack_qsymbolic, and pick the one with lower estimates of work and
    memory usage (Info [UMFPACK_FLOPS_ESTIMATE] and
    Info [UMFPACK_PEAK_MEMORY_ESTIMATE]).  Don't forget to call
    umfpack_free_symbolic to free the Symbolic object that you don't need.

Returns:

    The value of Info [UMFPACK_STATUS]; see below.

Arguments:

    All arguments are the same as umfpack_symbolic, except for the following:

    Int Qinit [n] ;		Input argument, not modified.

	The user's fill-reducing initial column preordering.  This must be a
	permutation of 0..n-1.  If Qinit [k] = j, then column j is the kth
	column of the matrix A (:,Qinit) to be factorized.  If Qinit is an
	(Int *) NULL pointer, then colamd is called instead.  In fact,

	Symbolic = umfpack_symbolic (n, Ap, Ai, Control, Info) ;

	is identical to

	Symbolic = umfpack_qsymbolic (n, Ap, Ai, (Int *) NULL, Control, Info) ;

    double Control [UMFPACK_CONTROL] ;	Input argument, not modified.

	Identical to umfpack_symbolic if Qinit is (Int *) NULL.  Otherwise,
	if Qinit is present, it is identical to umfpack_symbolic except for the
	following:

	Control [UMFPACK_DENSE_ROW]:  ignored.

	Control [UMFPACK_DENSE_COL]:  Let j be the leftmost column in
	    A (:,Qinit) with more entries than the value determined by the
	    dense column control parameter (see umfpack_symbolic), or j=n if
	    there is no such column.  Columns j through n-1 are all treated as
	    "dense", and factorized in a (n-j)-by-n dense array.  When
	    determining Qinit, be sure the "dense" columns of A (:,Qinit) are
	    as far to the right as possible.

    double Info [UMFPACK_INFO] ;	Output argument, not defined on input.

	Identical to umfpack_symbolic if Qinit is (Int *) NULL.  Otherwise,
	if Qinit is present, it is identical to umfpack_symbolic except for the
	following:

	Info [UMFPACK_NDENSE_ROW]:  zero
	Info [UMFPACK_NEMPTY_ROW]:  zero
	Info [UMFPACK_NDENSE_COL]:  n-j, where j is defined above.
	Info [UMFPACK_NEMPTY_COL]:  zero

*/

