/*
** Copyright (C) 1995, 1996, 1997, 1998 Hewlett-Packard Company
** Originally by Kevin Hughes, kev@kevcom.com, 3/11/94
**
** This program and library is free software; you can redistribute it and/or
** modify it under the terms of the GNU (Library) General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU (Library) General Public License for more details.
**
** You should have received a copy of the GNU (Library) General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**--------------------------------------------------------------------------
** Config file edited by Roy Tennant 2/20/96
** Config file edited by Giulia Hill 2/27/97 to increase lenght of
**        words that are indexed
** Added IGNORELASTCHAR
**        G. Hill 3/12/97 ghill@library.berkeley.edu
**
** Added OKNOMETA to allow no failing in case the META name is
** not listed in the config.h
**        G. Hill 4/15/97 ghill@library.berkeley.edu
**
** Added IGNOREFIRSTCHAR
**        G.Hill 10/16/97 ghill@library.berkeley.edu
**-----------------------------------------------------------------------
** The following are user-definable options that you can change
** to fine-tune SWISH's default options.
*/

#define ALLOW_HTTP_INDEXING_DATA_SOURCE		1
#define ALLOW_FILESYSTEM_INDEXING_DATA_SOURCE	1

/* These symbols allow compile-time elimination of indexing
** data sources. Any Data Source that is allowed by these
** symbols can be selected for indexing from the command line.
** Comment out any options you do not want to support, but
** be sure to leave at least one option.
*/

#define INDEXPERMS 0644

/* After SWISH generates an index file, it changes the permissions
** of the file to this mode. Change to the mode you like
** (note that it must be an octal number). If you don't want
** permissions to be changed for you, comment out this line.
*/

#define PLIMIT 100
#define FLIMIT 10000

/* SWISH uses these parameters to automatically mark words as
** being too common while indexing. For instance, if I defined PLIMIT
** as 80 and FLIMIT as 256, SWISH would define a common word as
** a word that occurs in over 80% of all indexed files and over
** 256 files. Making these numbers lower will most likely make your
** index files smaller. Making PLIMIT and FLIMIT small will also
** ensure that searching consumes only so much CPU resources.
*/

#define VERBOSE 3

/* You can define VERBOSE to be a number from 0 to 4. 0 is totally
** silent operation; 4 is very verbose.
*/

#define MAXHITS 500

/* MAXHITS is the maximum number of results to return from a search.
*/

#define DEFAULT_RULE AND_RULE

/* If a list of search words is specified without booleans,
** SWISH will assume they are connected by a default rule.
** This can be AND_RULE or OR_RULE.
*/

#define TITLETOPLINES 12

/* This is how many lines deep SWISH will look into an HTML file to
** attempt to find a <TITLE> tag.
*/

#define EMPHASIZECOMMENTS 0

/* Normally, words within HTML comments are not assigned a higher
** relevance rank. If you're including keywords in comments
** define this as 1 so matching results will rise to the top
** of search results.
*/

#define MINWORDLIMIT 1

/* This is the minimum length of a word. Anything shorter will not
** be indexed.
*/

#define MAXWORDLIMIT 40

/* This is the maximum length of a word. Anything longer will not
** be indexed.
*/

#define ASCIIENTITIES 1

/* If defined as 1, all entities in search words and indexed
** words will be converted to an ASCII equivalent. For instance,
** with this feature you can index the word "resum&eacute;" or
** "resum&#233;" and it will be indexed as the word "resume".
** If defined as 0, only numerical entities will be converted
** to named entities, if they exist.
*/

#define IGNOREALLV 0
#define IGNOREALLC 0
#define IGNOREALLN 0

/* If IGNOREALLV is 1, words containing all vowels won't be indexed.
** If IGNOREALLC is 1, words containing all consonants won't be indexed.
** If IGNOREALLN is 1, words containing all digits won't be indexed.
** Define as 0 to allow words with consistent characters.
** Vowels are defined as "aeiou", digits are "0123456789".
*/

#define IGNOREROWV 60
#define IGNOREROWC 60
#define IGNOREROWN 60

/* IGNOREROWV is the maximum number of consecutive vowels a word can have.
** IGNOREROWC is the maximum number of consecutive consonants a word can have.
** IGNOREROWN is the maximum number of consecutive digits a word can have.
** Vowels are defined as "aeiou", digits are "0123456789".
*/

#define IGNORESAME 100

/* IGNORESAME is the maximum times a character can repeat in a word.
*/
#define WORDCHARS "abcdefghijklmnopqrstuvwxyz،ݟ;&0123456789#"

/* WORDCHARS is a string of characters which SWISH permits to
** be in words. Any strings which do not include these characters
** will not be indexed. You can choose from any character in
** the following string:
**
** abcdefghijklmnopqrstuvwxyz0123456789_\|/-+=?!@$%^'\"`~,.[]{}()
**
** Note that if you omit "0123456789&#;" you will not be able to
** index HTML entities. DO NOT use the asterisk (*), lesser than
** and greater than signs (<), (>), or colon (:).
**
** Including any of these four characters may cause funny things to happen.
** If you have a pressing need to index 8-bit characters, please contact
** me for possible user testing in the future.
**
** Also note that if you specify the backslash character (\) or
** double quote (") you need to type a backslash before them to
** make the compiler understand them.
*/

#define BEGINCHARS "abcdefghijklmnopqrstuvwxyz،ݟ&0123456789(\"'"

/* Of the characters that you decide can go into words, this is
** a list of characters that words can begin with. It should be
** a subset of (or equal to) WORDCHARS.
*/

#define ENDCHARS "abcdefghijklmnopqrstuvwxyz\\،ݟ.0123456789,'\")"

/* This is the same as BEGINCHARS, except you're testing for
** valid characters at the ends of words.
*/

/* Note that if you really want to edit the default stopwords, (words
** that are deemed too common to be indexed) then you can do so in the
** file "swish.h". They don't have to be in alphabetical order.
*/

#define IGNORELASTCHAR ";.,')\""

/* Array that contains the char that, if considered valid in the middle of 
** a word need to be disreguarded when at the end. It is important to also
** set the given char's in the ENDCHARS array, otherwise the word will not
** be indexed because considered invalid.
** If none just leave the empty list "". Do not erase the line
*/

#define IGNOREFIRSTCHAR "('\""
 
/* Array that contains the char that, if considered valid in the middle of
** a word need to be disreguarded when at the beginning. This was to solve
** the problem of parenthesis when there is no space between ( and the
** beginning of the word.
** Remember to add the char's to the BEGINCHARS list also.
** If none just leave the empty list "". Do not erase the line
*/

#define OKNOMETA 1
/* Switch that define if it is ok to fail in case the META name is not listed 
** in the METANAMES variable. Value of 1 will cause the word to be listed as a
** regular words with no metaName attached
*/

#define REQMETANAME 0
/* Set to 1 to not index any Meta tag contents unless the tag name is
** listed in the MetaNames parameter. Set to 0 and with OKNOMETA set 1
** Swish will place META contents in index with no metaName attached.
** 10/11/99 Bill Moseley
*/

#define IGNORE_STOPWORDS_IN_QUERY 1
 
/* Added JM 1/10/98.  Setting this to 0 (default) causes a stopword in
** an AND_RULE search to create an empty result.  Setting it to 1 simply
** ignores the stopwords and does a search on the remaining words.
*/

#define INDEXTAGS 0

/* Normally, all data in tags in HTML files (except for words in
** comments or meta tags) is ignored. If you want to index HTML files with the
** text within tags and all, define this to be 1 and not 0.
** NOTE: if you set it to 1 you will not be able to do context nor
** metaNames searches, as tags are just plain text with no specific
** meaning.
*/

#define SPIDERDIRECTORY "./"

/* Added Jose Ruiz. Temp directory */

/* Set this variable to 1 if you are compiling under Win32
   define _WIN32 1
 */

/* --- BEGIN PORTING-RELATED SYMBOLS --- */

#ifdef _WIN32
#define NO_SYMBOLIC_FILE_LINKS		/* Win32 has no symbolic links */
#endif

#ifdef _WIN32
#undef INDEXPERMS		/* Win32 version doesn't use chmod() */
#endif

#ifdef _WIN32
typedef int pid_t;		/* process ID */
#endif

#ifdef _WIN32
#define TMPDIR "c:\\windows\\temp"
#else
#define TMPDIR "/var/tmp"
#endif
			
	/* Directory delimiter */
#ifdef _WIN32
#define DIRDELIMITER '\\'
#else
#define DIRDELIMITER '/'
#endif

/* == compiler stuff == */
#define FUNCTION_PROTOTYPES_INCLUDE_ARGS	/* comment out for non-ANSI compilers */

/*
** Use the _AP() macro in all function definitions (in header files)
** to support both ANSI and non-ANSI compilers.
** Instead of:
**		 void somefunction();
** or:
**		 void somefunction(int, int, int);
** use:
**		 void somefunction _AP ((int, int, int));
*/
#ifdef FUNCTION_PROTOTYPES_INCLUDE_ARGS
#define _AP(args) args
#else
#define _AP(args) ()
#endif

/* #define NEXTSTEP */

/* You may need to define this if compiling on a NeXTstep machine.
*/

/* --- END PORTING-RELATED SYMBOLS --- */

