#ifndef WRAPPERS_H
#define WRAPPERS_H

#ifdef LINUX

#include <stdio.h> /* NULL, stderr */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <sys/poll.h>
#include <errno.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>

#else

#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <poll.h>

#endif


// pound defines (for stevens' sake)
#define SA struct sockaddr

// typedefs
typedef void Sigfunc (int);

// function prototypes
ssize_t  Read(int, void *, size_t);
void Write(int, void *, size_t);
void err_sys(const char *);
void err_quit(const char *);
Sigfunc *Signal(int, Sigfunc *);
void Sendmsg(int, const struct msghdr *, int);

// STEVENS INCLUDE HERE
/* prototypes for our socket wrapper functions: see {Sec errors} */
int	 Accept(int, SA *, socklen_t *);
void	 Bind(int, const SA *, socklen_t);
void	 Connect(int, const SA *, socklen_t);
void	 Getpeername(int, SA *, socklen_t *);
void	 Getsockname(int, SA *, socklen_t *);
void	 Getsockopt(int, int, int, void *, socklen_t *);
int		 Isfdtype(int, int);
void	 Listen(int, int);
int	 Poll(struct pollfd *, unsigned long, int);
ssize_t	 Readline(int, void *, size_t);
ssize_t	 Readn(int, void *, size_t);
ssize_t	 Recv(int, void *, size_t, int);
ssize_t	 Recvfrom(int, void *, size_t, int, SA *, socklen_t *);
ssize_t	 Recvmsg(int, struct msghdr *, int);
int		 Select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
void	 Send(int, const void *, size_t, int);
void	 Sendto(int, const void *, size_t, int, const SA *, socklen_t);
void	 Sendmsg(int, const struct msghdr *, int);
void	 Setsockopt(int, int, int, const void *, socklen_t);
void	 Shutdown(int, int);
int		 Sockatmark(int);
int		 Socket(int, int, int);
void	 Socketpair(int, int, int, int *);
void	 Writen(int, void *, size_t);



#endif
