#include "recvfd.h"

#ifdef LINUX

ssize_t
read_fd(int fd, void *ptr, size_t nbytes, int *recvfd)
{
	struct msghdr	msg;
	struct iovec	iov[1];
	ssize_t			n;

#ifdef	HAVE_MSGHDR_MSG_CONTROL
	union {
	  struct cmsghdr	cm;
	  char				control[CMSG_SPACE(sizeof(int))];
	} control_un;
	struct cmsghdr	*cmptr;

	msg.msg_control = control_un.control;
	msg.msg_controllen = sizeof(control_un.control);
#else
	msg.msg_accrights = (caddr_t) &newfd;
	msg.msg_accrightslen = sizeof(int);
#endif

	msg.msg_name = NULL;
	msg.msg_namelen = 0;

	iov[0].iov_base = ptr;
	iov[0].iov_len = nbytes;
	msg.msg_iov = iov;
	msg.msg_iovlen = 1;

	if ( (n = recvmsg(fd, &msg, 0)) <= 0)
		return(n);

#ifdef	HAVE_MSGHDR_MSG_CONTROL
	if ( (cmptr = CMSG_FIRSTHDR(&msg)) != NULL &&
	    cmptr->cmsg_len == CMSG_LEN(sizeof(int))) {
		if (cmptr->cmsg_level != SOL_SOCKET)
			err_quit("control level != SOL_SOCKET");
		if (cmptr->cmsg_type != SCM_RIGHTS)
			err_quit("control type != SCM_RIGHTS");
		*recvfd = *((int *) CMSG_DATA(cmptr));
	} else
		*recvfd = -1;		/* descriptor was not passed */
#else
/* *INDENT-OFF* */
	if (msg.msg_accrightslen == sizeof(int))
		*recvfd = newfd;
	else
		*recvfd = -1;		/* descriptor was not passed */
/* *INDENT-ON* */
#endif

	return(n);
}
/* end read_fd */


/* this little wrapper is so we can consistantly use sendfd() and recvfd()
   all across the board
*/

int recvfd(int sockfd) {
  char passbuf[2];
  int incomingfd;

  read_fd(sockfd, passbuf, sizeof(passbuf), &incomingfd);

  return incomingfd;
}




#else

/* Solaris and 4.3 BSD style systems only */


int recvfd(int sockfd) {

  int truefd;    
  struct iovec iov[1];
  struct msghdr msg;
  struct pollfd udpollfd;
  
  udpollfd.events = POLLIN;
  udpollfd.fd = sockfd;
  
  iov[0].iov_base = (char *) 0;
  iov[0].iov_len = 0;
  msg.msg_iov = iov;
  msg.msg_iovlen = 1;
  msg.msg_name = NULL;
  msg.msg_namelen = 0;
  
  msg.msg_accrights = (caddr_t) &truefd;
  msg.msg_accrightslen = sizeof(truefd);   
  
  poll(&udpollfd, 1, -1);
  
  if (Recvmsg(sockfd, &msg, 0) < 0) {
    fprintf(stderr, "Recvmsg Error.\n");
    exit(-1);
  }

  if ( msg.msg_accrightslen != sizeof(truefd) ) {
    fprintf(stderr, "accrightslen is: %i\n", (int)msg.msg_accrightslen);
    fprintf(stderr, "recvsk: FD not txferred.\n");
    return -1;
  } 

  return truefd;
}          


#endif
