/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */


#include "debug.h"
#include <string>
#include <iostream>


/*
 *
 */
static int debug_flags = SE_NO_DEBUG;

/*
 *
 */
void se_debug_init(int argc, char *argv[])
{
/*	
#define check(flag) if(g_getenv(#flag) != NULL) debug_flags |= flag;

	if(g_getenv("SE_DEBUG") != NULL)
	{
		debug_flags = ~SE_NO_DEBUG;
		return;
	}
*/

#define check(flag) if(std::string("--"#flag) == std::string(argv[i])) debug_flags |= flag;

	for(int i=0; i<argc; ++i)
	{
		check(SE_DEBUG_APP);
		check(SE_DEBUG_LOADER);
		check(SE_DEBUG_SAVER);
		check(SE_DEBUG_SEARCH);
		check(SE_DEBUG_REGEX);
		check(SE_DEBUG_GSTREAMER);
		check(SE_DEBUG_SPELL_CHECKING);

		check(SE_DEBUG_ALL);
	}

#undef check
}

/*
 *
 */
void __se_debug(
		int flag, 
		const gchar* file, 
		const gint line, 
		const gchar* fonction)
{
	if(G_UNLIKELY(debug_flags & flag) || G_UNLIKELY(debug_flags & SE_DEBUG_ALL))
	{
		g_print("%s:%d (%s)\n", file, line, fonction);
		fflush(stdout);
	}
}

/*
 *
 */
void __se_debug_message(
		int flag, 
		const gchar* file, 
		gint line, 
		const gchar* fonction, 
		const char *format, ...)
{
	if(G_UNLIKELY(debug_flags & flag) || G_UNLIKELY(debug_flags & SE_DEBUG_ALL))
	{
		va_list args;
		gchar *msg = NULL;

		g_return_if_fail(format);

		va_start(args, format);
		msg = g_strdup_vprintf(format, args);
		va_end(args);

		g_print("%s:%d (%s) %s\n", file, line, fonction, msg);
		fflush(stdout);

		g_free(msg);
	}
}

