#ifndef _Signal_h
#define _Signal_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include <sigc++/sigc++.h>
#include "Document.h"
#include "VideoInfo.h"

class Signal
{
protected:
	Signal();
	~Signal();

public:
	
	/*
	 *	instance
	 */
	static Signal& getInstance();

	/*
	 *	signal emit quand on modifie la selection dans le treeview
	 */
	sigc::signal<void, Gtk::TreeIter>		subtitle_view_selection_changed;

	/*
	 *	modification du temps sur l'iter
	 */
	sigc::signal<void, Gtk::TreeIter>		subtitle_time_changed;

	/*
	 *	affiche/cache des morceaux d'interface selon le mode
	 *	"simple", "advanced", "translation", "timing"
	 */
	sigc::signal<void, Glib::ustring>		setup_view;


	/*
	 *	signal emit quand il y a une modification 
	 *	dans la configuration section ["encodings"]
	 */
	sigc::signal<void>	config_encodings_changed;

	/*
	 * information sur le media mise a jour
	 */
	sigc::signal<void, VideoInfo>	video_info_changed;
};

#endif//_Signal_h

