#ifndef _DialogFind_h
#define _DialogFind_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */


#include <libglademm/xml.h>
#include <gtkmm/dialog.h>
#include <gtkmm/entry.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/comboboxentrytext.h>
#include <gtkmm/textview.h>
#include <gtkmm/treeiter.h>
/*
 *
 */
class DialogFindAndReplace : public Gtk::Dialog
{
public:
	DialogFindAndReplace(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade);
	~DialogFindAndReplace();

	void execute();

	void findNext();

protected:
	enum RESPONSE
	{
		CLOSE=0,
		REPLACE_ALL=1,
		REPLACE=2,
		FIND=3
	};

	/*
	 *	text : la ligne
	 *	exp : la recherche
	 */
	bool find(const Glib::ustring &text, const Glib::ustring &ex, Glib::ustring::size_type &start, Glib::ustring::size_type &len);

	/*
	 *
	 */
	bool find_and_replace(Glib::ustring &text, const Glib::ustring &exp, const Glib::ustring &replace);

	/*
	 *
	 */
	bool find_pattern_in_next_iter();

	/*
	 *
	 */
	bool find_pattern_in_current_iter();

	/*
	 *	init le textview et selectionne la recherche
	 */
	bool init_text_and_select();

	/*
	 *
	 */
	bool replace();

	/*
	 *
	 */
	bool replace_all();

	/*
	 *	CALLBACK
	 */
	void on_button_find();
	void on_button_replace();
	void on_button_replace_all();
protected:
	Gtk::TextView* m_textview;

	Gtk::Entry*	m_entryPattern;
	Gtk::Entry*	m_entryReplaceWith;

	Gtk::CheckButton*		m_checkIgnoreCase;
	Gtk::CheckButton*		m_checkUsedRegularExpression;

	Gtk::Button* m_buttonReplace;
	Gtk::Button* m_buttonReplaceAll;
	Gtk::Button* m_buttonFind;
	
	Gtk::Label*	m_labelInformation;
	// current
	bool					m_eod; // end of document ?
	Gtk::TreeIter	m_current_iter;
	Glib::ustring	m_current_text;
	Glib::ustring::size_type m_current_start;
	Glib::ustring::size_type m_current_len;
};

#endif//_DialogFind_h

