/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFFPARAM_H
#define _SC_DIFFPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"
#include "svn/DiffSummarizeBaton.h"


namespace Diff
{
  enum Type
  {
    OneSource = 0,
    TwoSources = 1
  };
}


/**
 * Parameter class for DiffCmd.
 */
class DiffParam : public ScParam
{
public:
  DiffParam( 
    const sc::String& pathOrUrl1, const svn::Revision* rev1,
    const sc::String& pathOrUrl2, const svn::Revision* rev2,
    const svn::Revision* peg, bool recurse, bool ancestry,
    bool deleted, bool summarize, bool patch,
    svn::DiffSummarizeBaton* baton = 0 )
    : _pathOrUrl1(pathOrUrl1), _rev1(rev1),
      _pathOrUrl2(pathOrUrl2), _rev2(rev2),
      _revPeg(peg), _recurse(recurse), _ancestry(ancestry),
      _deleted(deleted), _summarize(summarize), _patch(patch),
      _baton(baton)
  {
  }

  ~DiffParam()
  {
    delete _rev1;
    delete _rev2;
    delete _revPeg;
    delete _baton;
  }

  bool isPeg() const
  {
    return _revPeg != 0;
  }

  const sc::String& getPathOrUrl1() const
  {
    return _pathOrUrl1;
  }

  const sc::String& getPathOrUrl2() const
  {
    return _pathOrUrl2;
  }

  const svn::Revision* getRevision1() const
  {
    return _rev1;
  }

  const svn::Revision* getRevision2() const
  {
    return _rev2;
  }

  const svn::Revision* getPegRevision() const
  {
    return _revPeg;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  bool getAncestry() const
  {
    return _ancestry;
  }

  bool getDeleted() const
  {
    return _deleted;
  }

  bool getSummarize() const
  {
    return _summarize;
  }

  svn::DiffSummarizeBaton* getBaton() const
  {
    return _baton;
  }

  bool getPatch() const
  {
    return _patch;
  }

  sc::String& getPatchFile()
  {
    return _patchFile;
  }

  ScParamAccept(DiffParam);

private:
  // in
  sc::String               _pathOrUrl1;
  const svn::Revision*     _rev1;

  sc::String               _pathOrUrl2;  ///< only valid if _revPeg is 0
  const svn::Revision*     _rev2;

  const svn::Revision*     _revPeg;

  bool                     _recurse;
  bool                     _ancestry;
  bool                     _deleted;

  bool                     _summarize;
  bool                     _patch;      ///< true if patch file request

  svn::DiffSummarizeBaton* _baton;

  // out
  sc::String               _patchFile;  ///< the patch file if _patch is true
};

#endif // _SC_DIFFPARAM_H
