/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "FileDialog.h"
#include "PostCmdResult.h"
#include "CursorSupport.h"
#include "events/ScParamEvent.h"
#include "commands/DetailsParam.h"
#include "sublib/Utility.h"
#include "svn/DirEntry.h"

// qt
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qheader.h>
#include <qdir.h>
#include <qpixmap.h>



FileDialog::FileDialog( QWidget *parent, const char *name )
  : super( parent, name, true )
{
  setCaption( _q("subcommander:select path") );
  _dirsOnly = false;

  _folder = new QPixmap( getIconDir() + "Folder.png" );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    QGridLayout* gl = new QGridLayout(vbl,1,1);
    {
      _list = new QListView(this);
      //_list->header()->hide();
      _list->setRootIsDecorated(true);
      //_list->setAllColumnsShowFocus(true);
      _list->addColumn( _q("path") );
      //_list->addColumn( "url" );
      //_list->setColumnWidthMode(0,QListView::Maximum);
      //_list->setColumnWidthMode(1,QListView::Maximum);
      _list->setResizeMode( QListView::LastColumn );
      //_list->hideColumn(0);
      //_list->hideColumn(1);
      _list->setSorting(-1);

      connect( _list, SIGNAL(selectionChanged(QListViewItem*)),
        this, SLOT(selectionChanged(QListViewItem*)) );

      connect( _list, SIGNAL(expanded(QListViewItem*)),
        this, SLOT(expanded(QListViewItem*)) );

      gl->addWidget(_list,0,0);
    }

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      _parent = new QPushButton( _q("up"), this);
      _parent->setEnabled(true);
      hu->addWidget(_parent);

      connect( _parent, SIGNAL(clicked()), this, SLOT(parent()) );

      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      QPushButton* ok = new QPushButton(this);
      //ok->setEnabled(false);
      ok->setText( _q("&Ok") );
      ok->setDefault(true);
      hu->addWidget(ok);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      hu->addWidget(ca);

      connect( ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  resize( QSize( 300, 400 ) );
}

FileDialog::~FileDialog()
{
  delete _folder;
}

void FileDialog::setSource( const QString& root )
{
  _root = root;
  bool exists = _dir.exists(root);

  if( exists )
  {
    QListViewItem* lvi = new QListViewItem( _list, _root, _root );
    lvi->setExpandable(true);

    // fires selectionChanged to load first level
    _list->setSelected(lvi,true);
  }
  else
  {
    drives();
  }
}

QString FileDialog::getSelection()
{
  QListViewItem* item = _list->selectedItem();

  if( ! item )
  {
    return "";
  }

  // return full path from hidden column
  return item->text(1);
}

void FileDialog::setDirsOnly( bool b )
{
  _dirsOnly = b;
}

void FileDialog::selectionChanged( QListViewItem* lvi )
{
  if( lvi->text(1) == _root )
  {
    _parent->setEnabled(true);
  }
  else
  {
    _parent->setEnabled(false);
  }

  if( lvi->childCount() != 0 || !lvi->isExpandable() )
  {
    return;
  }

  _dir.setPath( lvi->text(1) );

  const QFileInfoList*  fiList = _dir.entryInfoList(
    (_dirsOnly ? QDir::Dirs : QDir::Dirs | QDir::Files ),
    QDir::Name | QDir::DirsFirst );

  if( ! fiList )
  {
    return;
  }

  QFileInfoListIterator fiIt( *fiList );
  fiIt.toLast();
  QFileInfo* fi;

  while( (fi = fiIt.current()) != 0 )
  {
    if( fi->fileName() != "." && fi->fileName() != ".." )
    {
      QListViewItem* nlvi = new QListViewItem( lvi, fi->fileName(), fi->absFilePath() );

      if( fi->isDir() )
      {
        nlvi->setExpandable(true);
        nlvi->setPixmap(0,*_folder);
      }
    }
    --fiIt;
  }
  _list->setOpen( lvi, true );
}

void FileDialog::expanded( QListViewItem* lvi )
{
  _list->setSelected(lvi,true);
}

void FileDialog::parent()
{
  _dir.setPath(_root);

  bool exists = _dir.cdUp();
  if( exists )
  {
    _list->clear();
    setSource( _dir.absPath() );
  }
  else
  {
    drives();
  }
}

void FileDialog::drives()
{
  _list->clear();

  const QFileInfoList* fiList = _dir.drives();

  QFileInfoListIterator fiIt( *fiList );
  fiIt.toLast();

  QFileInfo* fi;

  while( (fi = fiIt.current()) != 0 )
  {
    QListViewItem* nlvi = new QListViewItem( _list, fi->absFilePath(), fi->absFilePath() );

    if( fi->isDir() )
    {
      nlvi->setExpandable(true);
    }
    --fiIt;
  }
}
