/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "CommitItemLvi.h"
#include "svn/CommitItem.h"

// qt


// this must match with the columns added to the ListView in CommitDialog
enum Columns
{
  cKind,
  cFlags,
  cItem
/*
  cProps,
  cCopyUrl,
  cCopyRev
*/
};


CommitItemLvi::CommitItemLvi( QListView* parent, const svn::CommitItemPtr item,
  const QString& itemStr ) : super(parent), _item(item), _itemStr(itemStr)
{
}

CommitItemLvi::~CommitItemLvi()
{
}

QString CommitItemLvi::text( int column ) const
{
  switch( column )
  {
  case cKind:
    {
      char* kinds[] =
      {
        _n("none"),
        _n("file"),
        _n("folder"),
        _n("unknown")
      };
      return _q(kinds[_item->getKind()]);
    }
  case cFlags:
    {
      QString res;

      if( _item->getFlags() & svn::CommitItem::Flag_Add )
        res += _q("A");
      if( _item->getFlags() & svn::CommitItem::Flag_Delete )
        res += _q("D");
      if( _item->getFlags() & svn::CommitItem::Flag_TextMod )
        res += _q("M");
      if( _item->getFlags() & svn::CommitItem::Flag_PropMod )
        res += _q("P");
      if( _item->getFlags() & svn::CommitItem::Flag_IsCopy )
        res += _q("C");

      return res;
    }
  case cItem:
    {
      return _itemStr;
    }
  default:
    {
      return "?";
    }
  }
}

const svn::CommitItemPtr CommitItemLvi::getItem() const
{
  return _item;
}
