# Downloaded from: http://www-id.imag.fr/FLOWVR/manual/flowvr-suite-src/flowvr-render/cmake/
# License: GPL v2, http://www-id.imag.fr/FLOWVR/manual/flowvr-suite-src/flowvr-render/COPYING
#
# Modifications:
# 2008.01.16 Tobi Vollebregt -- changed Devil->DEVIL for consistency
#                            -- added devil, ilu, ilut alternative names for MinGW
#                            -- removed "looking for devil" status message

# - Find DevIL
# Find the native DevIL includes and libraries.
#
#  DEVIL_INCLUDE_DIR  - Where to find "IL/il.h", "IL/ilu.h" and "IL/ilut.h"
#  DEVIL_IL_LIBRARY   - Path to the IL shared library
#  DEVIL_ILU_LIBRARY  - Path to the ILU shared library
#  DEVIL_ILUT_LIBRARY - Path to the ILUT shared library
#  DEVIL_LIBRARIES    - List of libraries when using IL
#  DEVIL_FOUND        - True if IL is found.

INCLUDE(FindPackageHandleStandardArgs)

IF    (DEVIL_INCLUDE_DIR AND DEVIL_IL_LIBRARY)
	# Already in cache, be silent
	SET(DevIL_FIND_QUIETLY TRUE)
ENDIF (DEVIL_INCLUDE_DIR AND DEVIL_IL_LIBRARY)



set(DEVIL_FIND_LIB_STD_ARGS
	PATH_SUFFIXES
		lib64
		lib
		libs64
		libs
		libs/Win32
		libs/Win64
	PATHS
		${PROJECT_BINARY_DIR}
		${PROJECT_SOURCE_DIR}
		$ENV{LD_LIBRARY_PATH}
		$ENV{LIBRARY_PATH}
		/usr
		/usr/local
		/usr/bin
	)

FIND_LIBRARY(DEVIL_IL_LIBRARY
	NAMES
		IL
		devil
		DevIL
	${DEVIL_FIND_LIB_STD_ARGS}
)

FIND_LIBRARY(DEVIL_ILU_LIBRARY
	NAMES
		ilu
		ILU
	${DEVIL_FIND_LIB_STD_ARGS}
)

FIND_LIBRARY(DEVIL_ILUT_LIBRARY
	NAMES
		ilut
		ILUT
	${DEVIL_FIND_LIB_STD_ARGS}
)

SET(DEVIL_LIBRARIES )
IF    (DEVIL_IL_LIBRARY)
	LIST(APPEND DEVIL_LIBRARIES ${DEVIL_IL_LIBRARY}})
ENDIF (DEVIL_IL_LIBRARY)
IF    (DEVIL_ILU_LIBRARY)
	LIST(APPEND DEVIL_LIBRARIES ${DEVIL_ILU_LIBRARY}})
ENDIF (DEVIL_ILU_LIBRARY)
IF    (DEVIL_ILUT_LIBRARY)
	LIST(APPEND DEVIL_LIBRARIES ${DEVIL_ILUT_LIBRARY}})
ENDIF (DEVIL_ILUT_LIBRARY)

GET_FILENAME_COMPONENT(DEVIL_LIBRARY_DIR "${DEVIL_IL_LIBRARY}" PATH)
GET_FILENAME_COMPONENT(DEVIL_LIBRARY_SUPER_DIR "${DEVIL_LIBRARY_DIR}" PATH)



set(DEVIL_FIND_HEADER_STD_ARGS
	PATHS
		${PROJECT_BINARY_DIR}/include
		${PROJECT_SOURCE_DIR}/include
		${DEVIL_LIBRARY_SUPER_DIR}/include
		$ENV{CPATH}
		/usr/local/include
		/usr/include
	NO_DEFAULT_PATH
	)

FIND_FILE(DEVIL_IL_HEADER IL/il.h
	${DEVIL_FIND_INCLUDE_STD_ARGS}
)

FIND_FILE(DEVIL_ILU_HEADER IL/ilu.h
	${DEVIL_FIND_INCLUDE_STD_ARGS}
)

FIND_FILE(DEVIL_ILUT_HEADER IL/ilut.h
	${DEVIL_FIND_INCLUDE_STD_ARGS}
)

FIND_PATH(DEVIL_INCLUDE_DIR IL/il.h
	${DEVIL_FIND_INCLUDE_STD_ARGS}
)



# handle the QUIETLY and REQUIRED arguments and set DEVIL_FOUND to TRUE if
# all listed variables are TRUE
FIND_PACKAGE_HANDLE_STANDARD_ARGS(DevIL DEFAULT_MSG DEVIL_IL_HEADER DEVIL_INCLUDE_DIR DEVIL_IL_LIBRARY)

IF    (DEVIL_ILU_HEADER AND DEVIL_ILU_LIBRARY)
	SET(DEVIL_ILU_FOUND TRUE)
	IF    (NOT DevIL_FIND_QUIETLY)
		MESSAGE(STATUS "Found DevIL-ILU: ${DEVIL_ILU_LIBRARY} - ${DEVIL_ILU_HEADER}")
	ENDIF (NOT DevIL_FIND_QUIETLY)
ELSE  (DEVIL_ILU_HEADER AND DEVIL_ILU_LIBRARY)
	SET(DEVIL_ILU_FOUND FALSE)
ENDIF (DEVIL_ILU_HEADER AND DEVIL_ILU_LIBRARY)

IF    (DEVIL_ILUT_HEADER AND DEVIL_ILUT_LIBRARY)
	SET(DEVIL_ILUT_FOUND TRUE)
	IF    (NOT DevIL_FIND_QUIETLY)
		MESSAGE(STATUS "Found DevIL-ILUT: ${DEVIL_ILUT_LIBRARY} - ${DEVIL_ILUT_HEADER}")
	ENDIF (NOT DevIL_FIND_QUIETLY)
ELSE  (DEVIL_ILUT_HEADER AND DEVIL_ILUT_LIBRARY)
	SET(DEVIL_ILUT_FOUND FALSE)
ENDIF (DEVIL_ILUT_HEADER AND DEVIL_ILUT_LIBRARY)



MARK_AS_ADVANCED(
	DEVIL_INCLUDE_DIR
	DEVIL_IL_LIBRARY
	DEVIL_ILU_LIBRARY
	DEVIL_ILUT_LIBRARY
	DEVIL_LIBRARIES
	)
