/*
 * (C) Copyright 2002, Schlund+Partner AG
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
 * @file XMLNodeSet.hpp
 * @version @$Id: XMLNodeSet.hpp,v 1.9 2002/12/19 15:16:45 spabsurd Exp $
 * @author Schlund + Partner AG
 * @brief *ps*
 *
 * (C) Copyright by Schlund+Partner AG
 *
 * Synopsis: @#include <sp-gxmlcpp/XMLNodeSet.hpp>
 *
 */

#ifndef SP_GXML_XMLNODESET_HPP
#define SP_GXML_XMLNODESET_HPP

// C libraries
#include <libxslt/xsltInternals.h>
#include <libxml/xpath.h>
#include <libxml/tree.h>

// Local
#include <sp-gxmlcpp/XMLNode.hpp>
#include <sp-gxmlcpp/XMLException.hpp>

namespace SP
{
namespace GXML
{

// forward declarations
class XMLTree;

class XMLNodeSet
{
public:
	XMLNodeSet( const std::string& xpath, const XMLTree* tree );
	~XMLNodeSet();

	class Iterator
	{
	public:
		Iterator();
		Iterator( const xmlNodeSetPtr set );
		~Iterator();
		Iterator operator ++();
		bool operator !=( const Iterator& iter);
		XMLNode operator *();
		int getPosition();

	private:
		int pos_;
		xmlNodeSetPtr set_;
	};

	int size();
	Iterator begin();
	Iterator end();
	//Iterator rbegin();
	//Iterator rend();

private:
	xmlXPathObjectPtr xPathObj_;
};

}}
#endif
