#include <config.h>
#include <iostream>
#include "PPMReader.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int PPMReader::ReadNumber( )
{
	int value = 0;
	int c = '\0';

	do 
	{
		while( !feof( GetFile( ) ) && !isdigit( c ) && c != '#' )
			c = fgetc( GetFile( ) );

		if ( c == '#' )
			while( !feof( GetFile( ) ) && c != '\n' )
				c = fgetc( GetFile( ) );
	}
	while ( !isdigit( c ) && !feof( GetFile( ) ) );

	while( isdigit( c ) && !feof( GetFile( ) ) )
	{
		value = value * 10 + ( c - '0' );
		c = fgetc( GetFile( ) );
	}

	return value;
}

static int16_t audio_buf[ 4 * DV_AUDIO_MAX_SAMPLES ];

bool PPMReader::ReadHeader( int &width, int &height )
{
	char type[ 100 ];
	int maxval;

	while ( fscanf( GetFile( ), "%s", type ) == 1 )
	{
		if ( !strcmp( type, "P6" ) )
		{
			width = ReadNumber( );
			height = ReadNumber( );
			maxval = ReadNumber( );
			break;
		}
		else if ( !strcmp( type, "A6" ) )
		{
			int frequency = ReadNumber( );
			int channels = ReadNumber( );
			int samples = ReadNumber( );
			fread( audio_buf, channels * samples * sizeof( int16_t ), 1, GetFile( ) );
			fprintf( stdout, "A6 %d %d %d\n", frequency, channels, samples );
			fwrite( audio_buf, channels * samples * sizeof( int16_t ), 1, stdout );
		}
		else
		{
			break;
		}
	}

	return !strcmp( type, "P6" ) && width != 0 && height != 0;
}

bool PPMReader::ReadScaledFrame( uint8_t *image, int width, int height )
{
	int image_width = 0;
	int image_height = 0;
	bool ret = ReadHeader( image_width, image_height );

	if ( ret )
	{
		static int last_image_width = image_width;
		static int last_image_height = image_height;
		static uint8_t *scan = NULL;
		
		if ( last_image_width != image_width || last_image_height != image_height )
		{
			free( scan );
			scan = NULL;
			last_image_width = width;
			last_image_height = height;
		}

		if ( scan == NULL )
			scan = (uint8_t *)malloc( image_height * image_width * 3 );

		for ( int line = 0; line < image_height; line ++ )
			fread( scan + line * image_width * 3 , 1, image_width * 3, GetFile( ) );

		GdkPixbuf *input = gdk_pixbuf_new_from_data( scan, GDK_COLORSPACE_RGB, FALSE, 8, image_width, image_height, image_width * 3, NULL, NULL );
		GdkPixbuf *scaled = gdk_pixbuf_scale_simple( input, width, height, scaler );
		int stride = gdk_pixbuf_get_rowstride( scaled );

		Composite( image, width, height, gdk_pixbuf_get_pixels( scaled ), width, height, stride );

		gdk_pixbuf_unref( scaled );
		gdk_pixbuf_unref( input );
	}

	return ret;
}

void PPMReader::Composite( uint8_t *dest, int width, int height,
				uint8_t *src, int src_width, int src_height, int stride )
{
	register int i;
	register uint8_t *p_src, *p_dest;
	
	int off_x = ( width - src_width ) / 2;
	int off_y = ( height - src_height ) / 2;

	p_dest = dest + (((off_y * src_width) + off_x) * 3);
	p_src = src;
	for (i = 0; i < src_height; i++ ) 
	{
		memcpy( p_dest, p_src, src_width*3);
		p_dest += width*3;
		p_src += stride;
	}
}

bool PPMReader::ReadAspectFrame( uint8_t *image, int width, int height )
{
	int image_width = 0;
	int image_height = 0;
	bool ret = ReadHeader( image_width, image_height );

	if ( ret )
	{
		uint8_t *scan = (uint8_t *)malloc( image_height * image_width * 3 );

		for ( int line = 0; line < image_height; line ++ )
			fread( scan + line * image_width * 3 , 1, image_width * 3, GetFile( ) );

		DV_RGB rgb;
		GetBackgroundColour( rgb );
		FillWithBackgroundColour( image, width, height, rgb );

	    double ratioWidth = (double)width / (double)image_width;
   		double ratioHeight = (double)height / (double)image_height;
		int final_width, final_height;
			
   		if ( ratioHeight < ratioWidth ) 
		{
   			final_width = (int)( image_width * ratioHeight );
   			final_height = (int)( image_height * ratioHeight );
   		} 
		else 
		{
   			final_width = (int)( image_width * ratioWidth );
   			final_height = (int)( image_height * ratioWidth );
   		}

		GdkPixbuf *input = gdk_pixbuf_new_from_data( scan, GDK_COLORSPACE_RGB, FALSE, 8, image_width, image_height, image_width * 3, NULL, NULL );
		GdkPixbuf *scaled = gdk_pixbuf_scale_simple( input, final_width, final_height, scaler );
		int stride = gdk_pixbuf_get_rowstride( scaled );
		
		Composite( image, width, height, gdk_pixbuf_get_pixels( scaled ), final_width, final_height, stride );

		gdk_pixbuf_unref( scaled );
		gdk_pixbuf_unref( input );

		free( scan );
	}

	return ret;
}

bool PPMReader::ReadCroppedFrame( uint8_t *image, int width, int height )
{
	int image_width = 0;
	int image_height = 0;
	bool ret = ReadHeader( image_width, image_height );

	if ( ret )
	{
		static uint8_t *scan_line = (uint8_t *)malloc( image_width * 3 );

		DV_RGB rgb;
		GetBackgroundColour( rgb );
		FillWithBackgroundColour( image, width, height, rgb );

		int start_line = image_height / 2 - height / 2;
		int end_line = image_height / 2 + height / 2;
		int start_offset = 0;
		int line_width = image_width;
		int output_offset = width / 2 - image_width / 2;

		if ( image_width >= width )
		{
			start_offset = image_width / 2 - width / 2;
			line_width = width;
			output_offset = 0;
		}

		for ( int line = 0; line < image_height; line ++ )
		{
			fread( scan_line, 1, image_width * 3, GetFile( ) );
			if ( line >= start_line && line < end_line )
				memcpy( image + ( line - start_line ) * width * 3 + output_offset * 3, scan_line + start_offset * 3, line_width * 3 );
		}
	}

	return ret;
}

bool PPMReader::ReadPPM( uint8_t *image, int width, int height )
{
	bool obtained = false;

	while ( dropper != 1 && count ++ % dropper != 0 )
	{
		ReadCroppedFrame( image, width, height );
	}
	
	switch( GetScale( ) )
	{
		case SCALE_ASPECT_RATIO:
			obtained = ReadAspectFrame( image, width, height );
			break;
		case SCALE_FULL:
			obtained = ReadScaledFrame( image, width, height );
			break;
		case SCALE_NONE:
		defaut:
			obtained = ReadCroppedFrame( image, width, height );
			break;
	}

	return obtained;
}
