/*
 * PPMDVFileInput.h -- DV Pump and Sundry Common Implementations
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_PPM_DV_FILE_INPUT_H
#define _KINO_PPM_DV_FILE_INPUT_H

#include <string>
using std::string;

#include "Diagnostics.h"
#include "DVPumpProvider.h"
#include "DVEncoder.h"
#include "PPMReader.h"
#include <stdio.h>

class Frame;
class PlayList;

/** This implementation provides a threaded DV encoder which sources images 
	from a connected PPM stream.
*/

class PPMDVFileInput : 
	public DVPumpProvider, 
	virtual public DVEncoder, 
	virtual public PPMReader
{
	private:
		FILE *file;
		uint8_t *image;
		bool output_ppm;
		bool output_preview;

	public:
		PPMDVFileInput( );
		PPMDVFileInput( DVEncoderParams & );
		virtual ~PPMDVFileInput( );
		virtual string LogId( ) { return "PPMDVFileInput"; }
		void SetFile( FILE * );
		void SetPPMOutput( bool );
		void SetPPMPreview( bool );

	protected:
		bool ReadFrame( Frame & );
		FILE *GetFile( );
};

#endif

