/* ui.c generated by valac 0.16.0, the Vala compiler
 * generated from ui.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;
typedef struct _SimpleScanPrivate SimpleScanPrivate;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
#define _scan_options_unref0(var) ((var == NULL) ? NULL : (var = (scan_options_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ParamSpecSimpleScan ParamSpecSimpleScan;

struct _SimpleScan {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SimpleScanPrivate * priv;
};

struct _SimpleScanClass {
	GTypeClass parent_class;
	void (*finalize) (SimpleScan *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _SimpleScanPrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkWindow* window;
	GtkVBox* main_vbox;
	GtkInfoBar* info_bar;
	GtkImage* info_bar_image;
	GtkLabel* info_bar_label;
	GtkButton* info_bar_close_button;
	GtkButton* info_bar_change_scanner_button;
	GtkMenuItem* page_move_left_menuitem;
	GtkMenuItem* page_move_right_menuitem;
	GtkMenuItem* page_delete_menuitem;
	GtkMenuItem* crop_rotate_menuitem;
	GtkMenuItem* save_menuitem;
	GtkMenuItem* save_as_menuitem;
	GtkToolButton* save_toolbutton;
	GtkMenuItem* stop_menuitem;
	GtkToolButton* stop_toolbutton;
	GtkRadioMenuItem* text_toolbar_menuitem;
	GtkRadioMenuItem* text_menu_menuitem;
	GtkRadioMenuItem* photo_toolbar_menuitem;
	GtkRadioMenuItem* photo_menu_menuitem;
	GtkDialog* authorize_dialog;
	GtkLabel* authorize_label;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	GtkDialog* preferences_dialog;
	GtkComboBox* device_combo;
	GtkComboBox* text_dpi_combo;
	GtkComboBox* photo_dpi_combo;
	GtkComboBox* page_side_combo;
	GtkComboBox* paper_size_combo;
	GtkListStore* device_model;
	GtkListStore* text_dpi_model;
	GtkListStore* photo_dpi_model;
	GtkListStore* page_side_model;
	GtkListStore* paper_size_model;
	gboolean setting_devices;
	gboolean user_selected_device;
	GtkFileChooserDialog* save_dialog;
	gboolean have_error;
	gchar* error_title;
	gchar* error_text;
	gboolean error_change_scanner_hint;
	Book* book;
	gchar* book_uri;
	BookView* book_view;
	gboolean updating_page_menu;
	gint default_page_width;
	gint default_page_height;
	gint default_page_dpi;
	ScanDirection default_page_scan_direction;
	gchar* document_hint;
	gchar* default_file_name;
	gboolean scanning;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecSimpleScan {
	GParamSpec parent_instance;
};


static gpointer simple_scan_parent_class = NULL;

gpointer simple_scan_ref (gpointer instance);
void simple_scan_unref (gpointer instance);
GParamSpec* param_spec_simple_scan (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_simple_scan (GValue* value, gpointer v_object);
void value_take_simple_scan (GValue* value, gpointer v_object);
gpointer value_get_simple_scan (const GValue* value);
GType simple_scan_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
GType book_view_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define SIMPLE_SCAN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIMPLE_SCAN, SimpleScanPrivate))
enum  {
	SIMPLE_SCAN_DUMMY_PROPERTY
};
#define SIMPLE_SCAN_DEFAULT_TEXT_DPI 150
#define SIMPLE_SCAN_DEFAULT_PHOTO_DPI 300
SimpleScan* simple_scan_new (void);
SimpleScan* simple_scan_construct (GType object_type);
Book* book_new (void);
Book* book_construct (GType object_type);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static void simple_scan_page_removed_cb (SimpleScan* self, Book* book, Page* page);
static void _simple_scan_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self);
static void simple_scan_page_added_cb (SimpleScan* self, Book* book, Page* page);
static void _simple_scan_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self);
static void simple_scan_load (SimpleScan* self);
static gboolean simple_scan_find_scan_device (SimpleScan* self, const gchar* device, GtkTreeIter* iter);
static void simple_scan_show_error_dialog (SimpleScan* self, const gchar* error_title, const gchar* error_text);
void simple_scan_set_default_file_name (SimpleScan* self, const gchar* default_file_name);
void simple_scan_authorize (SimpleScan* self, const gchar* resource, gchar** username, gchar** password);
void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, SimpleScan* self);
static void simple_scan_update_info_bar (SimpleScan* self);
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
void simple_scan_set_scan_devices (SimpleScan* self, GList* devices);
static gchar* simple_scan_get_selected_device (SimpleScan* self);
void simple_scan_set_selected_device (SimpleScan* self, const gchar* device);
static void simple_scan_add_default_page (SimpleScan* self);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_view_select_page (BookView* self, Page* page);
static void simple_scan_on_file_type_changed (SimpleScan* self, GtkTreeSelection* selection);
static gchar* simple_scan_choose_file_location (SimpleScan* self);
static void _simple_scan_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static gboolean simple_scan_save_document (SimpleScan* self, gboolean force_choose_location);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
void simple_scan_show_error (SimpleScan* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
void book_set_needs_saving (Book* self, gboolean needs_saving);
static gboolean simple_scan_prompt_to_save (SimpleScan* self, const gchar* title, const gchar* discard_label);
gboolean book_get_needs_saving (Book* self);
static void simple_scan_clear_document (SimpleScan* self);
void book_clear (Book* self);
void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
static void simple_scan_set_document_hint (SimpleScan* self, const gchar* document_hint);
void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
GType scan_type_get_type (void) G_GNUC_CONST;
static void simple_scan_set_page_side (SimpleScan* self, ScanType page_side);
static void simple_scan_set_paper_size (SimpleScan* self, gint width, gint height);
static gint simple_scan_get_text_dpi (SimpleScan* self);
static gint simple_scan_get_photo_dpi (SimpleScan* self);
static ScanType simple_scan_get_page_side (SimpleScan* self);
static gboolean simple_scan_get_paper_size (SimpleScan* self, gint* width, gint* height);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static ScanOptions* simple_scan_get_scan_options (SimpleScan* self);
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
GType scan_mode_get_type (void) G_GNUC_CONST;
void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, SimpleScan* self);
static void simple_scan_update_page_menu (SimpleScan* self);
Page* book_view_get_selected (BookView* self);
guint book_get_page_index (Book* self, Page* page);
guint book_get_n_pages (Book* self);
static void simple_scan_page_selected_cb (SimpleScan* self, BookView* view, Page* page);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension);
static void simple_scan_show_page_cb (SimpleScan* self, BookView* view, Page* page);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
static void simple_scan_show_page_menu_cb (SimpleScan* self, BookView* view);
void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void page_rotate_left (Page* self);
void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void page_rotate_right (Page* self);
static void simple_scan_set_crop (SimpleScan* self, const gchar* crop_name);
void page_set_no_crop (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
void page_set_named_crop (Page* self, const gchar* name);
void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, SimpleScan* self);
void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self);
void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void page_rotate_crop (Page* self);
void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void book_move_page (Book* self, Page* page, guint location);
void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
Book* book_view_get_book (BookView* self);
void book_delete_page (Book* self, Page* page);
void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
static void simple_scan_draw_page (SimpleScan* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number);
Page* book_get_page (Book* self, gint page_number);
gboolean page_is_landscape (Page* self);
gint page_get_dpi (Page* self);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, SimpleScan* self);
static void _simple_scan_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
static gboolean simple_scan_on_quit (SimpleScan* self);
void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self);
gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, SimpleScan* self);
static void simple_scan_info_bar_response_cb (SimpleScan* self, GtkInfoBar* widget, gint response_id);
gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, SimpleScan* self);
gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, SimpleScan* self);
static void simple_scan_page_size_changed_cb (SimpleScan* self, Page* page);
static void simple_scan_page_scan_direction_changed_cb (SimpleScan* self, Page* page);
ScanDirection page_get_scan_direction (Page* self);
static void _simple_scan_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void _simple_scan_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
static void simple_scan_set_dpi_combo (SimpleScan* self, GtkComboBox* combo, gint default_dpi, gint current_dpi);
static void simple_scan_needs_saving_cb (SimpleScan* self, Book* book);
static void _simple_scan_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
BookView* book_view_new (Book* book);
BookView* book_view_construct (GType object_type, Book* book);
static void _simple_scan_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self);
static void _simple_scan_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self);
static void _simple_scan_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self);
static void _simple_scan_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self);
Book* simple_scan_get_book (SimpleScan* self);
void simple_scan_set_selected_page (SimpleScan* self, Page* page);
Page* simple_scan_get_selected_page (SimpleScan* self);
void simple_scan_set_scanning (SimpleScan* self, gboolean scanning);
void simple_scan_start (SimpleScan* self);
static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void simple_scan_finalize (SimpleScan* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _simple_scan_page_removed_cb_book_page_removed (Book* _sender, Page* page, gpointer self) {
	simple_scan_page_removed_cb (self, _sender, page);
}


static void _simple_scan_page_added_cb_book_page_added (Book* _sender, Page* page, gpointer self) {
	simple_scan_page_added_cb (self, _sender, page);
}


SimpleScan* simple_scan_construct (GType object_type) {
	SimpleScan* self = NULL;
	Book* _tmp0_;
	Book* _tmp1_;
	Book* _tmp2_;
	GSettings* _tmp3_;
	self = (SimpleScan*) g_type_create_instance (object_type);
	_tmp0_ = book_new ();
	_book_unref0 (self->priv->book);
	self->priv->book = _tmp0_;
	_tmp1_ = self->priv->book;
	g_signal_connect (_tmp1_, "page-removed", (GCallback) _simple_scan_page_removed_cb_book_page_removed, self);
	_tmp2_ = self->priv->book;
	g_signal_connect (_tmp2_, "page-added", (GCallback) _simple_scan_page_added_cb_book_page_added, self);
	_tmp3_ = g_settings_new ("org.gnome.SimpleScan");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp3_;
	simple_scan_load (self);
	return self;
}


SimpleScan* simple_scan_new (void) {
	return simple_scan_construct (TYPE_SIMPLE_SCAN);
}


static gboolean simple_scan_find_scan_device (SimpleScan* self, const gchar* device, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean have_iter;
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	have_iter = FALSE;
	_tmp0_ = self->priv->device_model;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	_vala_iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gchar* d = NULL;
				GtkListStore* _tmp10_;
				GtkTreeIter _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_;
					gboolean _tmp9_;
					_tmp6_ = have_iter;
					if (!_tmp6_) {
						GtkListStore* _tmp7_;
						gboolean _tmp8_ = FALSE;
						_tmp7_ = self->priv->device_model;
						_tmp8_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &_vala_iter);
						_tmp5_ = _tmp8_;
					} else {
						_tmp5_ = FALSE;
					}
					_tmp9_ = _tmp5_;
					if (!_tmp9_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp10_ = self->priv->device_model;
				_tmp11_ = _vala_iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 0, &d, -1, -1);
				_tmp12_ = d;
				_tmp13_ = device;
				if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
					have_iter = TRUE;
				}
				_g_free0 (d);
			}
		}
	}
	result = have_iter;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


static void simple_scan_show_error_dialog (SimpleScan* self, const gchar* error_title, const gchar* error_text) {
	GtkWindow* _tmp0_;
	const gchar* _tmp1_;
	GtkMessageDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* dialog;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_title != NULL);
	g_return_if_fail (error_text != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = error_title;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp1_);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	dialog = _tmp3_;
	gtk_dialog_add_button ((GtkDialog*) dialog, GTK_STOCK_CLOSE, 0);
	_tmp4_ = error_text;
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp4_);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


void simple_scan_set_default_file_name (SimpleScan* self, const gchar* default_file_name) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (default_file_name != NULL);
	_tmp0_ = default_file_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->default_file_name);
	self->priv->default_file_name = _tmp1_;
}


void simple_scan_authorize (SimpleScan* self, const gchar* resource, gchar** username, gchar** password) {
	gchar* _vala_username = NULL;
	gchar* _vala_password = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* description;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkLabel* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GtkEntry* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (resource != NULL);
	_tmp0_ = _ ("Username and password required to access '%s'");
	_tmp1_ = resource;
	_tmp2_ = g_strdup_printf (_tmp0_, _tmp1_);
	description = _tmp2_;
	_tmp3_ = self->priv->username_entry;
	gtk_entry_set_text (_tmp3_, "");
	_tmp4_ = self->priv->password_entry;
	gtk_entry_set_text (_tmp4_, "");
	_tmp5_ = self->priv->authorize_label;
	gtk_label_set_text (_tmp5_, description);
	_tmp6_ = self->priv->authorize_dialog;
	gtk_widget_show ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->authorize_dialog;
	gtk_dialog_run (_tmp7_);
	_tmp8_ = self->priv->authorize_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->username_entry;
	_tmp10_ = gtk_entry_get_text (_tmp9_);
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (_vala_username);
	_vala_username = _tmp11_;
	_tmp12_ = self->priv->password_entry;
	_tmp13_ = gtk_entry_get_text (_tmp12_);
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (_vala_password);
	_vala_password = _tmp14_;
	_g_free0 (description);
	if (username) {
		*username = _vala_username;
	} else {
		_g_free0 (_vala_username);
	}
	if (password) {
		*password = _vala_password;
	} else {
		_g_free0 (_vala_password);
	}
}


void G_MODULE_EXPORT device_combo_changed_cb (GtkWidget* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->setting_devices;
	if (_tmp0_) {
		return;
	}
	self->priv->user_selected_device = TRUE;
}


static void simple_scan_update_info_bar (SimpleScan* self) {
	GtkMessageType type = 0;
	gchar* title = NULL;
	gchar* text = NULL;
	gchar* image_id = NULL;
	gboolean show_close_button;
	gboolean show_change_scanner_button;
	gboolean _tmp0_;
	GtkInfoBar* _tmp15_;
	GtkMessageType _tmp16_;
	GtkImage* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* message;
	GtkLabel* _tmp22_;
	const gchar* _tmp23_;
	GtkButton* _tmp24_;
	gboolean _tmp25_;
	GtkButton* _tmp26_;
	gboolean _tmp27_;
	GtkInfoBar* _tmp28_;
	g_return_if_fail (self != NULL);
	show_close_button = FALSE;
	show_change_scanner_button = FALSE;
	_tmp0_ = self->priv->have_error;
	if (_tmp0_) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_;
		type = GTK_MESSAGE_ERROR;
		_tmp1_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
		_g_free0 (image_id);
		image_id = _tmp1_;
		_tmp2_ = self->priv->error_title;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (title);
		title = _tmp3_;
		_tmp4_ = self->priv->error_text;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (text);
		text = _tmp5_;
		show_close_button = TRUE;
		_tmp6_ = self->priv->error_change_scanner_hint;
		show_change_scanner_button = _tmp6_;
	} else {
		GtkListStore* _tmp7_;
		gint _tmp8_ = 0;
		_tmp7_ = self->priv->device_model;
		_tmp8_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp7_, NULL);
		if (_tmp8_ == 0) {
			gchar* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			type = GTK_MESSAGE_WARNING;
			_tmp9_ = g_strdup (GTK_STOCK_DIALOG_WARNING);
			_g_free0 (image_id);
			image_id = _tmp9_;
			_tmp10_ = _ ("No scanners detected");
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (title);
			title = _tmp11_;
			_tmp12_ = _ ("Please check your scanner is connected and powered on");
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (text);
			text = _tmp13_;
		} else {
			GtkInfoBar* _tmp14_;
			_tmp14_ = self->priv->info_bar;
			gtk_widget_hide ((GtkWidget*) _tmp14_);
			_g_free0 (image_id);
			_g_free0 (text);
			_g_free0 (title);
			return;
		}
	}
	_tmp15_ = self->priv->info_bar;
	_tmp16_ = type;
	gtk_info_bar_set_message_type (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->info_bar_image;
	_tmp18_ = image_id;
	gtk_image_set_from_stock (_tmp17_, _tmp18_, GTK_ICON_SIZE_DIALOG);
	_tmp19_ = title;
	_tmp20_ = text;
	_tmp21_ = g_strdup_printf ("<big><b>%s</b></big>\n\n%s", _tmp19_, _tmp20_);
	message = _tmp21_;
	_tmp22_ = self->priv->info_bar_label;
	_tmp23_ = message;
	gtk_label_set_markup (_tmp22_, _tmp23_);
	_tmp24_ = self->priv->info_bar_close_button;
	_tmp25_ = show_close_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp24_, _tmp25_);
	_tmp26_ = self->priv->info_bar_change_scanner_button;
	_tmp27_ = show_change_scanner_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp26_, _tmp27_);
	_tmp28_ = self->priv->info_bar;
	gtk_widget_show ((GtkWidget*) _tmp28_);
	_g_free0 (message);
	_g_free0 (image_id);
	_g_free0 (text);
	_g_free0 (title);
}


static gpointer _scan_device_ref0 (gpointer self) {
	return self ? scan_device_ref (self) : NULL;
}


void simple_scan_set_scan_devices (SimpleScan* self, GList* devices) {
	gboolean have_selection;
	gint index = 0;
	GtkTreeIter iter = {0};
	gboolean _tmp0_;
	GList* _tmp3_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_;
	gboolean _tmp55_;
	g_return_if_fail (self != NULL);
	have_selection = FALSE;
	self->priv->setting_devices = TRUE;
	_tmp0_ = self->priv->user_selected_device;
	if (_tmp0_) {
		GtkComboBox* _tmp1_;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->device_combo;
		_tmp2_ = gtk_combo_box_get_active (_tmp1_);
		have_selection = _tmp2_ >= 0;
	}
	index = 0;
	_tmp3_ = devices;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp3_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			ScanDevice* _tmp4_;
			ScanDevice* device = NULL;
			_tmp4_ = _scan_device_ref0 ((ScanDevice*) device_it->data);
			device = _tmp4_;
			{
				gint n_delete;
				GtkListStore* _tmp5_;
				gint _tmp6_;
				GtkTreeIter _tmp7_ = {0};
				gboolean _tmp8_ = FALSE;
				gint _tmp21_;
				gint _tmp45_;
				n_delete = -1;
				_tmp5_ = self->priv->device_model;
				_tmp6_ = index;
				_tmp8_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp5_, &_tmp7_, NULL, _tmp6_);
				iter = _tmp7_;
				if (_tmp8_) {
					gint i;
					i = 0;
					{
						gboolean _tmp9_;
						_tmp9_ = TRUE;
						while (TRUE) {
							gboolean _tmp10_;
							gchar* name = NULL;
							gboolean matched = FALSE;
							GtkListStore* _tmp13_;
							GtkTreeIter _tmp14_;
							const gchar* _tmp15_;
							ScanDevice* _tmp16_;
							const gchar* _tmp17_;
							gboolean _tmp18_;
							gint _tmp20_;
							_tmp10_ = _tmp9_;
							if (!_tmp10_) {
								GtkListStore* _tmp11_;
								gboolean _tmp12_ = FALSE;
								_tmp11_ = self->priv->device_model;
								_tmp12_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp11_, &iter);
								if (!_tmp12_) {
									break;
								}
							}
							_tmp9_ = FALSE;
							_tmp13_ = self->priv->device_model;
							_tmp14_ = iter;
							gtk_tree_model_get ((GtkTreeModel*) _tmp13_, &_tmp14_, 0, &name, -1, -1);
							_tmp15_ = name;
							_tmp16_ = device;
							_tmp17_ = _tmp16_->name;
							matched = g_strcmp0 (_tmp15_, _tmp17_) == 0;
							_tmp18_ = matched;
							if (_tmp18_) {
								gint _tmp19_;
								_tmp19_ = i;
								n_delete = _tmp19_;
								_g_free0 (name);
								break;
							}
							_tmp20_ = i;
							i = _tmp20_ + 1;
							_g_free0 (name);
						}
					}
				}
				_tmp21_ = n_delete;
				if (_tmp21_ >= 0) {
					gint i = 0;
					GtkListStore* _tmp22_;
					GtkTreeIter _tmp23_;
					ScanDevice* _tmp24_;
					const gchar* _tmp25_;
					_tmp22_ = self->priv->device_model;
					_tmp23_ = iter;
					_tmp24_ = device;
					_tmp25_ = _tmp24_->label;
					gtk_list_store_set (_tmp22_, &_tmp23_, 1, _tmp25_, -1, -1);
					{
						gboolean _tmp26_;
						i = 0;
						_tmp26_ = TRUE;
						while (TRUE) {
							gboolean _tmp27_;
							gint _tmp29_;
							gint _tmp30_;
							GtkListStore* _tmp31_;
							gint _tmp32_;
							GtkTreeIter _tmp33_ = {0};
							GtkListStore* _tmp34_;
							GtkTreeIter _tmp35_;
							_tmp27_ = _tmp26_;
							if (!_tmp27_) {
								gint _tmp28_;
								_tmp28_ = i;
								i = _tmp28_ + 1;
							}
							_tmp26_ = FALSE;
							_tmp29_ = i;
							_tmp30_ = n_delete;
							if (!(_tmp29_ < _tmp30_)) {
								break;
							}
							_tmp31_ = self->priv->device_model;
							_tmp32_ = index;
							gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp31_, &_tmp33_, NULL, _tmp32_);
							iter = _tmp33_;
							_tmp34_ = self->priv->device_model;
							_tmp35_ = iter;
							gtk_list_store_remove (_tmp34_, &_tmp35_);
						}
					}
				} else {
					GtkListStore* _tmp36_;
					gint _tmp37_;
					GtkTreeIter _tmp38_ = {0};
					GtkListStore* _tmp39_;
					GtkTreeIter _tmp40_;
					ScanDevice* _tmp41_;
					const gchar* _tmp42_;
					ScanDevice* _tmp43_;
					const gchar* _tmp44_;
					_tmp36_ = self->priv->device_model;
					_tmp37_ = index;
					gtk_list_store_insert (_tmp36_, &_tmp38_, _tmp37_);
					iter = _tmp38_;
					_tmp39_ = self->priv->device_model;
					_tmp40_ = iter;
					_tmp41_ = device;
					_tmp42_ = _tmp41_->name;
					_tmp43_ = device;
					_tmp44_ = _tmp43_->label;
					gtk_list_store_set (_tmp39_, &_tmp40_, 0, _tmp42_, 1, _tmp44_, -1, -1);
				}
				_tmp45_ = index;
				index = _tmp45_ + 1;
				_scan_device_unref0 (device);
			}
		}
	}
	while (TRUE) {
		GtkListStore* _tmp46_;
		gint _tmp47_;
		GtkTreeIter _tmp48_ = {0};
		gboolean _tmp49_ = FALSE;
		GtkListStore* _tmp50_;
		GtkTreeIter _tmp51_;
		_tmp46_ = self->priv->device_model;
		_tmp47_ = index;
		_tmp49_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp46_, &_tmp48_, NULL, _tmp47_);
		iter = _tmp48_;
		if (!_tmp49_) {
			break;
		}
		_tmp50_ = self->priv->device_model;
		_tmp51_ = iter;
		gtk_list_store_remove (_tmp50_, &_tmp51_);
	}
	_tmp53_ = have_selection;
	if (!_tmp53_) {
		GList* _tmp54_;
		_tmp54_ = devices;
		_tmp52_ = _tmp54_ != NULL;
	} else {
		_tmp52_ = FALSE;
	}
	_tmp55_ = _tmp52_;
	if (_tmp55_) {
		GtkComboBox* _tmp56_;
		_tmp56_ = self->priv->device_combo;
		gtk_combo_box_set_active (_tmp56_, 0);
	}
	self->priv->setting_devices = FALSE;
	simple_scan_update_info_bar (self);
}


static gchar* simple_scan_get_selected_device (SimpleScan* self) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->device_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		gchar* device = NULL;
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		_tmp3_ = self->priv->device_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &device, -1, -1);
		result = device;
		return result;
	}
	result = NULL;
	return result;
}


void simple_scan_set_selected_device (SimpleScan* self, const gchar* device) {
	GtkTreeIter iter = {0};
	const gchar* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_;
	GtkTreeIter _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = device;
	_tmp2_ = simple_scan_find_scan_device (self, _tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->device_combo;
	_tmp4_ = iter;
	gtk_combo_box_set_active_iter (_tmp3_, &_tmp4_);
	self->priv->user_selected_device = TRUE;
}


static void simple_scan_add_default_page (SimpleScan* self) {
	Book* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ScanDirection _tmp4_;
	Page* _tmp5_ = NULL;
	Page* page;
	BookView* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = self->priv->default_page_width;
	_tmp2_ = self->priv->default_page_height;
	_tmp3_ = self->priv->default_page_dpi;
	_tmp4_ = self->priv->default_page_scan_direction;
	_tmp5_ = book_append_page (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	page = _tmp5_;
	_tmp6_ = self->priv->book_view;
	book_view_select_page (_tmp6_, page);
	_page_unref0 (page);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void simple_scan_on_file_type_changed (SimpleScan* self, GtkTreeSelection* selection) {
	GtkTreeModel* model = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	GtkTreeModel* _tmp4_;
	gchar* extension = NULL;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GtkFileChooserDialog* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* path;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* filename;
	const gchar* _tmp11_;
	gint _tmp12_ = 0;
	gint extension_index;
	gint _tmp13_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	GtkFileChooserDialog* _tmp20_;
	const gchar* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	_tmp0_ = selection;
	_tmp3_ = gtk_tree_selection_get_selected (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (model);
	_tmp4_ = _g_object_ref0 (_tmp1_);
	model = _tmp4_;
	iter = _tmp2_;
	if (!_tmp3_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp5_ = model;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &extension, -1, -1);
	_tmp7_ = self->priv->save_dialog;
	_tmp8_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp7_);
	path = _tmp8_;
	_tmp9_ = path;
	_tmp10_ = g_path_get_basename (_tmp9_);
	filename = _tmp10_;
	_tmp11_ = filename;
	_tmp12_ = string_last_index_of_char (_tmp11_, (gunichar) '.', 0);
	extension_index = _tmp12_;
	_tmp13_ = extension_index;
	if (_tmp13_ >= 0) {
		const gchar* _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		_tmp14_ = filename;
		_tmp15_ = extension_index;
		_tmp16_ = string_slice (_tmp14_, (glong) 0, (glong) _tmp15_);
		_g_free0 (filename);
		filename = _tmp16_;
	}
	_tmp17_ = filename;
	_tmp18_ = extension;
	_tmp19_ = g_strconcat (_tmp17_, _tmp18_, NULL);
	_g_free0 (filename);
	filename = _tmp19_;
	_tmp20_ = self->priv->save_dialog;
	_tmp21_ = filename;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp20_, _tmp21_);
	_g_free0 (filename);
	_g_free0 (path);
	_g_free0 (extension);
	_g_object_unref0 (model);
}


static void _simple_scan_on_file_type_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	simple_scan_on_file_type_changed (self, _sender);
}


static gchar* simple_scan_choose_file_location (SimpleScan* self) {
	gchar* result = NULL;
	gchar* directory;
	GSettings* _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	const gchar* _tmp8_ = NULL;
	GtkWindow* _tmp9_;
	GtkFileChooserDialog* _tmp10_;
	GtkFileChooserDialog* _tmp11_;
	GtkFileChooserDialog* _tmp12_;
	GtkFileChooserDialog* _tmp13_;
	GtkFileChooserDialog* _tmp14_;
	const gchar* _tmp15_;
	GtkFileChooserDialog* _tmp16_;
	const gchar* _tmp17_;
	GtkFileFilter* _tmp18_;
	GtkFileFilter* _tmp19_;
	GtkFileFilter* filter;
	GtkFileFilter* _tmp20_;
	const gchar* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_;
	GtkFileFilter* _tmp23_;
	GtkFileChooserDialog* _tmp24_;
	GtkFileFilter* _tmp25_;
	GtkFileFilter* _tmp26_;
	GtkFileFilter* _tmp27_;
	GtkFileFilter* _tmp28_;
	const gchar* _tmp29_ = NULL;
	GtkFileFilter* _tmp30_;
	GtkFileChooserDialog* _tmp31_;
	GtkFileFilter* _tmp32_;
	const gchar* _tmp33_ = NULL;
	GtkExpander* _tmp34_;
	GtkExpander* _tmp35_;
	GtkExpander* expander;
	GtkExpander* _tmp36_;
	GtkFileChooserDialog* _tmp37_;
	GtkExpander* _tmp38_;
	gchar* _tmp39_;
	gchar* extension;
	const gchar* _tmp40_;
	gint _tmp41_ = 0;
	gint index;
	gint _tmp42_;
	GtkListStore* _tmp46_;
	GtkListStore* file_type_store;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp47_;
	GtkTreeIter _tmp48_ = {0};
	GtkListStore* _tmp49_;
	GtkTreeIter _tmp50_;
	const gchar* _tmp51_ = NULL;
	GtkListStore* _tmp52_;
	GtkTreeIter _tmp53_ = {0};
	GtkListStore* _tmp54_;
	GtkTreeIter _tmp55_;
	const gchar* _tmp56_ = NULL;
	GtkListStore* _tmp57_;
	GtkTreeIter _tmp58_ = {0};
	GtkListStore* _tmp59_;
	GtkTreeIter _tmp60_;
	const gchar* _tmp61_ = NULL;
	GtkListStore* _tmp62_;
	GtkTreeView* _tmp63_;
	GtkTreeView* _tmp64_;
	GtkTreeView* file_type_view;
	GtkTreeView* _tmp65_;
	GtkTreeView* _tmp66_;
	GtkCellRendererText* _tmp67_;
	GtkCellRendererText* _tmp68_;
	GtkTreeViewColumn* _tmp69_;
	GtkTreeViewColumn* _tmp70_;
	GtkTreeViewColumn* _tmp71_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp72_;
	GtkTreeViewColumn* _tmp73_;
	GtkExpander* _tmp74_;
	GtkTreeView* _tmp75_;
	GtkListStore* _tmp76_;
	GtkTreeIter _tmp77_ = {0};
	gboolean _tmp78_ = FALSE;
	GtkTreeView* _tmp90_;
	GtkTreeSelection* _tmp91_ = NULL;
	GtkExpander* _tmp92_;
	GtkFileChooserDialog* _tmp93_;
	gint _tmp94_ = 0;
	gint response;
	gchar* uri;
	gint _tmp95_;
	GSettings* _tmp98_;
	GtkFileChooserDialog* _tmp99_;
	gchar* _tmp100_ = NULL;
	gchar* _tmp101_;
	GtkFileChooserDialog* _tmp102_;
	g_return_val_if_fail (self != NULL, NULL);
	directory = NULL;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "save-directory");
	_g_free0 (directory);
	directory = _tmp1_;
	_tmp3_ = directory;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = directory;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp6_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (directory);
		directory = _tmp7_;
	}
	_tmp8_ = _ ("Save As...");
	_tmp9_ = self->priv->window;
	_tmp10_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp8_, _tmp9_, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	_tmp11_ = g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = _tmp11_;
	_tmp12_ = self->priv->save_dialog;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp12_, TRUE);
	_tmp13_ = self->priv->save_dialog;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp13_, FALSE);
	_tmp14_ = self->priv->save_dialog;
	_tmp15_ = directory;
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp14_, _tmp15_);
	_tmp16_ = self->priv->save_dialog;
	_tmp17_ = self->priv->default_file_name;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp16_, _tmp17_);
	_tmp18_ = gtk_file_filter_new ();
	_tmp19_ = g_object_ref_sink (_tmp18_);
	filter = _tmp19_;
	_tmp20_ = filter;
	_tmp21_ = _ ("Image Files");
	gtk_file_filter_set_name (_tmp20_, _tmp21_);
	_tmp22_ = filter;
	gtk_file_filter_add_pixbuf_formats (_tmp22_);
	_tmp23_ = filter;
	gtk_file_filter_add_mime_type (_tmp23_, "application/pdf");
	_tmp24_ = self->priv->save_dialog;
	_tmp25_ = filter;
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp24_, _tmp25_);
	_tmp26_ = gtk_file_filter_new ();
	_tmp27_ = g_object_ref_sink (_tmp26_);
	_g_object_unref0 (filter);
	filter = _tmp27_;
	_tmp28_ = filter;
	_tmp29_ = _ ("All Files");
	gtk_file_filter_set_name (_tmp28_, _tmp29_);
	_tmp30_ = filter;
	gtk_file_filter_add_pattern (_tmp30_, "*");
	_tmp31_ = self->priv->save_dialog;
	_tmp32_ = filter;
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp31_, _tmp32_);
	_tmp33_ = _ ("Select File _Type");
	_tmp34_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_tmp33_);
	_tmp35_ = g_object_ref_sink (_tmp34_);
	expander = _tmp35_;
	_tmp36_ = expander;
	gtk_expander_set_spacing (_tmp36_, 5);
	_tmp37_ = self->priv->save_dialog;
	_tmp38_ = expander;
	gtk_file_chooser_set_extra_widget ((GtkFileChooser*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = g_strdup ("");
	extension = _tmp39_;
	_tmp40_ = self->priv->default_file_name;
	_tmp41_ = string_last_index_of_char (_tmp40_, (gunichar) '.', 0);
	index = _tmp41_;
	_tmp42_ = index;
	if (_tmp42_ >= 0) {
		const gchar* _tmp43_;
		gint _tmp44_;
		gchar* _tmp45_ = NULL;
		_tmp43_ = self->priv->default_file_name;
		_tmp44_ = index;
		_tmp45_ = string_slice (_tmp43_, (glong) 0, (glong) _tmp44_);
		_g_free0 (extension);
		extension = _tmp45_;
	}
	_tmp46_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	file_type_store = _tmp46_;
	_tmp47_ = file_type_store;
	gtk_list_store_append (_tmp47_, &_tmp48_);
	iter = _tmp48_;
	_tmp49_ = file_type_store;
	_tmp50_ = iter;
	_tmp51_ = _ ("PDF (multi-page document)");
	gtk_list_store_set (_tmp49_, &_tmp50_, 0, _tmp51_, 1, ".pdf", -1, -1);
	_tmp52_ = file_type_store;
	gtk_list_store_append (_tmp52_, &_tmp53_);
	iter = _tmp53_;
	_tmp54_ = file_type_store;
	_tmp55_ = iter;
	_tmp56_ = _ ("JPEG (compressed)");
	gtk_list_store_set (_tmp54_, &_tmp55_, 0, _tmp56_, 1, ".jpg", -1, -1);
	_tmp57_ = file_type_store;
	gtk_list_store_append (_tmp57_, &_tmp58_);
	iter = _tmp58_;
	_tmp59_ = file_type_store;
	_tmp60_ = iter;
	_tmp61_ = _ ("PNG (lossless)");
	gtk_list_store_set (_tmp59_, &_tmp60_, 0, _tmp61_, 1, ".png", -1, -1);
	_tmp62_ = file_type_store;
	_tmp63_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp62_);
	_tmp64_ = g_object_ref_sink (_tmp63_);
	file_type_view = _tmp64_;
	_tmp65_ = file_type_view;
	gtk_tree_view_set_headers_visible (_tmp65_, FALSE);
	_tmp66_ = file_type_view;
	gtk_tree_view_set_rules_hint (_tmp66_, TRUE);
	_tmp67_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp68_ = g_object_ref_sink (_tmp67_);
	_tmp69_ = gtk_tree_view_column_new_with_attributes ("", (GtkCellRenderer*) _tmp68_, "text", 0, NULL, NULL);
	_tmp70_ = g_object_ref_sink (_tmp69_);
	_tmp71_ = _tmp70_;
	_g_object_unref0 (_tmp68_);
	column = _tmp71_;
	_tmp72_ = file_type_view;
	_tmp73_ = column;
	gtk_tree_view_append_column (_tmp72_, _tmp73_);
	_tmp74_ = expander;
	_tmp75_ = file_type_view;
	gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = file_type_store;
	_tmp78_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp76_, &_tmp77_);
	iter = _tmp77_;
	if (_tmp78_) {
		{
			gboolean _tmp79_;
			_tmp79_ = TRUE;
			while (TRUE) {
				gboolean _tmp80_;
				gchar* e = NULL;
				GtkListStore* _tmp83_;
				GtkTreeIter _tmp84_;
				const gchar* _tmp85_;
				const gchar* _tmp86_;
				_tmp80_ = _tmp79_;
				if (!_tmp80_) {
					GtkListStore* _tmp81_;
					gboolean _tmp82_ = FALSE;
					_tmp81_ = file_type_store;
					_tmp82_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp81_, &iter);
					if (!_tmp82_) {
						break;
					}
				}
				_tmp79_ = FALSE;
				_tmp83_ = file_type_store;
				_tmp84_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp83_, &_tmp84_, 1, &e, -1, -1);
				_tmp85_ = extension;
				_tmp86_ = e;
				if (g_strcmp0 (_tmp85_, _tmp86_) == 0) {
					GtkTreeView* _tmp87_;
					GtkTreeSelection* _tmp88_ = NULL;
					GtkTreeIter _tmp89_;
					_tmp87_ = file_type_view;
					_tmp88_ = gtk_tree_view_get_selection (_tmp87_);
					_tmp89_ = iter;
					gtk_tree_selection_select_iter (_tmp88_, &_tmp89_);
				}
				_g_free0 (e);
			}
		}
	}
	_tmp90_ = file_type_view;
	_tmp91_ = gtk_tree_view_get_selection (_tmp90_);
	g_signal_connect (_tmp91_, "changed", (GCallback) _simple_scan_on_file_type_changed_gtk_tree_selection_changed, self);
	_tmp92_ = expander;
	gtk_widget_show_all ((GtkWidget*) _tmp92_);
	_tmp93_ = self->priv->save_dialog;
	_tmp94_ = gtk_dialog_run ((GtkDialog*) _tmp93_);
	response = _tmp94_;
	uri = NULL;
	_tmp95_ = response;
	if (_tmp95_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp96_;
		gchar* _tmp97_ = NULL;
		_tmp96_ = self->priv->save_dialog;
		_tmp97_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp96_);
		_g_free0 (uri);
		uri = _tmp97_;
	}
	_tmp98_ = self->priv->settings;
	_tmp99_ = self->priv->save_dialog;
	_tmp100_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp99_);
	_tmp101_ = _tmp100_;
	g_settings_set_string (_tmp98_, "save-directory", _tmp101_);
	_g_free0 (_tmp101_);
	_tmp102_ = self->priv->save_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp102_);
	_g_object_unref0 (self->priv->save_dialog);
	self->priv->save_dialog = NULL;
	result = uri;
	_g_object_unref0 (column);
	_g_object_unref0 (file_type_view);
	_g_object_unref0 (file_type_store);
	_g_free0 (extension);
	_g_object_unref0 (expander);
	_g_object_unref0 (filter);
	_g_free0 (directory);
	return result;
}


static gboolean simple_scan_save_document (SimpleScan* self, gboolean force_choose_location) {
	gboolean result = FALSE;
	gchar* uri = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_ = NULL;
	GFile* file;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* uri_lower;
	gchar* _tmp13_;
	gchar* format;
	const gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	Book* _tmp40_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->book_uri;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_;
		_tmp2_ = force_choose_location;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->book_uri;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (uri);
		uri = _tmp5_;
	} else {
		gchar* _tmp6_ = NULL;
		_tmp6_ = simple_scan_choose_file_location (self);
		_g_free0 (uri);
		uri = _tmp6_;
	}
	_tmp7_ = uri;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_g_free0 (uri);
		return result;
	}
	_tmp8_ = uri;
	_tmp9_ = g_file_new_for_uri (_tmp8_);
	file = _tmp9_;
	_tmp10_ = uri;
	g_debug ("ui.vala:445: Saving to '%s'", _tmp10_);
	_tmp11_ = uri;
	_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) (-1));
	uri_lower = _tmp12_;
	_tmp13_ = g_strdup ("jpeg");
	format = _tmp13_;
	_tmp14_ = uri_lower;
	_tmp15_ = g_str_has_suffix (_tmp14_, ".pdf");
	if (_tmp15_) {
		gchar* _tmp16_;
		_tmp16_ = g_strdup ("pdf");
		_g_free0 (format);
		format = _tmp16_;
	} else {
		const gchar* _tmp17_;
		gboolean _tmp18_ = FALSE;
		_tmp17_ = uri_lower;
		_tmp18_ = g_str_has_suffix (_tmp17_, ".ps");
		if (_tmp18_) {
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("ps");
			_g_free0 (format);
			format = _tmp19_;
		} else {
			const gchar* _tmp20_;
			gboolean _tmp21_ = FALSE;
			_tmp20_ = uri_lower;
			_tmp21_ = g_str_has_suffix (_tmp20_, ".png");
			if (_tmp21_) {
				gchar* _tmp22_;
				_tmp22_ = g_strdup ("png");
				_g_free0 (format);
				format = _tmp22_;
			} else {
				gboolean _tmp23_ = FALSE;
				const gchar* _tmp24_;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp28_;
				_tmp24_ = uri_lower;
				_tmp25_ = g_str_has_suffix (_tmp24_, ".tif");
				if (_tmp25_) {
					_tmp23_ = TRUE;
				} else {
					const gchar* _tmp26_;
					gboolean _tmp27_ = FALSE;
					_tmp26_ = uri_lower;
					_tmp27_ = g_str_has_suffix (_tmp26_, ".tiff");
					_tmp23_ = _tmp27_;
				}
				_tmp28_ = _tmp23_;
				if (_tmp28_) {
					gchar* _tmp29_;
					_tmp29_ = g_strdup ("tiff");
					_g_free0 (format);
					format = _tmp29_;
				}
			}
		}
	}
	{
		Book* _tmp30_;
		const gchar* _tmp31_;
		GFile* _tmp32_;
		_tmp30_ = self->priv->book;
		_tmp31_ = format;
		_tmp32_ = file;
		book_save (_tmp30_, _tmp31_, _tmp32_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_ = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_warning ("ui.vala:464: Error saving file: %s", _tmp34_);
		_tmp35_ = _ ("Failed to save file");
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		simple_scan_show_error (self, _tmp35_, _tmp37_, FALSE);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (format);
		_g_free0 (uri_lower);
		_g_object_unref0 (file);
		_g_free0 (uri);
		return result;
	}
	__finally15:
	if (_inner_error_ != NULL) {
		_g_free0 (format);
		_g_free0 (uri_lower);
		_g_object_unref0 (file);
		_g_free0 (uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp38_ = uri;
	_tmp39_ = g_strdup (_tmp38_);
	_g_free0 (self->priv->book_uri);
	self->priv->book_uri = _tmp39_;
	_tmp40_ = self->priv->book;
	book_set_needs_saving (_tmp40_, FALSE);
	result = TRUE;
	_g_free0 (format);
	_g_free0 (uri_lower);
	_g_object_unref0 (file);
	_g_free0 (uri);
	return result;
}


static gboolean simple_scan_prompt_to_save (SimpleScan* self, const gchar* title, const gchar* discard_label) {
	gboolean result = FALSE;
	Book* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkWindow* _tmp2_;
	const gchar* _tmp3_;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* _tmp5_;
	GtkMessageDialog* dialog;
	GtkMessageDialog* _tmp6_;
	const gchar* _tmp7_ = NULL;
	GtkMessageDialog* _tmp8_;
	const gchar* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkMessageDialog* _tmp11_;
	GtkMessageDialog* _tmp12_;
	gint _tmp13_ = 0;
	gint response;
	GtkMessageDialog* _tmp14_;
	gint _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (title != NULL, FALSE);
	g_return_val_if_fail (discard_label != NULL, FALSE);
	_tmp0_ = self->priv->book;
	_tmp1_ = book_get_needs_saving (_tmp0_);
	if (!_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->window;
	_tmp3_ = title;
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp2_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "%s", _tmp3_);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	dialog = _tmp5_;
	_tmp6_ = dialog;
	_tmp7_ = _ ("If you don't save, changes will be permanently lost.");
	gtk_message_dialog_format_secondary_text (_tmp6_, "%s", _tmp7_);
	_tmp8_ = dialog;
	_tmp9_ = discard_label;
	gtk_dialog_add_button ((GtkDialog*) _tmp8_, _tmp9_, (gint) GTK_RESPONSE_NO);
	_tmp10_ = dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp10_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp11_ = dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp11_, GTK_STOCK_SAVE, (gint) GTK_RESPONSE_YES);
	_tmp12_ = dialog;
	_tmp13_ = gtk_dialog_run ((GtkDialog*) _tmp12_);
	response = _tmp13_;
	_tmp14_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp14_);
	_tmp15_ = response;
	switch (_tmp15_) {
		case GTK_RESPONSE_YES:
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = simple_scan_save_document (self, FALSE);
			if (_tmp16_) {
				result = TRUE;
				_g_object_unref0 (dialog);
				return result;
			} else {
				result = FALSE;
				_g_object_unref0 (dialog);
				return result;
			}
		}
		case GTK_RESPONSE_CANCEL:
		{
			result = FALSE;
			_g_object_unref0 (dialog);
			return result;
		}
		default:
		case GTK_RESPONSE_NO:
		{
			result = TRUE;
			_g_object_unref0 (dialog);
			return result;
		}
	}
	_g_object_unref0 (dialog);
}


static void simple_scan_clear_document (SimpleScan* self) {
	Book* _tmp0_;
	Book* _tmp1_;
	GtkMenuItem* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book;
	book_clear (_tmp0_);
	simple_scan_add_default_page (self);
	_g_free0 (self->priv->book_uri);
	self->priv->book_uri = NULL;
	_tmp1_ = self->priv->book;
	book_set_needs_saving (_tmp1_, FALSE);
	_tmp2_ = self->priv->save_as_menuitem;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
}


void G_MODULE_EXPORT new_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = _ ("Save current document?");
	_tmp1_ = _ ("Discard Changes");
	_tmp2_ = simple_scan_prompt_to_save (self, _tmp0_, _tmp1_);
	if (!_tmp2_) {
		return;
	}
	simple_scan_clear_document (self);
}


static void simple_scan_set_document_hint (SimpleScan* self, const gchar* document_hint) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (document_hint != NULL);
	_tmp0_ = document_hint;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->document_hint);
	self->priv->document_hint = _tmp1_;
	_tmp2_ = document_hint;
	if (g_strcmp0 (_tmp2_, "text") == 0) {
		GtkRadioMenuItem* _tmp3_;
		GtkRadioMenuItem* _tmp4_;
		_tmp3_ = self->priv->text_toolbar_menuitem;
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp3_, TRUE);
		_tmp4_ = self->priv->text_menu_menuitem;
		gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp4_, TRUE);
	} else {
		const gchar* _tmp5_;
		_tmp5_ = document_hint;
		if (g_strcmp0 (_tmp5_, "photo") == 0) {
			GtkRadioMenuItem* _tmp6_;
			GtkRadioMenuItem* _tmp7_;
			_tmp6_ = self->priv->photo_toolbar_menuitem;
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp6_, TRUE);
			_tmp7_ = self->priv->photo_menu_menuitem;
			gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp7_, TRUE);
		}
	}
}


void G_MODULE_EXPORT text_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		simple_scan_set_document_hint (self, "text");
	}
}


void G_MODULE_EXPORT photo_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		simple_scan_set_document_hint (self, "photo");
	}
}


static void simple_scan_set_page_side (SimpleScan* self, ScanType page_side) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->page_side_model;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint s = 0;
				GtkListStore* _tmp7_;
				GtkTreeIter _tmp8_;
				gint _tmp9_;
				ScanType _tmp10_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					GtkListStore* _tmp5_;
					gboolean _tmp6_ = FALSE;
					_tmp5_ = self->priv->page_side_model;
					_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
					if (!_tmp6_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp7_ = self->priv->page_side_model;
				_tmp8_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 0, &s, -1, -1);
				_tmp9_ = s;
				_tmp10_ = page_side;
				if (_tmp9_ == ((gint) _tmp10_)) {
					GtkComboBox* _tmp11_;
					GtkTreeIter _tmp12_;
					_tmp11_ = self->priv->page_side_combo;
					_tmp12_ = iter;
					gtk_combo_box_set_active_iter (_tmp11_, &_tmp12_);
					return;
				}
			}
		}
	}
}


static void simple_scan_set_paper_size (SimpleScan* self, gint width, gint height) {
	GtkTreeIter iter = {0};
	gboolean have_iter = FALSE;
	gboolean _tmp16_;
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	{
		GtkListStore* _tmp0_;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp0_ = self->priv->paper_size_model;
		_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
		iter = _tmp1_;
		have_iter = _tmp2_;
		_tmp3_ = TRUE;
		while (TRUE) {
			gboolean _tmp4_;
			gboolean _tmp7_;
			gint w = 0;
			gint h = 0;
			GtkListStore* _tmp8_;
			GtkTreeIter _tmp9_;
			gboolean _tmp10_ = FALSE;
			gint _tmp11_;
			gint _tmp12_;
			gboolean _tmp15_;
			_tmp4_ = _tmp3_;
			if (!_tmp4_) {
				GtkListStore* _tmp5_;
				gboolean _tmp6_ = FALSE;
				_tmp5_ = self->priv->paper_size_model;
				_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
				have_iter = _tmp6_;
			}
			_tmp3_ = FALSE;
			_tmp7_ = have_iter;
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = self->priv->paper_size_model;
			_tmp9_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp8_, &_tmp9_, 0, &w, 1, &h, -1, -1);
			_tmp11_ = w;
			_tmp12_ = width;
			if (_tmp11_ == _tmp12_) {
				gint _tmp13_;
				gint _tmp14_;
				_tmp13_ = h;
				_tmp14_ = height;
				_tmp10_ = _tmp13_ == _tmp14_;
			} else {
				_tmp10_ = FALSE;
			}
			_tmp15_ = _tmp10_;
			if (_tmp15_) {
				break;
			}
		}
	}
	_tmp16_ = have_iter;
	if (!_tmp16_) {
		GtkListStore* _tmp17_;
		GtkTreeIter _tmp18_ = {0};
		gboolean _tmp19_ = FALSE;
		_tmp17_ = self->priv->paper_size_model;
		_tmp19_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp17_, &_tmp18_);
		iter = _tmp18_;
		have_iter = _tmp19_;
	}
	_tmp20_ = have_iter;
	if (_tmp20_) {
		GtkComboBox* _tmp21_;
		GtkTreeIter _tmp22_;
		_tmp21_ = self->priv->paper_size_combo;
		_tmp22_ = iter;
		gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
	}
}


static gint simple_scan_get_text_dpi (SimpleScan* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	dpi = SIMPLE_SCAN_DEFAULT_TEXT_DPI;
	_tmp0_ = self->priv->text_dpi_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		_tmp3_ = self->priv->text_dpi_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
	}
	result = dpi;
	return result;
}


static gint simple_scan_get_photo_dpi (SimpleScan* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	gint dpi;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	dpi = SIMPLE_SCAN_DEFAULT_PHOTO_DPI;
	_tmp0_ = self->priv->photo_dpi_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		_tmp3_ = self->priv->photo_dpi_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &dpi, -1, -1);
	}
	result = dpi;
	return result;
}


static ScanType simple_scan_get_page_side (SimpleScan* self) {
	ScanType result = 0;
	GtkTreeIter iter = {0};
	gint page_side;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	page_side = (gint) SCAN_TYPE_ADF_BOTH;
	_tmp0_ = self->priv->page_side_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkListStore* _tmp3_;
		GtkTreeIter _tmp4_;
		_tmp3_ = self->priv->page_side_model;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, 0, &page_side, -1, -1);
	}
	_tmp5_ = page_side;
	result = (ScanType) _tmp5_;
	return result;
}


static gboolean simple_scan_get_paper_size (SimpleScan* self, gint* width, gint* height) {
	gint _vala_width = 0;
	gint _vala_height = 0;
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	gint _tmp0_;
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_height = 0;
	_tmp0_ = _vala_height;
	_vala_width = _tmp0_;
	_tmp1_ = self->priv->paper_size_combo;
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->paper_size_model;
		_tmp5_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 0, &_vala_width, 1, &_vala_height, -1, -1);
		result = TRUE;
		if (width) {
			*width = _vala_width;
		}
		if (height) {
			*height = _vala_height;
		}
		return result;
	}
	result = FALSE;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}


static ScanOptions* simple_scan_get_scan_options (SimpleScan* self) {
	ScanOptions* result = NULL;
	ScanOptions* _tmp0_;
	ScanOptions* options;
	const gchar* _tmp1_;
	ScanOptions* _tmp10_;
	ScanOptions* _tmp11_;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = scan_options_new ();
	options = _tmp0_;
	_tmp1_ = self->priv->document_hint;
	if (g_strcmp0 (_tmp1_, "text") == 0) {
		ScanOptions* _tmp2_;
		ScanOptions* _tmp3_;
		gint _tmp4_ = 0;
		ScanOptions* _tmp5_;
		_tmp2_ = options;
		_tmp2_->scan_mode = SCAN_MODE_GRAY;
		_tmp3_ = options;
		_tmp4_ = simple_scan_get_text_dpi (self);
		_tmp3_->dpi = _tmp4_;
		_tmp5_ = options;
		_tmp5_->depth = 2;
	} else {
		ScanOptions* _tmp6_;
		ScanOptions* _tmp7_;
		gint _tmp8_ = 0;
		ScanOptions* _tmp9_;
		_tmp6_ = options;
		_tmp6_->scan_mode = SCAN_MODE_COLOR;
		_tmp7_ = options;
		_tmp8_ = simple_scan_get_photo_dpi (self);
		_tmp7_->dpi = _tmp8_;
		_tmp9_ = options;
		_tmp9_->depth = 8;
	}
	_tmp10_ = options;
	_tmp11_ = options;
	simple_scan_get_paper_size (self, &_tmp12_, &_tmp13_);
	_tmp10_->paper_width = _tmp12_;
	_tmp11_->paper_height = _tmp13_;
	result = options;
	return result;
}


void G_MODULE_EXPORT scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	ScanOptions* _tmp0_ = NULL;
	ScanOptions* options;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = simple_scan_get_scan_options (self);
	options = _tmp0_;
	options->type = SCAN_TYPE_SINGLE;
	_tmp1_ = simple_scan_get_selected_device (self);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name (self, "start-scan", _tmp2_, options);
	_g_free0 (_tmp2_);
	_scan_options_unref0 (options);
}


void G_MODULE_EXPORT stop_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_signal_emit_by_name (self, "stop-scan");
}


void G_MODULE_EXPORT continuous_scan_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scanning;
	if (_tmp0_) {
		g_signal_emit_by_name (self, "stop-scan");
	} else {
		ScanOptions* _tmp1_ = NULL;
		ScanOptions* options;
		ScanOptions* _tmp2_;
		ScanType _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		ScanOptions* _tmp6_;
		_tmp1_ = simple_scan_get_scan_options (self);
		options = _tmp1_;
		_tmp2_ = options;
		_tmp3_ = simple_scan_get_page_side (self);
		_tmp2_->type = _tmp3_;
		_tmp4_ = simple_scan_get_selected_device (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = options;
		g_signal_emit_by_name (self, "start-scan", _tmp5_, _tmp6_);
		_g_free0 (_tmp5_);
		_scan_options_unref0 (options);
	}
}


void G_MODULE_EXPORT preferences_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


gboolean G_MODULE_EXPORT preferences_dialog_delete_event_cb (GtkWidget* widget, SimpleScan* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	result = TRUE;
	return result;
}


void G_MODULE_EXPORT preferences_dialog_response_cb (GtkWidget* widget, gint response_id, SimpleScan* self) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static void simple_scan_update_page_menu (SimpleScan* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Page* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ == NULL) {
		GtkMenuItem* _tmp3_;
		GtkMenuItem* _tmp4_;
		_tmp3_ = self->priv->page_move_left_menuitem;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = self->priv->page_move_right_menuitem;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
	} else {
		Book* _tmp5_;
		Page* _tmp6_;
		guint _tmp7_ = 0U;
		guint index;
		GtkMenuItem* _tmp8_;
		guint _tmp9_;
		GtkMenuItem* _tmp10_;
		guint _tmp11_;
		Book* _tmp12_;
		guint _tmp13_ = 0U;
		_tmp5_ = self->priv->book;
		_tmp6_ = page;
		_tmp7_ = book_get_page_index (_tmp5_, _tmp6_);
		index = _tmp7_;
		_tmp8_ = self->priv->page_move_left_menuitem;
		_tmp9_ = index;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp9_ > ((guint) 0));
		_tmp10_ = self->priv->page_move_right_menuitem;
		_tmp11_ = index;
		_tmp12_ = self->priv->book;
		_tmp13_ = book_get_n_pages (_tmp12_);
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, _tmp11_ < (_tmp13_ - 1));
	}
	_page_unref0 (page);
}


static void simple_scan_page_selected_cb (SimpleScan* self, BookView* view, Page* page) {
	Page* _tmp0_;
	gchar* name;
	Page* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkBuilder* _tmp20_;
	const gchar* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkRadioMenuItem* _tmp23_;
	GtkRadioMenuItem* menuitem;
	GtkRadioMenuItem* _tmp24_;
	GtkBuilder* _tmp25_;
	GObject* _tmp26_ = NULL;
	GtkToggleToolButton* _tmp27_;
	GtkToggleToolButton* toolbutton;
	GtkToggleToolButton* _tmp28_;
	Page* _tmp29_;
	gboolean _tmp30_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = page;
	if (_tmp0_ == NULL) {
		return;
	}
	self->priv->updating_page_menu = TRUE;
	simple_scan_update_page_menu (self);
	name = NULL;
	_tmp1_ = page;
	_tmp2_ = page_has_crop (_tmp1_);
	if (_tmp2_) {
		Page* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* crop_name;
		const gchar* _tmp5_;
		_tmp3_ = page;
		_tmp4_ = page_get_named_crop (_tmp3_);
		crop_name = _tmp4_;
		_tmp5_ = crop_name;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			_tmp6_ = crop_name;
			if (g_strcmp0 (_tmp6_, "A4") == 0) {
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("a4_menuitem");
				_g_free0 (name);
				name = _tmp7_;
			} else {
				const gchar* _tmp8_;
				_tmp8_ = crop_name;
				if (g_strcmp0 (_tmp8_, "A5") == 0) {
					gchar* _tmp9_;
					_tmp9_ = g_strdup ("a5_menuitem");
					_g_free0 (name);
					name = _tmp9_;
				} else {
					const gchar* _tmp10_;
					_tmp10_ = crop_name;
					if (g_strcmp0 (_tmp10_, "A6") == 0) {
						gchar* _tmp11_;
						_tmp11_ = g_strdup ("a6_menuitem");
						_g_free0 (name);
						name = _tmp11_;
					} else {
						const gchar* _tmp12_;
						_tmp12_ = crop_name;
						if (g_strcmp0 (_tmp12_, "letter") == 0) {
							gchar* _tmp13_;
							_tmp13_ = g_strdup ("letter_menuitem");
							_g_free0 (name);
							name = _tmp13_;
						} else {
							const gchar* _tmp14_;
							_tmp14_ = crop_name;
							if (g_strcmp0 (_tmp14_, "legal") == 0) {
								gchar* _tmp15_;
								_tmp15_ = g_strdup ("legal_menuitem");
								_g_free0 (name);
								name = _tmp15_;
							} else {
								const gchar* _tmp16_;
								_tmp16_ = crop_name;
								if (g_strcmp0 (_tmp16_, "4x6") == 0) {
									gchar* _tmp17_;
									_tmp17_ = g_strdup ("4x6_menuitem");
									_g_free0 (name);
									name = _tmp17_;
								}
							}
						}
					}
				}
			}
		} else {
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("custom_crop_menuitem");
			_g_free0 (name);
			name = _tmp18_;
		}
		_g_free0 (crop_name);
	} else {
		gchar* _tmp19_;
		_tmp19_ = g_strdup ("no_crop_menuitem");
		_g_free0 (name);
		name = _tmp19_;
	}
	_tmp20_ = self->priv->builder;
	_tmp21_ = name;
	_tmp22_ = gtk_builder_get_object (_tmp20_, _tmp21_);
	_tmp23_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp22_));
	menuitem = _tmp23_;
	_tmp24_ = menuitem;
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp24_, TRUE);
	_tmp25_ = self->priv->builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "crop_toolbutton");
	_tmp27_ = _g_object_ref0 (GTK_TOGGLE_TOOL_BUTTON (_tmp26_));
	toolbutton = _tmp27_;
	_tmp28_ = toolbutton;
	_tmp29_ = page;
	_tmp30_ = page_has_crop (_tmp29_);
	gtk_toggle_tool_button_set_active (_tmp28_, _tmp30_);
	self->priv->updating_page_menu = FALSE;
	_g_object_unref0 (toolbutton);
	_g_object_unref0 (menuitem);
	_g_free0 (name);
}


static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* filename;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = prefix;
	_tmp1_ = extension;
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
	filename = _tmp2_;
	{
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint fd;
		gint _tmp6_;
		_tmp3_ = filename;
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
		_g_free0 (path);
		path = _tmp4_;
		fd = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_tmp6_ = fd;
		close (_tmp6_);
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("ui.vala:789: Error saving email attachment: %s", _tmp8_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (path);
		_g_free0 (filename);
		return result;
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = path;
	_g_free0 (filename);
	return result;
}


static void simple_scan_show_page_cb (SimpleScan* self, BookView* view, Page* page) {
	gchar* _tmp0_ = NULL;
	gchar* path;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = simple_scan_get_temporary_filename (self, "scanned-page", "tiff");
	path = _tmp0_;
	_tmp1_ = path;
	if (_tmp1_ == NULL) {
		_g_free0 (path);
		return;
	}
	_tmp2_ = path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	{
		Page* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = page;
		_tmp5_ = file;
		page_save (_tmp4_, "tiff", _tmp5_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _ ("Unable to save image for preview");
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		simple_scan_show_error_dialog (self, _tmp6_, _tmp8_);
		_g_error_free0 (e);
		_g_object_unref0 (file);
		_g_free0 (path);
		return;
	}
	__finally17:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		GtkWindow* _tmp9_;
		GdkScreen* _tmp10_ = NULL;
		GFile* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		guint32 _tmp14_ = 0U;
		_tmp9_ = self->priv->window;
		_tmp10_ = gtk_window_get_screen (_tmp9_);
		_tmp11_ = file;
		_tmp12_ = g_file_get_uri (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp10_, _tmp13_, _tmp14_, &_inner_error_);
		_g_free0 (_tmp13_);
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_ = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = _ ("Unable to open image preview application");
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		simple_scan_show_error_dialog (self, _tmp15_, _tmp17_);
		_g_error_free0 (e);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (path);
}


static void simple_scan_show_page_menu_cb (SimpleScan* self, BookView* view) {
	GtkBuilder* _tmp0_;
	GObject* _tmp1_ = NULL;
	GtkMenu* _tmp2_;
	GtkMenu* menu;
	guint32 _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = self->priv->builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "page_menu");
	_tmp2_ = _g_object_ref0 (GTK_MENU (_tmp1_));
	menu = _tmp2_;
	_tmp3_ = gtk_get_current_event_time ();
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, (guint) 3, _tmp3_);
	_g_object_unref0 (menu);
}


void G_MODULE_EXPORT rotate_left_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	gboolean _tmp0_;
	BookView* _tmp1_;
	Page* _tmp2_ = NULL;
	Page* page;
	Page* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->updating_page_menu;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->book_view;
	_tmp2_ = book_view_get_selected (_tmp1_);
	page = _tmp2_;
	_tmp3_ = page;
	if (_tmp3_ != NULL) {
		Page* _tmp4_;
		_tmp4_ = page;
		page_rotate_left (_tmp4_);
	}
	_page_unref0 (page);
}


void G_MODULE_EXPORT rotate_right_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	gboolean _tmp0_;
	BookView* _tmp1_;
	Page* _tmp2_ = NULL;
	Page* page;
	Page* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->updating_page_menu;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->book_view;
	_tmp2_ = book_view_get_selected (_tmp1_);
	page = _tmp2_;
	_tmp3_ = page;
	if (_tmp3_ != NULL) {
		Page* _tmp4_;
		_tmp4_ = page;
		page_rotate_right (_tmp4_);
	}
	_page_unref0 (page);
}


static void simple_scan_set_crop (SimpleScan* self, const gchar* crop_name) {
	GtkMenuItem* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	BookView* _tmp3_;
	Page* _tmp4_ = NULL;
	Page* page;
	Page* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->crop_rotate_menuitem;
	_tmp1_ = crop_name;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp1_ != NULL);
	_tmp2_ = self->priv->updating_page_menu;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->book_view;
	_tmp4_ = book_view_get_selected (_tmp3_);
	page = _tmp4_;
	_tmp5_ = page;
	if (_tmp5_ == NULL) {
		_page_unref0 (page);
		return;
	}
	_tmp6_ = crop_name;
	if (_tmp6_ == NULL) {
		Page* _tmp7_;
		_tmp7_ = page;
		page_set_no_crop (_tmp7_);
		_page_unref0 (page);
		return;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = crop_name;
		if (g_strcmp0 (_tmp8_, "custom") == 0) {
			Page* _tmp9_;
			gint _tmp10_ = 0;
			gint width;
			Page* _tmp11_;
			gint _tmp12_ = 0;
			gint height;
			gint _tmp13_;
			gint crop_width;
			gint _tmp14_;
			gint crop_height;
			Page* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			Page* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			_tmp9_ = page;
			_tmp10_ = page_get_width (_tmp9_);
			width = _tmp10_;
			_tmp11_ = page;
			_tmp12_ = page_get_height (_tmp11_);
			height = _tmp12_;
			_tmp13_ = width;
			crop_width = (gint) ((_tmp13_ * 0.8) + 0.5);
			_tmp14_ = height;
			crop_height = (gint) ((_tmp14_ * 0.8) + 0.5);
			_tmp15_ = page;
			_tmp16_ = crop_width;
			_tmp17_ = crop_height;
			page_set_custom_crop (_tmp15_, _tmp16_, _tmp17_);
			_tmp18_ = page;
			_tmp19_ = width;
			_tmp20_ = crop_width;
			_tmp21_ = height;
			_tmp22_ = crop_height;
			page_move_crop (_tmp18_, (_tmp19_ - _tmp20_) / 2, (_tmp21_ - _tmp22_) / 2);
		} else {
			Page* _tmp23_;
			const gchar* _tmp24_;
			_tmp23_ = page;
			_tmp24_ = crop_name;
			page_set_named_crop (_tmp23_, _tmp24_);
		}
	}
	_page_unref0 (page);
}


void G_MODULE_EXPORT no_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		simple_scan_set_crop (self, NULL);
	}
}


void G_MODULE_EXPORT custom_crop_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		simple_scan_set_crop (self, "custom");
	}
}


void G_MODULE_EXPORT crop_toolbutton_toggled_cb (GtkToggleToolButton* widget, SimpleScan* self) {
	gboolean _tmp0_;
	GtkRadioMenuItem* menuitem = NULL;
	GtkToggleToolButton* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkRadioMenuItem* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->updating_page_menu;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = widget;
	_tmp2_ = gtk_toggle_tool_button_get_active (_tmp1_);
	if (_tmp2_) {
		GtkBuilder* _tmp3_;
		GObject* _tmp4_ = NULL;
		GtkRadioMenuItem* _tmp5_;
		_tmp3_ = self->priv->builder;
		_tmp4_ = gtk_builder_get_object (_tmp3_, "custom_crop_menuitem");
		_tmp5_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp4_));
		_g_object_unref0 (menuitem);
		menuitem = _tmp5_;
	} else {
		GtkBuilder* _tmp6_;
		GObject* _tmp7_ = NULL;
		GtkRadioMenuItem* _tmp8_;
		_tmp6_ = self->priv->builder;
		_tmp7_ = gtk_builder_get_object (_tmp6_, "no_crop_menuitem");
		_tmp8_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp7_));
		_g_object_unref0 (menuitem);
		menuitem = _tmp8_;
	}
	_tmp9_ = menuitem;
	gtk_check_menu_item_set_active ((GtkCheckMenuItem*) _tmp9_, TRUE);
	_g_object_unref0 (menuitem);
}


void G_MODULE_EXPORT four_by_six_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		simple_scan_set_crop (self, "4x6");
	}
}


void G_MODULE_EXPORT legal_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		simple_scan_set_crop (self, "legal");
	}
}


void G_MODULE_EXPORT letter_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		simple_scan_set_crop (self, "letter");
	}
}


void G_MODULE_EXPORT a6_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		simple_scan_set_crop (self, "A6");
	}
}


void G_MODULE_EXPORT a5_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		simple_scan_set_crop (self, "A5");
	}
}


void G_MODULE_EXPORT a4_menuitem_toggled_cb (GtkCheckMenuItem* widget, SimpleScan* self) {
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	if (_tmp1_) {
		simple_scan_set_crop (self, "A4");
	}
}


void G_MODULE_EXPORT crop_rotate_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Page* _tmp2_;
	Page* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected (_tmp0_);
	page = _tmp1_;
	_tmp2_ = page;
	if (_tmp2_ == NULL) {
		_page_unref0 (page);
		return;
	}
	_tmp3_ = page;
	page_rotate_crop (_tmp3_);
	_page_unref0 (page);
}


void G_MODULE_EXPORT page_move_left_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Book* _tmp2_;
	Page* _tmp3_;
	guint _tmp4_ = 0U;
	guint index;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected (_tmp0_);
	page = _tmp1_;
	_tmp2_ = self->priv->book;
	_tmp3_ = page;
	_tmp4_ = book_get_page_index (_tmp2_, _tmp3_);
	index = _tmp4_;
	_tmp5_ = index;
	if (_tmp5_ > ((guint) 0)) {
		Book* _tmp6_;
		Page* _tmp7_;
		guint _tmp8_;
		_tmp6_ = self->priv->book;
		_tmp7_ = page;
		_tmp8_ = index;
		book_move_page (_tmp6_, _tmp7_, _tmp8_ - 1);
	}
	simple_scan_update_page_menu (self);
	_page_unref0 (page);
}


void G_MODULE_EXPORT page_move_right_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	Book* _tmp2_;
	Page* _tmp3_;
	guint _tmp4_ = 0U;
	guint index;
	guint _tmp5_;
	Book* _tmp6_;
	guint _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected (_tmp0_);
	page = _tmp1_;
	_tmp2_ = self->priv->book;
	_tmp3_ = page;
	_tmp4_ = book_get_page_index (_tmp2_, _tmp3_);
	index = _tmp4_;
	_tmp5_ = index;
	_tmp6_ = self->priv->book;
	_tmp7_ = book_get_n_pages (_tmp6_);
	if (_tmp5_ < (_tmp7_ - 1)) {
		Book* _tmp8_;
		Page* _tmp9_;
		Book* _tmp10_;
		Page* _tmp11_;
		guint _tmp12_ = 0U;
		_tmp8_ = self->priv->book;
		_tmp9_ = page;
		_tmp10_ = self->priv->book;
		_tmp11_ = page;
		_tmp12_ = book_get_page_index (_tmp10_, _tmp11_);
		book_move_page (_tmp8_, _tmp9_, _tmp12_ + 1);
	}
	simple_scan_update_page_menu (self);
	_page_unref0 (page);
}


void G_MODULE_EXPORT page_delete_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	BookView* _tmp0_;
	Book* _tmp1_ = NULL;
	Book* _tmp2_;
	BookView* _tmp3_;
	Page* _tmp4_ = NULL;
	Page* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_book (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->book_view;
	_tmp4_ = book_view_get_selected (_tmp3_);
	_tmp5_ = _tmp4_;
	book_delete_page (_tmp2_, _tmp5_);
	_page_unref0 (_tmp5_);
	_book_unref0 (_tmp2_);
}


void G_MODULE_EXPORT save_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	simple_scan_save_document (self, FALSE);
}


void G_MODULE_EXPORT save_as_file_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	simple_scan_save_document (self, TRUE);
}


static gpointer _cairo_reference0 (gpointer self) {
	return self ? cairo_reference (self) : NULL;
}


static void simple_scan_draw_page (SimpleScan* self, GtkPrintOperation* operation, GtkPrintContext* print_context, gint page_number) {
	GtkPrintContext* _tmp0_;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_;
	cairo_t* context;
	Book* _tmp3_;
	gint _tmp4_;
	Page* _tmp5_ = NULL;
	Page* page;
	gboolean is_landscape;
	GtkPrintContext* _tmp6_;
	gdouble _tmp7_ = 0.0;
	GtkPrintContext* _tmp8_;
	gdouble _tmp9_ = 0.0;
	Page* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	cairo_t* _tmp17_;
	GtkPrintContext* _tmp18_;
	gdouble _tmp19_ = 0.0;
	Page* _tmp20_;
	gint _tmp21_ = 0;
	GtkPrintContext* _tmp22_;
	gdouble _tmp23_ = 0.0;
	Page* _tmp24_;
	gint _tmp25_ = 0;
	Page* _tmp26_;
	GdkPixbuf* _tmp27_ = NULL;
	GdkPixbuf* image;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (print_context != NULL);
	_tmp0_ = print_context;
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
	_tmp2_ = _cairo_reference0 (_tmp1_);
	context = _tmp2_;
	_tmp3_ = self->priv->book;
	_tmp4_ = page_number;
	_tmp5_ = book_get_page (_tmp3_, _tmp4_);
	page = _tmp5_;
	is_landscape = FALSE;
	_tmp6_ = print_context;
	_tmp7_ = gtk_print_context_get_width (_tmp6_);
	_tmp8_ = print_context;
	_tmp9_ = gtk_print_context_get_height (_tmp8_);
	if (_tmp7_ > _tmp9_) {
		is_landscape = TRUE;
	}
	_tmp10_ = page;
	_tmp11_ = page_is_landscape (_tmp10_);
	_tmp12_ = is_landscape;
	if (_tmp11_ != _tmp12_) {
		cairo_t* _tmp13_;
		GtkPrintContext* _tmp14_;
		gdouble _tmp15_ = 0.0;
		cairo_t* _tmp16_;
		_tmp13_ = context;
		_tmp14_ = print_context;
		_tmp15_ = gtk_print_context_get_width (_tmp14_);
		cairo_translate (_tmp13_, _tmp15_, (gdouble) 0);
		_tmp16_ = context;
		cairo_rotate (_tmp16_, G_PI_2);
	}
	_tmp17_ = context;
	_tmp18_ = print_context;
	_tmp19_ = gtk_print_context_get_dpi_x (_tmp18_);
	_tmp20_ = page;
	_tmp21_ = page_get_dpi (_tmp20_);
	_tmp22_ = print_context;
	_tmp23_ = gtk_print_context_get_dpi_y (_tmp22_);
	_tmp24_ = page;
	_tmp25_ = page_get_dpi (_tmp24_);
	cairo_scale (_tmp17_, _tmp19_ / _tmp21_, _tmp23_ / _tmp25_);
	_tmp26_ = page;
	_tmp27_ = page_get_image (_tmp26_, TRUE);
	image = _tmp27_;
	_tmp28_ = context;
	gdk_cairo_set_source_pixbuf (_tmp28_, image, (gdouble) 0, (gdouble) 0);
	_tmp29_ = context;
	cairo_paint (_tmp29_);
	_g_object_unref0 (image);
	_page_unref0 (page);
	_cairo_destroy0 (context);
}


void G_MODULE_EXPORT email_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->document_hint;
	g_signal_emit_by_name (self, "email", _tmp0_);
}


static void _simple_scan_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
	simple_scan_draw_page (self, _sender, context, page_nr);
}


void G_MODULE_EXPORT print_button_clicked_cb (GtkWidget* widget, SimpleScan* self) {
	GtkPrintOperation* _tmp0_;
	GtkPrintOperation* print;
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_print_operation_new ();
	print = _tmp0_;
	_tmp1_ = self->priv->book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	gtk_print_operation_set_n_pages (print, (gint) _tmp2_);
	g_signal_connect (print, "draw-page", (GCallback) _simple_scan_draw_page_gtk_print_operation_draw_page, self);
	{
		GtkWindow* _tmp3_;
		_tmp3_ = self->priv->window;
		gtk_print_operation_run (print, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("ui.vala:1045: Error printing: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (print);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (print);
}


void G_MODULE_EXPORT help_contents_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:simple-scan", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Unable to open help file");
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		simple_scan_show_error_dialog (self, _tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void G_MODULE_EXPORT about_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* license;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* title;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* description;
	GtkWindow* _tmp8_;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = g_strdup ("Robert Ancell <robert.ancell@canonical.com>");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	authors = _tmp1_;
	authors_length1 = 1;
	_authors_size_ = authors_length1;
	_tmp2_ = _ ("This program is free software: you can redistribute it and/or modify\n" \
"it under the terms of the GNU General Public License as published by\n" \
"the Free Software Foundation, either version 3 of the License, or\n" \
"(at your option) any later version.\n" \
"\n" \
"This program is distributed in the hope that it will be useful,\n" \
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n" \
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n" \
"GNU General Public License for more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License\n" \
"along with this program.  If not, see <http://www.gnu.org/licenses/>.");
	_tmp3_ = g_strdup (_tmp2_);
	license = _tmp3_;
	_tmp4_ = _ ("About Simple Scan");
	_tmp5_ = g_strdup (_tmp4_);
	title = _tmp5_;
	_tmp6_ = _ ("Simple document scanning tool");
	_tmp7_ = g_strdup (_tmp6_);
	description = _tmp7_;
	_tmp8_ = self->priv->window;
	_tmp9_ = _ ("translator-credits");
	gtk_show_about_dialog (_tmp8_, "title", title, "program-name", "Simple Scan", "version", VERSION, "comments", description, "logo-icon-name", "scanner", "authors", authors, "translator-credits", _tmp9_, "website", "https://launchpad.net/simple-scan", "copyright", "Copyright © 2009-2011 Canonical Ltd.", "license", license, "wrap-license", TRUE, NULL, NULL);
	_g_free0 (description);
	_g_free0 (title);
	_g_free0 (license);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean simple_scan_on_quit (SimpleScan* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gchar* device;
	gint paper_width;
	gint paper_height;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	const gchar* _tmp6_;
	GSettings* _tmp9_;
	const gchar* _tmp10_;
	GSettings* _tmp11_;
	gint _tmp12_ = 0;
	GSettings* _tmp13_;
	gint _tmp14_ = 0;
	GSettings* _tmp15_;
	ScanType _tmp16_ = 0;
	GSettings* _tmp17_;
	gint _tmp18_;
	GSettings* _tmp19_;
	gint _tmp20_;
	GSettings* _tmp21_;
	gint _tmp22_;
	GSettings* _tmp23_;
	gint _tmp24_;
	GSettings* _tmp25_;
	gboolean _tmp26_;
	GSettings* _tmp27_;
	ScanDirection _tmp28_;
	GSettings* _tmp29_;
	gint _tmp30_;
	GSettings* _tmp31_;
	gint _tmp32_;
	GSettings* _tmp33_;
	gint _tmp34_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = _ ("Save document before quitting?");
	_tmp1_ = _ ("Quit without Saving");
	_tmp2_ = simple_scan_prompt_to_save (self, _tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = simple_scan_get_selected_device (self);
	device = _tmp3_;
	paper_width = 0;
	paper_height = 0;
	simple_scan_get_paper_size (self, &_tmp4_, &_tmp5_);
	paper_width = _tmp4_;
	paper_height = _tmp5_;
	_tmp6_ = device;
	if (_tmp6_ != NULL) {
		GSettings* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->settings;
		_tmp8_ = device;
		g_settings_set_string (_tmp7_, "selected-device", _tmp8_);
	}
	_tmp9_ = self->priv->settings;
	_tmp10_ = self->priv->document_hint;
	g_settings_set_string (_tmp9_, "document-type", _tmp10_);
	_tmp11_ = self->priv->settings;
	_tmp12_ = simple_scan_get_text_dpi (self);
	g_settings_set_int (_tmp11_, "text-dpi", _tmp12_);
	_tmp13_ = self->priv->settings;
	_tmp14_ = simple_scan_get_photo_dpi (self);
	g_settings_set_int (_tmp13_, "photo-dpi", _tmp14_);
	_tmp15_ = self->priv->settings;
	_tmp16_ = simple_scan_get_page_side (self);
	g_settings_set_enum (_tmp15_, "page-side", (gint) _tmp16_);
	_tmp17_ = self->priv->settings;
	_tmp18_ = paper_width;
	g_settings_set_int (_tmp17_, "paper-width", _tmp18_);
	_tmp19_ = self->priv->settings;
	_tmp20_ = paper_height;
	g_settings_set_int (_tmp19_, "paper-height", _tmp20_);
	_tmp21_ = self->priv->settings;
	_tmp22_ = self->priv->window_width;
	g_settings_set_int (_tmp21_, "window-width", _tmp22_);
	_tmp23_ = self->priv->settings;
	_tmp24_ = self->priv->window_height;
	g_settings_set_int (_tmp23_, "window-height", _tmp24_);
	_tmp25_ = self->priv->settings;
	_tmp26_ = self->priv->window_is_maximized;
	g_settings_set_boolean (_tmp25_, "window-is-maximized", _tmp26_);
	_tmp27_ = self->priv->settings;
	_tmp28_ = self->priv->default_page_scan_direction;
	g_settings_set_enum (_tmp27_, "scan-direction", (gint) _tmp28_);
	_tmp29_ = self->priv->settings;
	_tmp30_ = self->priv->default_page_width;
	g_settings_set_int (_tmp29_, "page-width", _tmp30_);
	_tmp31_ = self->priv->settings;
	_tmp32_ = self->priv->default_page_height;
	g_settings_set_int (_tmp31_, "page-height", _tmp32_);
	_tmp33_ = self->priv->settings;
	_tmp34_ = self->priv->default_page_dpi;
	g_settings_set_int (_tmp33_, "page-dpi", _tmp34_);
	g_signal_emit_by_name (self, "quit");
	result = TRUE;
	_g_free0 (device);
	return result;
}


void G_MODULE_EXPORT quit_menuitem_activate_cb (GtkWidget* widget, SimpleScan* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	simple_scan_on_quit (self);
}


gboolean G_MODULE_EXPORT simple_scan_window_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, SimpleScan* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->window_is_maximized;
	if (!_tmp0_) {
		GdkEventConfigure _tmp1_;
		gint _tmp2_;
		GdkEventConfigure _tmp3_;
		gint _tmp4_;
		_tmp1_ = *event;
		_tmp2_ = _tmp1_.width;
		self->priv->window_width = _tmp2_;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.height;
		self->priv->window_height = _tmp4_;
	}
	result = FALSE;
	return result;
}


static void simple_scan_info_bar_response_cb (SimpleScan* self, GtkInfoBar* widget, gint response_id) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ == 1) {
		GtkComboBox* _tmp1_;
		GtkDialog* _tmp2_;
		_tmp1_ = self->priv->device_combo;
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
		_tmp2_ = self->priv->preferences_dialog;
		gtk_window_present ((GtkWindow*) _tmp2_);
	} else {
		self->priv->have_error = FALSE;
		_g_free0 (self->priv->error_title);
		self->priv->error_title = NULL;
		_g_free0 (self->priv->error_text);
		self->priv->error_text = NULL;
		simple_scan_update_info_bar (self);
	}
}


gboolean G_MODULE_EXPORT simple_scan_window_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, SimpleScan* self) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_;
	GdkWindowState _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState _tmp2_;
		GdkWindowState _tmp3_;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.new_window_state;
		self->priv->window_is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	result = FALSE;
	return result;
}


gboolean G_MODULE_EXPORT window_delete_event_cb (GtkWidget* widget, GdkEvent* event, SimpleScan* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = simple_scan_on_quit (self);
	result = !_tmp0_;
	return result;
}


static void simple_scan_page_size_changed_cb (SimpleScan* self, Page* page) {
	Page* _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_ = 0;
	Page* _tmp4_;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	_tmp1_ = page_get_width (_tmp0_);
	self->priv->default_page_width = _tmp1_;
	_tmp2_ = page;
	_tmp3_ = page_get_height (_tmp2_);
	self->priv->default_page_height = _tmp3_;
	_tmp4_ = page;
	_tmp5_ = page_get_dpi (_tmp4_);
	self->priv->default_page_dpi = _tmp5_;
}


static void simple_scan_page_scan_direction_changed_cb (SimpleScan* self, Page* page) {
	Page* _tmp0_;
	ScanDirection _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	_tmp1_ = page_get_scan_direction (_tmp0_);
	self->priv->default_page_scan_direction = _tmp1_;
}


static void _simple_scan_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
	simple_scan_page_size_changed_cb (self, _sender);
}


static void _simple_scan_page_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
	simple_scan_page_scan_direction_changed_cb (self, _sender);
}


static void simple_scan_page_added_cb (SimpleScan* self, Book* book, Page* page) {
	Page* _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_ = 0;
	Page* _tmp4_;
	gint _tmp5_ = 0;
	Page* _tmp6_;
	ScanDirection _tmp7_ = 0;
	Page* _tmp8_;
	Page* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	_tmp1_ = page_get_width (_tmp0_);
	self->priv->default_page_width = _tmp1_;
	_tmp2_ = page;
	_tmp3_ = page_get_height (_tmp2_);
	self->priv->default_page_height = _tmp3_;
	_tmp4_ = page;
	_tmp5_ = page_get_dpi (_tmp4_);
	self->priv->default_page_dpi = _tmp5_;
	_tmp6_ = page;
	_tmp7_ = page_get_scan_direction (_tmp6_);
	self->priv->default_page_scan_direction = _tmp7_;
	_tmp8_ = page;
	g_signal_connect (_tmp8_, "size-changed", (GCallback) _simple_scan_page_size_changed_cb_page_size_changed, self);
	_tmp9_ = page;
	g_signal_connect (_tmp9_, "scan-direction-changed", (GCallback) _simple_scan_page_scan_direction_changed_cb_page_scan_direction_changed, self);
	simple_scan_update_page_menu (self);
}


static void simple_scan_page_removed_cb (SimpleScan* self, Book* book, Page* page) {
	Book* _tmp0_;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = book;
	_tmp1_ = book_get_n_pages (_tmp0_);
	if (_tmp1_ == ((guint) 1)) {
		simple_scan_add_default_page (self);
	}
	simple_scan_update_page_menu (self);
}


static void simple_scan_set_dpi_combo (SimpleScan* self, GtkComboBox* combo, gint default_dpi, gint current_dpi) {
	GtkCellRendererText* _tmp0_;
	GtkCellRendererText* _tmp1_;
	GtkCellRendererText* renderer;
	GtkComboBox* _tmp2_;
	GtkCellRendererText* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkCellRendererText* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkTreeModel* _tmp7_ = NULL;
	GtkListStore* _tmp8_;
	GtkListStore* model;
	gint* _tmp9_ = NULL;
	gint* scan_resolutions;
	gint scan_resolutions_length1;
	gint _scan_resolutions_size_;
	gint* _tmp10_;
	gint _tmp10__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	renderer = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp2_, (GtkCellRenderer*) _tmp3_, TRUE);
	_tmp4_ = combo;
	_tmp5_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp4_, (GtkCellRenderer*) _tmp5_, "text", 1);
	_tmp6_ = combo;
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
	_tmp8_ = _g_object_ref0 (GTK_LIST_STORE (_tmp7_));
	model = _tmp8_;
	_tmp9_ = g_new0 (gint, 6);
	_tmp9_[0] = 75;
	_tmp9_[1] = 150;
	_tmp9_[2] = 300;
	_tmp9_[3] = 600;
	_tmp9_[4] = 1200;
	_tmp9_[5] = 2400;
	scan_resolutions = _tmp9_;
	scan_resolutions_length1 = 6;
	_scan_resolutions_size_ = scan_resolutions_length1;
	_tmp10_ = scan_resolutions;
	_tmp10__length1 = scan_resolutions_length1;
	{
		gint* dpi_collection = NULL;
		gint dpi_collection_length1 = 0;
		gint _dpi_collection_size_ = 0;
		gint dpi_it = 0;
		dpi_collection = _tmp10_;
		dpi_collection_length1 = _tmp10__length1;
		for (dpi_it = 0; dpi_it < _tmp10__length1; dpi_it = dpi_it + 1) {
			gint dpi = 0;
			dpi = dpi_collection[dpi_it];
			{
				gchar* label = NULL;
				gint _tmp11_;
				gint _tmp12_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp27_;
				GtkTreeIter _tmp28_ = {0};
				GtkListStore* _tmp29_;
				GtkTreeIter _tmp30_;
				gint _tmp31_;
				const gchar* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				_tmp11_ = dpi;
				_tmp12_ = default_dpi;
				if (_tmp11_ == _tmp12_) {
					const gchar* _tmp13_ = NULL;
					gint _tmp14_;
					gchar* _tmp15_ = NULL;
					_tmp13_ = _ ("%d dpi (default)");
					_tmp14_ = dpi;
					_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
					_g_free0 (label);
					label = _tmp15_;
				} else {
					gint _tmp16_;
					_tmp16_ = dpi;
					if (_tmp16_ == 75) {
						const gchar* _tmp17_ = NULL;
						gint _tmp18_;
						gchar* _tmp19_ = NULL;
						_tmp17_ = _ ("%d dpi (draft)");
						_tmp18_ = dpi;
						_tmp19_ = g_strdup_printf (_tmp17_, _tmp18_);
						_g_free0 (label);
						label = _tmp19_;
					} else {
						gint _tmp20_;
						_tmp20_ = dpi;
						if (_tmp20_ == 1200) {
							const gchar* _tmp21_ = NULL;
							gint _tmp22_;
							gchar* _tmp23_ = NULL;
							_tmp21_ = _ ("%d dpi (high resolution)");
							_tmp22_ = dpi;
							_tmp23_ = g_strdup_printf (_tmp21_, _tmp22_);
							_g_free0 (label);
							label = _tmp23_;
						} else {
							const gchar* _tmp24_ = NULL;
							gint _tmp25_;
							gchar* _tmp26_ = NULL;
							_tmp24_ = _ ("%d dpi");
							_tmp25_ = dpi;
							_tmp26_ = g_strdup_printf (_tmp24_, _tmp25_);
							_g_free0 (label);
							label = _tmp26_;
						}
					}
				}
				_tmp27_ = model;
				gtk_list_store_append (_tmp27_, &_tmp28_);
				iter = _tmp28_;
				_tmp29_ = model;
				_tmp30_ = iter;
				_tmp31_ = dpi;
				_tmp32_ = label;
				gtk_list_store_set (_tmp29_, &_tmp30_, 0, _tmp31_, 1, _tmp32_, -1, -1);
				_tmp33_ = dpi;
				_tmp34_ = current_dpi;
				if (_tmp33_ == _tmp34_) {
					GtkComboBox* _tmp35_;
					GtkTreeIter _tmp36_;
					_tmp35_ = combo;
					_tmp36_ = iter;
					gtk_combo_box_set_active_iter (_tmp35_, &_tmp36_);
				}
				_g_free0 (label);
			}
		}
	}
	scan_resolutions = (g_free (scan_resolutions), NULL);
	_g_object_unref0 (model);
	_g_object_unref0 (renderer);
}


static void simple_scan_needs_saving_cb (SimpleScan* self, Book* book) {
	GtkMenuItem* _tmp0_;
	Book* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkToolButton* _tmp3_;
	Book* _tmp4_;
	gboolean _tmp5_ = FALSE;
	Book* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	_tmp0_ = self->priv->save_menuitem;
	_tmp1_ = book;
	_tmp2_ = book_get_needs_saving (_tmp1_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_);
	_tmp3_ = self->priv->save_toolbutton;
	_tmp4_ = book;
	_tmp5_ = book_get_needs_saving (_tmp4_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp5_);
	_tmp6_ = book;
	_tmp7_ = book_get_needs_saving (_tmp6_);
	if (_tmp7_) {
		GtkMenuItem* _tmp8_;
		_tmp8_ = self->priv->save_as_menuitem;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, TRUE);
	}
}


static void _simple_scan_info_bar_response_cb_gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	simple_scan_info_bar_response_cb (self, _sender, response_id);
}


static void _simple_scan_page_selected_cb_book_view_page_selected (BookView* _sender, Page* page, gpointer self) {
	simple_scan_page_selected_cb (self, _sender, page);
}


static void _simple_scan_show_page_cb_book_view_show_page (BookView* _sender, Page* page, gpointer self) {
	simple_scan_show_page_cb (self, _sender, page);
}


static void _simple_scan_show_page_menu_cb_book_view_show_menu (BookView* _sender, gpointer self) {
	simple_scan_show_page_menu_cb (self, _sender);
}


static void _simple_scan_needs_saving_cb_book_needs_saving_changed (Book* _sender, gpointer self) {
	simple_scan_needs_saving_cb (self, _sender);
}


static void simple_scan_load (SimpleScan* self) {
	GtkIconTheme* _tmp0_ = NULL;
	GtkBuilder* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* filename;
	GtkBuilder* _tmp8_;
	GtkBuilder* _tmp9_;
	GObject* _tmp10_ = NULL;
	GtkWindow* _tmp11_;
	GtkBuilder* _tmp12_;
	GObject* _tmp13_ = NULL;
	GtkVBox* _tmp14_;
	GtkBuilder* _tmp15_;
	GObject* _tmp16_ = NULL;
	GtkMenuItem* _tmp17_;
	GtkBuilder* _tmp18_;
	GObject* _tmp19_ = NULL;
	GtkMenuItem* _tmp20_;
	GtkBuilder* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkMenuItem* _tmp23_;
	GtkBuilder* _tmp24_;
	GObject* _tmp25_ = NULL;
	GtkMenuItem* _tmp26_;
	GtkBuilder* _tmp27_;
	GObject* _tmp28_ = NULL;
	GtkMenuItem* _tmp29_;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_ = NULL;
	GtkMenuItem* _tmp32_;
	GtkBuilder* _tmp33_;
	GObject* _tmp34_ = NULL;
	GtkToolButton* _tmp35_;
	GtkBuilder* _tmp36_;
	GObject* _tmp37_ = NULL;
	GtkMenuItem* _tmp38_;
	GtkBuilder* _tmp39_;
	GObject* _tmp40_ = NULL;
	GtkToolButton* _tmp41_;
	GtkBuilder* _tmp42_;
	GObject* _tmp43_ = NULL;
	GtkRadioMenuItem* _tmp44_;
	GtkBuilder* _tmp45_;
	GObject* _tmp46_ = NULL;
	GtkRadioMenuItem* _tmp47_;
	GtkBuilder* _tmp48_;
	GObject* _tmp49_ = NULL;
	GtkRadioMenuItem* _tmp50_;
	GtkBuilder* _tmp51_;
	GObject* _tmp52_ = NULL;
	GtkRadioMenuItem* _tmp53_;
	GtkBuilder* _tmp54_;
	GObject* _tmp55_ = NULL;
	GtkDialog* _tmp56_;
	GtkBuilder* _tmp57_;
	GObject* _tmp58_ = NULL;
	GtkLabel* _tmp59_;
	GtkBuilder* _tmp60_;
	GObject* _tmp61_ = NULL;
	GtkEntry* _tmp62_;
	GtkBuilder* _tmp63_;
	GObject* _tmp64_ = NULL;
	GtkEntry* _tmp65_;
	GtkBuilder* _tmp66_;
	GObject* _tmp67_ = NULL;
	GtkDialog* _tmp68_;
	GtkBuilder* _tmp69_;
	GObject* _tmp70_ = NULL;
	GtkComboBox* _tmp71_;
	GtkComboBox* _tmp72_;
	GtkTreeModel* _tmp73_ = NULL;
	GtkListStore* _tmp74_;
	GtkBuilder* _tmp75_;
	GObject* _tmp76_ = NULL;
	GtkComboBox* _tmp77_;
	GtkComboBox* _tmp78_;
	GtkTreeModel* _tmp79_ = NULL;
	GtkListStore* _tmp80_;
	GtkBuilder* _tmp81_;
	GObject* _tmp82_ = NULL;
	GtkComboBox* _tmp83_;
	GtkComboBox* _tmp84_;
	GtkTreeModel* _tmp85_ = NULL;
	GtkListStore* _tmp86_;
	GtkBuilder* _tmp87_;
	GObject* _tmp88_ = NULL;
	GtkComboBox* _tmp89_;
	GtkComboBox* _tmp90_;
	GtkTreeModel* _tmp91_ = NULL;
	GtkListStore* _tmp92_;
	GtkBuilder* _tmp93_;
	GObject* _tmp94_ = NULL;
	GtkComboBox* _tmp95_;
	GtkComboBox* _tmp96_;
	GtkTreeModel* _tmp97_ = NULL;
	GtkListStore* _tmp98_;
	GtkInfoBar* _tmp99_;
	GtkInfoBar* _tmp100_;
	GtkInfoBar* _tmp101_;
	GtkVBox* _tmp102_;
	GtkInfoBar* _tmp103_;
	GtkBox* _tmp104_;
	GtkBox* _tmp105_;
	GtkBox* hbox;
	GtkInfoBar* _tmp106_;
	GtkWidget* _tmp107_ = NULL;
	GtkContainer* _tmp108_;
	GtkContainer* content_area;
	GtkContainer* _tmp109_;
	GtkBox* _tmp110_;
	GtkBox* _tmp111_;
	GtkImage* _tmp112_;
	GtkImage* _tmp113_;
	GtkBox* _tmp114_;
	GtkImage* _tmp115_;
	GtkImage* _tmp116_;
	GtkLabel* _tmp117_;
	GtkLabel* _tmp118_;
	GtkLabel* _tmp119_;
	GtkBox* _tmp120_;
	GtkLabel* _tmp121_;
	GtkLabel* _tmp122_;
	GtkInfoBar* _tmp123_;
	GtkWidget* _tmp124_ = NULL;
	GtkButton* _tmp125_;
	GtkInfoBar* _tmp126_;
	const gchar* _tmp127_ = NULL;
	GtkWidget* _tmp128_ = NULL;
	GtkButton* _tmp129_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp130_;
	GtkTreeIter _tmp131_ = {0};
	GtkListStore* _tmp132_;
	GtkTreeIter _tmp133_;
	const gchar* _tmp134_ = NULL;
	GtkListStore* _tmp135_;
	GtkTreeIter _tmp136_ = {0};
	GtkListStore* _tmp137_;
	GtkTreeIter _tmp138_;
	GtkListStore* _tmp139_;
	GtkTreeIter _tmp140_ = {0};
	GtkListStore* _tmp141_;
	GtkTreeIter _tmp142_;
	GtkListStore* _tmp143_;
	GtkTreeIter _tmp144_ = {0};
	GtkListStore* _tmp145_;
	GtkTreeIter _tmp146_;
	GtkListStore* _tmp147_;
	GtkTreeIter _tmp148_ = {0};
	GtkListStore* _tmp149_;
	GtkTreeIter _tmp150_;
	GtkListStore* _tmp151_;
	GtkTreeIter _tmp152_ = {0};
	GtkListStore* _tmp153_;
	GtkTreeIter _tmp154_;
	GtkListStore* _tmp155_;
	GtkTreeIter _tmp156_ = {0};
	GtkListStore* _tmp157_;
	GtkTreeIter _tmp158_;
	GSettings* _tmp159_;
	gint _tmp160_ = 0;
	gint dpi;
	gint _tmp161_;
	GtkComboBox* _tmp162_;
	gint _tmp163_;
	GSettings* _tmp164_;
	gint _tmp165_ = 0;
	gint _tmp166_;
	GtkComboBox* _tmp167_;
	gint _tmp168_;
	GtkCellRendererText* _tmp169_;
	GtkCellRendererText* _tmp170_;
	GtkCellRendererText* renderer;
	GtkComboBox* _tmp171_;
	GtkCellRendererText* _tmp172_;
	GtkComboBox* _tmp173_;
	GtkCellRendererText* _tmp174_;
	GtkCellRendererText* _tmp175_;
	GtkCellRendererText* _tmp176_;
	GtkComboBox* _tmp177_;
	GtkCellRendererText* _tmp178_;
	GtkComboBox* _tmp179_;
	GtkCellRendererText* _tmp180_;
	GSettings* _tmp181_;
	gint _tmp182_ = 0;
	GtkCellRendererText* _tmp183_;
	GtkCellRendererText* _tmp184_;
	GtkComboBox* _tmp185_;
	GtkCellRendererText* _tmp186_;
	GtkComboBox* _tmp187_;
	GtkCellRendererText* _tmp188_;
	GSettings* _tmp189_;
	gint _tmp190_ = 0;
	gint paper_width;
	GSettings* _tmp191_;
	gint _tmp192_ = 0;
	gint paper_height;
	gint _tmp193_;
	gint _tmp194_;
	GSettings* _tmp195_;
	gchar* _tmp196_ = NULL;
	gchar* device;
	const gchar* _tmp197_;
	GSettings* _tmp203_;
	gchar* _tmp204_ = NULL;
	gchar* document_type;
	const gchar* _tmp205_;
	Book* _tmp207_;
	BookView* _tmp208_;
	BookView* _tmp209_;
	BookView* _tmp210_;
	GtkVBox* _tmp211_;
	BookView* _tmp212_;
	BookView* _tmp213_;
	BookView* _tmp214_;
	BookView* _tmp215_;
	BookView* _tmp216_;
	GSettings* _tmp217_;
	gint _tmp218_ = 0;
	GSettings* _tmp219_;
	gint _tmp220_ = 0;
	gint _tmp221_;
	GSettings* _tmp222_;
	gint _tmp223_ = 0;
	gint _tmp224_;
	GSettings* _tmp225_;
	gint _tmp226_ = 0;
	gint _tmp227_;
	GSettings* _tmp228_;
	gint _tmp229_ = 0;
	gint _tmp230_;
	GSettings* _tmp231_;
	gint _tmp232_ = 0;
	gint _tmp233_;
	gint _tmp234_;
	gint _tmp235_;
	GtkWindow* _tmp236_;
	gint _tmp237_;
	gint _tmp238_;
	GSettings* _tmp239_;
	gboolean _tmp240_ = FALSE;
	gboolean _tmp241_;
	Book* _tmp243_;
	guint _tmp244_ = 0U;
	Book* _tmp245_;
	Book* _tmp246_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	gtk_icon_theme_append_search_path (_tmp0_, ICON_DIR);
	gtk_window_set_default_icon_name ("scanner");
	_tmp1_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp1_;
	_tmp2_ = g_build_filename (UI_DIR, "simple-scan.ui", NULL, NULL);
	filename = _tmp2_;
	{
		GtkBuilder* _tmp3_;
		_tmp3_ = self->priv->builder;
		gtk_builder_add_from_file (_tmp3_, filename, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("ui.vala:1262: Unable to load UI %s: %s\n", filename, _tmp5_);
		_tmp6_ = _ ("Files missing");
		_tmp7_ = _ ("Please check your installation");
		simple_scan_show_error_dialog (self, _tmp6_, _tmp7_);
		exit (EXIT_FAILURE);
		_g_error_free0 (e);
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = self->priv->builder;
	gtk_builder_connect_signals (_tmp8_, self);
	_tmp9_ = self->priv->builder;
	_tmp10_ = gtk_builder_get_object (_tmp9_, "simple_scan_window");
	_tmp11_ = _g_object_ref0 (GTK_WINDOW (_tmp10_));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp11_;
	_tmp12_ = self->priv->builder;
	_tmp13_ = gtk_builder_get_object (_tmp12_, "main_vbox");
	_tmp14_ = _g_object_ref0 (GTK_VBOX (_tmp13_));
	_g_object_unref0 (self->priv->main_vbox);
	self->priv->main_vbox = _tmp14_;
	_tmp15_ = self->priv->builder;
	_tmp16_ = gtk_builder_get_object (_tmp15_, "page_move_left_menuitem");
	_tmp17_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp16_));
	_g_object_unref0 (self->priv->page_move_left_menuitem);
	self->priv->page_move_left_menuitem = _tmp17_;
	_tmp18_ = self->priv->builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "page_move_right_menuitem");
	_tmp20_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp19_));
	_g_object_unref0 (self->priv->page_move_right_menuitem);
	self->priv->page_move_right_menuitem = _tmp20_;
	_tmp21_ = self->priv->builder;
	_tmp22_ = gtk_builder_get_object (_tmp21_, "page_delete_menuitem");
	_tmp23_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp22_));
	_g_object_unref0 (self->priv->page_delete_menuitem);
	self->priv->page_delete_menuitem = _tmp23_;
	_tmp24_ = self->priv->builder;
	_tmp25_ = gtk_builder_get_object (_tmp24_, "crop_rotate_menuitem");
	_tmp26_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp25_));
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
	self->priv->crop_rotate_menuitem = _tmp26_;
	_tmp27_ = self->priv->builder;
	_tmp28_ = gtk_builder_get_object (_tmp27_, "save_menuitem");
	_tmp29_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp28_));
	_g_object_unref0 (self->priv->save_menuitem);
	self->priv->save_menuitem = _tmp29_;
	_tmp30_ = self->priv->builder;
	_tmp31_ = gtk_builder_get_object (_tmp30_, "save_as_menuitem");
	_tmp32_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp31_));
	_g_object_unref0 (self->priv->save_as_menuitem);
	self->priv->save_as_menuitem = _tmp32_;
	_tmp33_ = self->priv->builder;
	_tmp34_ = gtk_builder_get_object (_tmp33_, "save_toolbutton");
	_tmp35_ = _g_object_ref0 (GTK_TOOL_BUTTON (_tmp34_));
	_g_object_unref0 (self->priv->save_toolbutton);
	self->priv->save_toolbutton = _tmp35_;
	_tmp36_ = self->priv->builder;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "stop_scan_menuitem");
	_tmp38_ = _g_object_ref0 (GTK_MENU_ITEM (_tmp37_));
	_g_object_unref0 (self->priv->stop_menuitem);
	self->priv->stop_menuitem = _tmp38_;
	_tmp39_ = self->priv->builder;
	_tmp40_ = gtk_builder_get_object (_tmp39_, "stop_toolbutton");
	_tmp41_ = _g_object_ref0 (GTK_TOOL_BUTTON (_tmp40_));
	_g_object_unref0 (self->priv->stop_toolbutton);
	self->priv->stop_toolbutton = _tmp41_;
	_tmp42_ = self->priv->builder;
	_tmp43_ = gtk_builder_get_object (_tmp42_, "text_toolbutton_menuitem");
	_tmp44_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp43_));
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
	self->priv->text_toolbar_menuitem = _tmp44_;
	_tmp45_ = self->priv->builder;
	_tmp46_ = gtk_builder_get_object (_tmp45_, "text_menuitem");
	_tmp47_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp46_));
	_g_object_unref0 (self->priv->text_menu_menuitem);
	self->priv->text_menu_menuitem = _tmp47_;
	_tmp48_ = self->priv->builder;
	_tmp49_ = gtk_builder_get_object (_tmp48_, "photo_toolbutton_menuitem");
	_tmp50_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp49_));
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
	self->priv->photo_toolbar_menuitem = _tmp50_;
	_tmp51_ = self->priv->builder;
	_tmp52_ = gtk_builder_get_object (_tmp51_, "photo_menuitem");
	_tmp53_ = _g_object_ref0 (GTK_RADIO_MENU_ITEM (_tmp52_));
	_g_object_unref0 (self->priv->photo_menu_menuitem);
	self->priv->photo_menu_menuitem = _tmp53_;
	_tmp54_ = self->priv->builder;
	_tmp55_ = gtk_builder_get_object (_tmp54_, "authorize_dialog");
	_tmp56_ = _g_object_ref0 (GTK_DIALOG (_tmp55_));
	_g_object_unref0 (self->priv->authorize_dialog);
	self->priv->authorize_dialog = _tmp56_;
	_tmp57_ = self->priv->builder;
	_tmp58_ = gtk_builder_get_object (_tmp57_, "authorize_label");
	_tmp59_ = _g_object_ref0 (GTK_LABEL (_tmp58_));
	_g_object_unref0 (self->priv->authorize_label);
	self->priv->authorize_label = _tmp59_;
	_tmp60_ = self->priv->builder;
	_tmp61_ = gtk_builder_get_object (_tmp60_, "username_entry");
	_tmp62_ = _g_object_ref0 (GTK_ENTRY (_tmp61_));
	_g_object_unref0 (self->priv->username_entry);
	self->priv->username_entry = _tmp62_;
	_tmp63_ = self->priv->builder;
	_tmp64_ = gtk_builder_get_object (_tmp63_, "password_entry");
	_tmp65_ = _g_object_ref0 (GTK_ENTRY (_tmp64_));
	_g_object_unref0 (self->priv->password_entry);
	self->priv->password_entry = _tmp65_;
	_tmp66_ = self->priv->builder;
	_tmp67_ = gtk_builder_get_object (_tmp66_, "preferences_dialog");
	_tmp68_ = _g_object_ref0 (GTK_DIALOG (_tmp67_));
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp68_;
	_tmp69_ = self->priv->builder;
	_tmp70_ = gtk_builder_get_object (_tmp69_, "device_combo");
	_tmp71_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp70_));
	_g_object_unref0 (self->priv->device_combo);
	self->priv->device_combo = _tmp71_;
	_tmp72_ = self->priv->device_combo;
	_tmp73_ = gtk_combo_box_get_model (_tmp72_);
	_tmp74_ = _g_object_ref0 (GTK_LIST_STORE (_tmp73_));
	_g_object_unref0 (self->priv->device_model);
	self->priv->device_model = _tmp74_;
	_tmp75_ = self->priv->builder;
	_tmp76_ = gtk_builder_get_object (_tmp75_, "text_dpi_combo");
	_tmp77_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp76_));
	_g_object_unref0 (self->priv->text_dpi_combo);
	self->priv->text_dpi_combo = _tmp77_;
	_tmp78_ = self->priv->text_dpi_combo;
	_tmp79_ = gtk_combo_box_get_model (_tmp78_);
	_tmp80_ = _g_object_ref0 (GTK_LIST_STORE (_tmp79_));
	_g_object_unref0 (self->priv->text_dpi_model);
	self->priv->text_dpi_model = _tmp80_;
	_tmp81_ = self->priv->builder;
	_tmp82_ = gtk_builder_get_object (_tmp81_, "photo_dpi_combo");
	_tmp83_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp82_));
	_g_object_unref0 (self->priv->photo_dpi_combo);
	self->priv->photo_dpi_combo = _tmp83_;
	_tmp84_ = self->priv->photo_dpi_combo;
	_tmp85_ = gtk_combo_box_get_model (_tmp84_);
	_tmp86_ = _g_object_ref0 (GTK_LIST_STORE (_tmp85_));
	_g_object_unref0 (self->priv->photo_dpi_model);
	self->priv->photo_dpi_model = _tmp86_;
	_tmp87_ = self->priv->builder;
	_tmp88_ = gtk_builder_get_object (_tmp87_, "page_side_combo");
	_tmp89_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp88_));
	_g_object_unref0 (self->priv->page_side_combo);
	self->priv->page_side_combo = _tmp89_;
	_tmp90_ = self->priv->page_side_combo;
	_tmp91_ = gtk_combo_box_get_model (_tmp90_);
	_tmp92_ = _g_object_ref0 (GTK_LIST_STORE (_tmp91_));
	_g_object_unref0 (self->priv->page_side_model);
	self->priv->page_side_model = _tmp92_;
	_tmp93_ = self->priv->builder;
	_tmp94_ = gtk_builder_get_object (_tmp93_, "paper_size_combo");
	_tmp95_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp94_));
	_g_object_unref0 (self->priv->paper_size_combo);
	self->priv->paper_size_combo = _tmp95_;
	_tmp96_ = self->priv->paper_size_combo;
	_tmp97_ = gtk_combo_box_get_model (_tmp96_);
	_tmp98_ = _g_object_ref0 (GTK_LIST_STORE (_tmp97_));
	_g_object_unref0 (self->priv->paper_size_model);
	self->priv->paper_size_model = _tmp98_;
	_tmp99_ = (GtkInfoBar*) gtk_info_bar_new ();
	_tmp100_ = g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->info_bar);
	self->priv->info_bar = _tmp100_;
	_tmp101_ = self->priv->info_bar;
	g_signal_connect (_tmp101_, "response", (GCallback) _simple_scan_info_bar_response_cb_gtk_info_bar_response, self);
	_tmp102_ = self->priv->main_vbox;
	_tmp103_ = self->priv->info_bar;
	gtk_box_pack_start ((GtkBox*) _tmp102_, (GtkWidget*) _tmp103_, FALSE, TRUE, (guint) 0);
	_tmp104_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	_tmp105_ = g_object_ref_sink (_tmp104_);
	hbox = _tmp105_;
	_tmp106_ = self->priv->info_bar;
	_tmp107_ = gtk_info_bar_get_content_area (_tmp106_);
	_tmp108_ = _g_object_ref0 (GTK_CONTAINER (_tmp107_));
	content_area = _tmp108_;
	_tmp109_ = content_area;
	_tmp110_ = hbox;
	gtk_container_add (_tmp109_, (GtkWidget*) _tmp110_);
	_tmp111_ = hbox;
	gtk_widget_show ((GtkWidget*) _tmp111_);
	_tmp112_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_DIALOG);
	_tmp113_ = g_object_ref_sink (_tmp112_);
	_g_object_unref0 (self->priv->info_bar_image);
	self->priv->info_bar_image = _tmp113_;
	_tmp114_ = hbox;
	_tmp115_ = self->priv->info_bar_image;
	gtk_box_pack_start (_tmp114_, (GtkWidget*) _tmp115_, FALSE, TRUE, (guint) 0);
	_tmp116_ = self->priv->info_bar_image;
	gtk_widget_show ((GtkWidget*) _tmp116_);
	_tmp117_ = (GtkLabel*) gtk_label_new (NULL);
	_tmp118_ = g_object_ref_sink (_tmp117_);
	_g_object_unref0 (self->priv->info_bar_label);
	self->priv->info_bar_label = _tmp118_;
	_tmp119_ = self->priv->info_bar_label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp119_, 0.0f, 0.5f);
	_tmp120_ = hbox;
	_tmp121_ = self->priv->info_bar_label;
	gtk_box_pack_start (_tmp120_, (GtkWidget*) _tmp121_, TRUE, TRUE, (guint) 0);
	_tmp122_ = self->priv->info_bar_label;
	gtk_widget_show ((GtkWidget*) _tmp122_);
	_tmp123_ = self->priv->info_bar;
	_tmp124_ = gtk_info_bar_add_button (_tmp123_, GTK_STOCK_CLOSE, (gint) GTK_RESPONSE_CLOSE);
	_tmp125_ = _g_object_ref0 (GTK_BUTTON (_tmp124_));
	_g_object_unref0 (self->priv->info_bar_close_button);
	self->priv->info_bar_close_button = _tmp125_;
	_tmp126_ = self->priv->info_bar;
	_tmp127_ = _ ("Change _Scanner");
	_tmp128_ = gtk_info_bar_add_button (_tmp126_, _tmp127_, 1);
	_tmp129_ = _g_object_ref0 (GTK_BUTTON (_tmp128_));
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
	self->priv->info_bar_change_scanner_button = _tmp129_;
	_tmp130_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp130_, &_tmp131_);
	iter = _tmp131_;
	_tmp132_ = self->priv->paper_size_model;
	_tmp133_ = iter;
	_tmp134_ = _ ("Automatic");
	gtk_list_store_set (_tmp132_, &_tmp133_, 0, 0, 1, 0, 2, _tmp134_, -1, -1);
	_tmp135_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp135_, &_tmp136_);
	iter = _tmp136_;
	_tmp137_ = self->priv->paper_size_model;
	_tmp138_ = iter;
	gtk_list_store_set (_tmp137_, &_tmp138_, 0, 1050, 1, 1480, 2, "A6", -1, -1);
	_tmp139_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp139_, &_tmp140_);
	iter = _tmp140_;
	_tmp141_ = self->priv->paper_size_model;
	_tmp142_ = iter;
	gtk_list_store_set (_tmp141_, &_tmp142_, 0, 1480, 1, 2100, 2, "A5", -1, -1);
	_tmp143_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp143_, &_tmp144_);
	iter = _tmp144_;
	_tmp145_ = self->priv->paper_size_model;
	_tmp146_ = iter;
	gtk_list_store_set (_tmp145_, &_tmp146_, 0, 2100, 1, 2970, 2, "A4", -1, -1);
	_tmp147_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp147_, &_tmp148_);
	iter = _tmp148_;
	_tmp149_ = self->priv->paper_size_model;
	_tmp150_ = iter;
	gtk_list_store_set (_tmp149_, &_tmp150_, 0, 2159, 1, 2794, 2, "Letter", -1, -1);
	_tmp151_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp151_, &_tmp152_);
	iter = _tmp152_;
	_tmp153_ = self->priv->paper_size_model;
	_tmp154_ = iter;
	gtk_list_store_set (_tmp153_, &_tmp154_, 0, 2159, 1, 3556, 2, "Legal", -1, -1);
	_tmp155_ = self->priv->paper_size_model;
	gtk_list_store_append (_tmp155_, &_tmp156_);
	iter = _tmp156_;
	_tmp157_ = self->priv->paper_size_model;
	_tmp158_ = iter;
	gtk_list_store_set (_tmp157_, &_tmp158_, 0, 1016, 1, 1524, 2, "4×6", -1, -1);
	_tmp159_ = self->priv->settings;
	_tmp160_ = g_settings_get_int (_tmp159_, "text-dpi");
	dpi = _tmp160_;
	_tmp161_ = dpi;
	if (_tmp161_ <= 0) {
		dpi = SIMPLE_SCAN_DEFAULT_TEXT_DPI;
	}
	_tmp162_ = self->priv->text_dpi_combo;
	_tmp163_ = dpi;
	simple_scan_set_dpi_combo (self, _tmp162_, SIMPLE_SCAN_DEFAULT_TEXT_DPI, _tmp163_);
	_tmp164_ = self->priv->settings;
	_tmp165_ = g_settings_get_int (_tmp164_, "photo-dpi");
	dpi = _tmp165_;
	_tmp166_ = dpi;
	if (_tmp166_ <= 0) {
		dpi = SIMPLE_SCAN_DEFAULT_PHOTO_DPI;
	}
	_tmp167_ = self->priv->photo_dpi_combo;
	_tmp168_ = dpi;
	simple_scan_set_dpi_combo (self, _tmp167_, SIMPLE_SCAN_DEFAULT_PHOTO_DPI, _tmp168_);
	_tmp169_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp170_ = g_object_ref_sink (_tmp169_);
	renderer = _tmp170_;
	_tmp171_ = self->priv->device_combo;
	_tmp172_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp171_, (GtkCellRenderer*) _tmp172_, TRUE);
	_tmp173_ = self->priv->device_combo;
	_tmp174_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp173_, (GtkCellRenderer*) _tmp174_, "text", 1);
	_tmp175_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp176_ = g_object_ref_sink (_tmp175_);
	_g_object_unref0 (renderer);
	renderer = _tmp176_;
	_tmp177_ = self->priv->page_side_combo;
	_tmp178_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp177_, (GtkCellRenderer*) _tmp178_, TRUE);
	_tmp179_ = self->priv->page_side_combo;
	_tmp180_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp179_, (GtkCellRenderer*) _tmp180_, "text", 1);
	_tmp181_ = self->priv->settings;
	_tmp182_ = g_settings_get_enum (_tmp181_, "page-side");
	simple_scan_set_page_side (self, (ScanType) _tmp182_);
	_tmp183_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp184_ = g_object_ref_sink (_tmp183_);
	_g_object_unref0 (renderer);
	renderer = _tmp184_;
	_tmp185_ = self->priv->paper_size_combo;
	_tmp186_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp185_, (GtkCellRenderer*) _tmp186_, TRUE);
	_tmp187_ = self->priv->paper_size_combo;
	_tmp188_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp187_, (GtkCellRenderer*) _tmp188_, "text", 2);
	_tmp189_ = self->priv->settings;
	_tmp190_ = g_settings_get_int (_tmp189_, "paper-width");
	paper_width = _tmp190_;
	_tmp191_ = self->priv->settings;
	_tmp192_ = g_settings_get_int (_tmp191_, "paper-height");
	paper_height = _tmp192_;
	_tmp193_ = paper_width;
	_tmp194_ = paper_height;
	simple_scan_set_paper_size (self, _tmp193_, _tmp194_);
	_tmp195_ = self->priv->settings;
	_tmp196_ = g_settings_get_string (_tmp195_, "selected-device");
	device = _tmp196_;
	_tmp197_ = device;
	if (_tmp197_ != NULL) {
		const gchar* _tmp198_;
		GtkTreeIter _tmp199_ = {0};
		gboolean _tmp200_ = FALSE;
		_tmp198_ = device;
		_tmp200_ = simple_scan_find_scan_device (self, _tmp198_, &_tmp199_);
		iter = _tmp199_;
		if (_tmp200_) {
			GtkComboBox* _tmp201_;
			GtkTreeIter _tmp202_;
			_tmp201_ = self->priv->device_combo;
			_tmp202_ = iter;
			gtk_combo_box_set_active_iter (_tmp201_, &_tmp202_);
		}
	}
	_tmp203_ = self->priv->settings;
	_tmp204_ = g_settings_get_string (_tmp203_, "document-type");
	document_type = _tmp204_;
	_tmp205_ = document_type;
	if (_tmp205_ != NULL) {
		const gchar* _tmp206_;
		_tmp206_ = document_type;
		simple_scan_set_document_hint (self, _tmp206_);
	}
	_tmp207_ = self->priv->book;
	_tmp208_ = book_view_new (_tmp207_);
	_tmp209_ = g_object_ref_sink (_tmp208_);
	_g_object_unref0 (self->priv->book_view);
	self->priv->book_view = _tmp209_;
	_tmp210_ = self->priv->book_view;
	gtk_container_set_border_width ((GtkContainer*) _tmp210_, (guint) 18);
	_tmp211_ = self->priv->main_vbox;
	_tmp212_ = self->priv->book_view;
	gtk_box_pack_end ((GtkBox*) _tmp211_, (GtkWidget*) _tmp212_, TRUE, TRUE, (guint) 0);
	_tmp213_ = self->priv->book_view;
	g_signal_connect (_tmp213_, "page-selected", (GCallback) _simple_scan_page_selected_cb_book_view_page_selected, self);
	_tmp214_ = self->priv->book_view;
	g_signal_connect (_tmp214_, "show-page", (GCallback) _simple_scan_show_page_cb_book_view_show_page, self);
	_tmp215_ = self->priv->book_view;
	g_signal_connect (_tmp215_, "show-menu", (GCallback) _simple_scan_show_page_menu_cb_book_view_show_menu, self);
	_tmp216_ = self->priv->book_view;
	gtk_widget_show ((GtkWidget*) _tmp216_);
	_tmp217_ = self->priv->settings;
	_tmp218_ = g_settings_get_enum (_tmp217_, "scan-direction");
	self->priv->default_page_scan_direction = (ScanDirection) _tmp218_;
	_tmp219_ = self->priv->settings;
	_tmp220_ = g_settings_get_int (_tmp219_, "page-width");
	self->priv->default_page_width = _tmp220_;
	_tmp221_ = self->priv->default_page_width;
	if (_tmp221_ <= 0) {
		self->priv->default_page_width = 595;
	}
	_tmp222_ = self->priv->settings;
	_tmp223_ = g_settings_get_int (_tmp222_, "page-height");
	self->priv->default_page_height = _tmp223_;
	_tmp224_ = self->priv->default_page_height;
	if (_tmp224_ <= 0) {
		self->priv->default_page_height = 842;
	}
	_tmp225_ = self->priv->settings;
	_tmp226_ = g_settings_get_int (_tmp225_, "page-dpi");
	self->priv->default_page_dpi = _tmp226_;
	_tmp227_ = self->priv->default_page_dpi;
	if (_tmp227_ <= 0) {
		self->priv->default_page_dpi = 72;
	}
	_tmp228_ = self->priv->settings;
	_tmp229_ = g_settings_get_int (_tmp228_, "window-width");
	self->priv->window_width = _tmp229_;
	_tmp230_ = self->priv->window_width;
	if (_tmp230_ <= 0) {
		self->priv->window_width = 600;
	}
	_tmp231_ = self->priv->settings;
	_tmp232_ = g_settings_get_int (_tmp231_, "window-height");
	self->priv->window_height = _tmp232_;
	_tmp233_ = self->priv->window_height;
	if (_tmp233_ <= 0) {
		self->priv->window_height = 400;
	}
	_tmp234_ = self->priv->window_width;
	_tmp235_ = self->priv->window_height;
	g_debug ("ui.vala:1408: Restoring window to %dx%d pixels", _tmp234_, _tmp235_);
	_tmp236_ = self->priv->window;
	_tmp237_ = self->priv->window_width;
	_tmp238_ = self->priv->window_height;
	gtk_window_set_default_size (_tmp236_, _tmp237_, _tmp238_);
	_tmp239_ = self->priv->settings;
	_tmp240_ = g_settings_get_boolean (_tmp239_, "window-is-maximized");
	self->priv->window_is_maximized = _tmp240_;
	_tmp241_ = self->priv->window_is_maximized;
	if (_tmp241_) {
		GtkWindow* _tmp242_;
		g_debug ("ui.vala:1413: Restoring window to maximized");
		_tmp242_ = self->priv->window;
		gtk_window_maximize (_tmp242_);
	}
	_tmp243_ = self->priv->book;
	_tmp244_ = book_get_n_pages (_tmp243_);
	if (_tmp244_ == ((guint) 0)) {
		simple_scan_add_default_page (self);
	}
	_tmp245_ = self->priv->book;
	book_set_needs_saving (_tmp245_, FALSE);
	_tmp246_ = self->priv->book;
	g_signal_connect (_tmp246_, "needs-saving-changed", (GCallback) _simple_scan_needs_saving_cb_book_needs_saving_changed, self);
	_g_free0 (document_type);
	_g_free0 (device);
	_g_object_unref0 (renderer);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hbox);
	_g_free0 (filename);
}


static gpointer _book_ref0 (gpointer self) {
	return self ? book_ref (self) : NULL;
}


Book* simple_scan_get_book (SimpleScan* self) {
	Book* result = NULL;
	Book* _tmp0_;
	Book* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = _book_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void simple_scan_set_selected_page (SimpleScan* self, Page* page) {
	BookView* _tmp0_;
	Page* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = page;
	book_view_select_page (_tmp0_, _tmp1_);
}


Page* simple_scan_get_selected_page (SimpleScan* self) {
	Page* result = NULL;
	BookView* _tmp0_;
	Page* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected (_tmp0_);
	result = _tmp1_;
	return result;
}


void simple_scan_set_scanning (SimpleScan* self, gboolean scanning) {
	gboolean _tmp0_;
	GtkMenuItem* _tmp1_;
	gboolean _tmp2_;
	GtkMenuItem* _tmp3_;
	gboolean _tmp4_;
	GtkToolButton* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = scanning;
	self->priv->scanning = _tmp0_;
	_tmp1_ = self->priv->page_delete_menuitem;
	_tmp2_ = scanning;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, !_tmp2_);
	_tmp3_ = self->priv->stop_menuitem;
	_tmp4_ = scanning;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_);
	_tmp5_ = self->priv->stop_toolbutton;
	_tmp6_ = scanning;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_);
}


void simple_scan_show_error (SimpleScan* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_title != NULL);
	g_return_if_fail (error_text != NULL);
	self->priv->have_error = TRUE;
	_tmp0_ = error_title;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->error_title);
	self->priv->error_title = _tmp1_;
	_tmp2_ = error_text;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->error_text);
	self->priv->error_text = _tmp3_;
	_tmp4_ = change_scanner_hint;
	self->priv->error_change_scanner_hint = _tmp4_;
	simple_scan_update_info_bar (self);
}


void simple_scan_start (SimpleScan* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static void g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_SCAN_OPTIONS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_SCAN_OPTIONS) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), value_get_scan_options (param_values + 2), data2);
}


static void value_simple_scan_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_simple_scan_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		simple_scan_unref (value->data[0].v_pointer);
	}
}


static void value_simple_scan_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = simple_scan_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_simple_scan_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_simple_scan_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SimpleScan* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = simple_scan_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_simple_scan_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SimpleScan** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = simple_scan_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_simple_scan (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSimpleScan* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SIMPLE_SCAN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_simple_scan (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_SCAN), NULL);
	return value->data[0].v_pointer;
}


void value_set_simple_scan (GValue* value, gpointer v_object) {
	SimpleScan* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_SCAN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SIMPLE_SCAN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		simple_scan_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		simple_scan_unref (old);
	}
}


void value_take_simple_scan (GValue* value, gpointer v_object) {
	SimpleScan* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_SCAN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SIMPLE_SCAN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		simple_scan_unref (old);
	}
}


static void simple_scan_class_init (SimpleScanClass * klass) {
	simple_scan_parent_class = g_type_class_peek_parent (klass);
	SIMPLE_SCAN_CLASS (klass)->finalize = simple_scan_finalize;
	g_type_class_add_private (klass, sizeof (SimpleScanPrivate));
	g_signal_new ("start_scan", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_SCAN_OPTIONS, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_SCAN_OPTIONS);
	g_signal_new ("stop_scan", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("email", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("quit", TYPE_SIMPLE_SCAN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void simple_scan_instance_init (SimpleScan * self) {
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	self->priv = SIMPLE_SCAN_GET_PRIVATE (self);
	self->priv->book_uri = NULL;
	_tmp0_ = g_strdup ("photo");
	self->priv->document_hint = _tmp0_;
	_tmp1_ = _ ("Scanned Document.pdf");
	_tmp2_ = g_strdup (_tmp1_);
	self->priv->default_file_name = _tmp2_;
	self->priv->scanning = FALSE;
	self->ref_count = 1;
}


static void simple_scan_finalize (SimpleScan* obj) {
	SimpleScan * self;
	self = SIMPLE_SCAN (obj);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->info_bar);
	_g_object_unref0 (self->priv->info_bar_image);
	_g_object_unref0 (self->priv->info_bar_label);
	_g_object_unref0 (self->priv->info_bar_close_button);
	_g_object_unref0 (self->priv->info_bar_change_scanner_button);
	_g_object_unref0 (self->priv->page_move_left_menuitem);
	_g_object_unref0 (self->priv->page_move_right_menuitem);
	_g_object_unref0 (self->priv->page_delete_menuitem);
	_g_object_unref0 (self->priv->crop_rotate_menuitem);
	_g_object_unref0 (self->priv->save_menuitem);
	_g_object_unref0 (self->priv->save_as_menuitem);
	_g_object_unref0 (self->priv->save_toolbutton);
	_g_object_unref0 (self->priv->stop_menuitem);
	_g_object_unref0 (self->priv->stop_toolbutton);
	_g_object_unref0 (self->priv->text_toolbar_menuitem);
	_g_object_unref0 (self->priv->text_menu_menuitem);
	_g_object_unref0 (self->priv->photo_toolbar_menuitem);
	_g_object_unref0 (self->priv->photo_menu_menuitem);
	_g_object_unref0 (self->priv->authorize_dialog);
	_g_object_unref0 (self->priv->authorize_label);
	_g_object_unref0 (self->priv->username_entry);
	_g_object_unref0 (self->priv->password_entry);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->device_combo);
	_g_object_unref0 (self->priv->text_dpi_combo);
	_g_object_unref0 (self->priv->photo_dpi_combo);
	_g_object_unref0 (self->priv->page_side_combo);
	_g_object_unref0 (self->priv->paper_size_combo);
	_g_object_unref0 (self->priv->device_model);
	_g_object_unref0 (self->priv->text_dpi_model);
	_g_object_unref0 (self->priv->photo_dpi_model);
	_g_object_unref0 (self->priv->page_side_model);
	_g_object_unref0 (self->priv->paper_size_model);
	_g_object_unref0 (self->priv->save_dialog);
	_g_free0 (self->priv->error_title);
	_g_free0 (self->priv->error_text);
	_book_unref0 (self->priv->book);
	_g_free0 (self->priv->book_uri);
	_g_object_unref0 (self->priv->book_view);
	_g_free0 (self->priv->document_hint);
	_g_free0 (self->priv->default_file_name);
}


GType simple_scan_get_type (void) {
	static volatile gsize simple_scan_type_id__volatile = 0;
	if (g_once_init_enter (&simple_scan_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_simple_scan_init, value_simple_scan_free_value, value_simple_scan_copy_value, value_simple_scan_peek_pointer, "p", value_simple_scan_collect_value, "p", value_simple_scan_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SimpleScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleScan), 0, (GInstanceInitFunc) simple_scan_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType simple_scan_type_id;
		simple_scan_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SimpleScan", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&simple_scan_type_id__volatile, simple_scan_type_id);
	}
	return simple_scan_type_id__volatile;
}


gpointer simple_scan_ref (gpointer instance) {
	SimpleScan* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void simple_scan_unref (gpointer instance) {
	SimpleScan* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SIMPLE_SCAN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



