/*  Sclient
 *  Copyright (C) 1999 Heathen (the.heathen@swipnet.se)
 *		  1999 Drizzt  (doc.day@swipnet.se)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* ripped straight from amcl and altered a bit ;) */


#include "config.h"
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include <errno.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

/*
 * Added by Michael Stevens
 */
#ifndef INHIBIT_STRING_HEADER
# if defined (HAVE_STRING_H) || defined (STDC_HEADERS) || defined (_LIBC)
#  include <string.h>
#  ifndef bcmp
#   define bcmp(s1, s2, n) memcmp ((s1), (s2), (n))
#  endif
#  ifndef bcopy
#   define bcopy(s, d, n)  memcpy ((d), (s), (n))
#  endif
#  ifndef bzero
#   define bzero(s, n)     memset ((s), 0, (n))
#  endif
# else
#  include <strings.h>
# endif
#endif

#ifdef HAVE_TELNET_H
#include <telnet.h>
#endif
#ifdef HAVE_ARPA_TELNET_H
#include <arpa/telnet.h>
#endif

#include "net.h"

gchar* strdelim(gchar *str, const gchar *delim, gchar new_delim)

/* The same as g_strdelimit(), but doesn't modify the original string */

{
    register gchar	*c;
    gchar		*newstr;

    g_return_val_if_fail (str != NULL, NULL);
    if (!delim) delim = G_STR_DELIMITERS;
    newstr = g_new(char, strlen(str) + 1);
    strcpy(newstr, str);
    for (c = newstr; *c; c++) {
    	if (strchr (delim, *c)) *c = new_delim;
    }
    return newstr;
}

void make_connection (char *host, char *port)
{
    char buf[2048];

    if ( !(strcmp (host, "\0")) )
    {
        sprintf (buf, "\n*** Can't connect - you didn't specify a host\n");
        textfield_add ( buf, MESSAGE_ERR);
        return;
    }

    if ( !(strcmp(port, "\0")) )
    {
        sprintf (buf, "\n*** No port specified - assuming port 23\n");
        textfield_add ( buf, MESSAGE_NORMAL);
        port = "23\0";
    }

    sprintf (buf, "\n*** Connecting to %s, port %s\n", host, port);
    textfield_add ( buf, MESSAGE_NORMAL);

    open_connection ( host, port);
}

void disconnect ( void )
{
    close (sockfd);
    gdk_input_remove (input_monitor);
    textfield_add ( "\n*** Connection closed.\n", MESSAGE_NORMAL);
    connected = FALSE;
    gtk_widget_set_sensitive (menu_File_Connect, TRUE);
    gtk_widget_set_sensitive (btn_toolbar_connect, TRUE);
    gtk_widget_set_sensitive (menu_File_DisConnect, FALSE);
    gtk_widget_set_sensitive (btn_toolbar_disconnect, FALSE);
    gtk_window_set_title (GTK_WINDOW (mud->window), "SClient "VERSION"");
}

void open_connection ( const char *host, const char *port)
{
    struct hostent *he;
    struct sockaddr_in their_addr;

    /* strerror(3) */
    if ( ( he = gethostbyname (host) ) == NULL )
    {
        return;
    }

    if ( ( sockfd = socket (AF_INET, SOCK_STREAM, 0)) == -1 )
    {
        textfield_add (strerror(errno), MESSAGE_ERR);
        return;
    }

    their_addr.sin_family = AF_INET;
    their_addr.sin_port   = htons( atoi (port));
    their_addr.sin_addr   = *((struct in_addr *)he->h_addr);
    bzero (&(their_addr.sin_zero), 8);

    if (connect (sockfd, (struct sockaddr *)&their_addr,
                 sizeof (struct sockaddr)) == -1 )
    {
        textfield_add (strerror(errno), MESSAGE_ERR);
        return;
    }

    textfield_add ("\n*** Connection established.\n", MESSAGE_NORMAL);

    input_monitor = gdk_input_add (sockfd, GDK_INPUT_READ,
    				   read_from_connection,
    				   NULL );
    connected = TRUE;
    gtk_widget_set_sensitive (menu_File_Connect, FALSE);
    gtk_widget_set_sensitive (btn_toolbar_connect, FALSE);
    gtk_widget_set_sensitive (menu_File_DisConnect, TRUE);
    gtk_widget_set_sensitive (btn_toolbar_disconnect, TRUE);
}

/*
 * Test to see if the out put to text window gets any better
 */
char tmpbuf[1024];	// Needed to hold the stuff we cut out in checkbuf(), so that we can addit
                        // the next time recv() gets called. Don't think it has to be larger that 1024

/*
 * Function to read buf backwards untill it finds a '\033' and
 * then put the letters '\033' and behind into the global char tmpbuf
 * and then terminate the string at pos '\033'. If the '\033' is at
 * position buf[0] we don't do anything.
 *
 * This is a temporary solution until we get a better color parser who
 * will fix this problem automatic.
 *
 * The function is not to efective but it will have to due. 
 *
 * The problem is that if recv stops in the middle of a ansi color code
 * the color will fallaway and the color is set to standard color. But
 * with this function we check the last color code and saves it for the
 * next recv call that will come directly after the previous one and add
 * the text to that call, and we don't have the problem anylonger. The
 * down side is that we lose time here so we mus fix a better ansi color
 * parser that fix the problem.
 */
char *checkbuf (char *buf)
{
    int pos = strlen(buf);
    int buflen = pos;
    int setbufend;
    char *addnext;

    /*memset(tmpbuf, 0, sizeof (char));*/
    addnext = tmpbuf;

    while (pos != 0) {
        if (buf[pos] == '\033') {
            setbufend = pos;
            while (pos != buflen) {
                *addnext++ = buf[pos++];
            } /* while */
            *addnext = '\0';
            buf[setbufend] = '\0';
            return buf;
        } /* if */
        pos--;
    } /* while */
    tmpbuf[0] = '\0';
    return buf;
}

void read_from_connection (gpointer data, gint source, GdkInputCondition condition)
{
    char buf[2048];
    char buff[4096];	// Needed for the test stuff
    int  numbytes;
    int docheck = 0;	// To make sure that checkbuf don't get called unless buf is full.
    
	memset(buf,0,sizeof(char));

    if ( (numbytes = recv (sockfd, buf, 2047, 0) ) == - 1 )
    {
        textfield_add (strerror (errno), MESSAGE_ERR);
        disconnect ( );
        return;
    }

    buf[numbytes] = '\0';

    /*
     * Sometimes we get here even though there isn't any data to read
     * from the socket..
     *
     * found by Michael Stevens
     */
    if ( numbytes == 0 ){
	textfield_add ("\n*** 0 byte packet received\n", MESSAGE_ERR);
        disconnect ();
        return;
    }

   /*
    * Test, this code is needed to get checkbuf to work and dismiss
    * our problem in ansi color parsing.
    */
    // buff needs to be something or else it will fail.
    strcpy(buff, buf);
    if (numbytes == 2047 || numbytes == 1024) {
        // docheck is always 0 when it arrives here.
        docheck = 1;
    }
    // Here we check to see if tmpbuf contains something and if it does we add it to buf.
    if (tmpbuf[0] != '\0') {
        sprintf(buff, "%s%s", tmpbuf, buf);
        // We have now used tmpbuf so set it to be empty.
        tmpbuf[0] = '\0';
    }
    // If buf is full do the stuff that makes sure that the colors in the string will be right.
    // If we don't do this we will se the color escape sequenses in the text window and the text
    // will not be correctly colored, because recv() just fills buf with characters and don't
    // know if it stops in the middle of a color esqape sequense.
    if (docheck) {
        sprintf(buff, "%s", checkbuf(buff));
    }
    // Test End

    textfield_add ( buff, MESSAGE_ANSI);

   /*
    * Search the incomming text for triggers.
   */
    search_triggers (buff);
}

void send_to_connection (GtkWidget *widget, gpointer data)
{
    ALIAS_DATA *alias;
    gchar *entry_text;
    gchar *temp_entry;
    gchar *word;
    gchar *foo;
    gchar *sent=0;

    entry_text = gtk_entry_get_text (GTK_ENTRY (mud->ent));
    gtk_entry_select_region (GTK_ENTRY (mud->ent), 0,
                             GTK_ENTRY (mud->ent)->text_length);

    
    temp_entry = g_malloc0 (strlen (entry_text) + 2);
    word       = g_malloc0 (strlen (entry_text) + 2);
    foo        = g_malloc0 (strlen (entry_text) + 2);
    strcat (temp_entry, entry_text);
    strcat (temp_entry, "\n");
    sscanf (temp_entry, "%s %[^\n]", word, foo);

    for ( alias = alias_list; alias != NULL; alias = alias->next )
    {
        if ( alias->alias && !strcmp (word, alias->alias) )
        {
            //hist_add(alias->replace);
            sent = g_malloc0(strlen(alias->replace)+strlen(foo)+3);
            sprintf (sent, "%s %s", strdelim(alias->replace,";",'\n'), foo);
            hist_add(sent);
            strcat(sent, "\n");
            break;
        }
    }

    if( !sent ) {
      sent = temp_entry;
      if (strlen(entry_text))
          hist_add(entry_text);
   }
   if ( connected )
    {
        send (sockfd, sent, strlen (sent), 0);
    }
    if ( prefs.EchoText && GTK_ENTRY(mud->ent)->visible )
        textfield_add (/*entry_etxt*/sent, MESSAGE_SENT);

    //textfield_add ( "\n", MESSAGE_NONE);
    if ( prefs.KeepText )
        gtk_entry_select_region (GTK_ENTRY (mud->ent), 0,
                                 GTK_ENTRY (mud->ent)->text_length);
    else
        gtk_entry_set_text (GTK_ENTRY (mud->ent), "");

    if( sent != temp_entry )
      g_free( sent );
      g_free (temp_entry);
      g_free (word);
      g_free (foo);
}

/* used by the auto login function in the connection wizard!
*/
void connection_send (gchar *message)
{
    send (sockfd, message, strlen (message), 0);

}

/*
 * This function sends the macros to the connection.
 *************** THIS FUNCTOIN IS NO LONGER BEING USED ********************
void macro_send_to_connection (gchar *text)
{
    gchar *temp_text;
    gchar *word;
    gchar *foo;

    if (!strlen(text))
        return;

    temp_text = g_malloc0 (strlen (text) + 2);
    word     = g_malloc0 (strlen (text) + 2);
    foo      = g_malloc0 (strlen (text) + 2);
    strcat (temp_text, text);
    strcat (temp_text, "\n");
    sscanf (temp_text, "%s %[^\n]", word, foo);

    if ( connected ) {
        send (sockfd, temp_text, strlen (temp_text), 0);
    }

    if ( prefs.EchoText)
        textfield_add (text, MESSAGE_SENT);

    textfield_add ( "\n", MESSAGE_NONE);

    g_free (temp_text);
    g_free (word);
    g_free (foo);
}
*/

/* send the macro and triggered ext to mud! */
void alt_send_to_connection (gchar *text)
{
    gchar *temp;
    if (strlen(text)) {
	temp = g_malloc0(strlen(text) + 2);
	strcpy(temp, strdelim(text,";",'\n'));
	strcat(temp,"\n");
	if (connected) send (sockfd, temp, strlen(temp), 0);
	if (prefs.EchoText) textfield_add (temp, MESSAGE_SENT);
    }
}


