# Samizdat top focuses list
#
#   Copyright (c) 2002-2009  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 3 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

class FociController < Controller

  def index
    dataset = RdfDataSet.new('
      SELECT ?focus, count(?resource)
      WHERE (rdf::predicate ?stmt dc::relation)
            (rdf::subject ?stmt ?resource)
            (rdf::object ?stmt ?focus)
            (s::inReplyTo ?resource ?parent)
            (dct::isVersionOf ?resource ?current)
            (s::rating ?stmt ?rating FILTER ?rating > 0)
      LITERAL ?parent IS NULL AND ?current IS NULL
      GROUP BY ?focus
      ORDER BY count(?resource) DESC')

    page = (@request['page'] or 1).to_i

    focuses = [[_('Focus'), _('Related Resources')]] +
      dataset[page - 1].collect {|focus, nrelated|
        [
          resource_href(focus, Resource.new(@request, focus).title),
          nrelated
        ]
      }

    @title = config['site']['name'] + ': ' +
      _('Top Focuses') + page_number(page)
    @content_for_layout = box(@title,
      table(focuses, nav(dataset)))
  end
end
