/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: usage.c,v 1.8 1999/03/01 01:57:30 lance Exp $ */
#include <stdio.h>

#define BLD "[1m" /* (ESC charactor) [ 1 m */
#define REG "[0m" /* (ESC charactor) [ 0 m */

void usage(char *argv0, FILE *fileptr)
{
  fprintf(fileptr,
	 /* 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 */
	  "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s" /* 20 */
	  "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s" /* 40 */
	  "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s" /* 60 */
	  "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s" /* 80 */
	  "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s" /* 100 */
	  "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s" /* 120 */
	  "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s" /* 140 */
	  "%s%s%s%s%s%s%s%s%s%s%s",
	  "Usage: ",
	  argv0,
	  " [OPTIONS] [X-OPTIONS] [file1 [file2] ...]\n\n",
	  "OPTIONS\n\n",

	  "                                don't display the bounding axes\r",
	  BLD,
	  "-a",
	  REG,
	  " or ",
	  BLD,
	  "--no-axes",
	  REG,

	  "\n                                the input data is in the binary format\r",
	  BLD,
	  "-b",
	  REG,
	  " or ",
	  BLD,
	  "--binary",
	  REG,

	  "\n                                list of function plots, ex: ",
	  argv0,
	  " -f \"1 0 2 1\"\r",
	  BLD,
	  "-f LIST",
	  REG,
	  " or ",
	  BLD,
	  "--function-plot=LIST",
	  REG,
	  "\n                                means plot data field 1 vs 0 and 2 vs 1\n",

	  "                                display this help and exit\r",
	  BLD,
	  "-h",
	  REG,
	  " or ",
	  BLD,
	  "--help",
	  REG,

	  "\n                                label the fields in the value window with ",
	  BLD,
	  "LIST",
	  REG,
	  "\r",
	  BLD,
	  "-l LIST",
	  REG,
	  " or ",
	  BLD,
	  "--label=LIST",
	  REG,

	  "\n                                plot without lines, just points\r",
	  BLD,
	  "-n",
	  REG,
	  " or ",
	  BLD,
	  "--no-lines",
	  REG,

	  "\n                                list of phase plots, ex: ",
	  argv0,
	  " -p \"1 0 2 1\"\r",
	  BLD,
	  "-p LIST",
	  REG,
	  " or ",
	  BLD,
	  "--phase-plot=LIST"
	  REG,

	  "\n                                means plot data field 1 vs 0 and 2 vs 1",

	  "\n                                plot all plots on the same scale\r",
	  BLD,
	  "-s",
	  REG,
	  " or ",
	  BLD,
	  "--same-scale",
	  REG,

	  "\n                                print more information to standard error\r",
	  BLD,
	  "-v",
	  REG,
	  " or ",
	  BLD,
	  "--verbose"
	  REG,

	  "\n                                display plots in black and white\r",
	  BLD,
	  "-B"
	  REG,
	  " or ",
	  BLD,
	  "--black-and-white",
	  REG,

	  "\n                                set the label seperator to the character ",
	  BLD,
	  "CHR",
	  REG,
	  "\r",
	  BLD,
	  "-L CHR",
	  REG,
	  " or ",
	  BLD,
	  "--label-seperator=CHR",
	  REG,

	  "\n                                don't read data in from standard input\r",
	  BLD,
	  "-N",
	  REG,
	  " or ",
	  BLD,
	  "--no-pipe",
	  REG,


	  "\n                                read data in from standard input\r",
	  BLD,
	  "-P",
	  REG,
	  " or ",
	  BLD,
	  "--pipe",
	  REG,

	  "\n                                read in labels from the first non-skipped lines\r",
	  BLD,
	  "-R",
	  REG,
	  " or ",
	  BLD,
	  "--read-labels",
	  REG,



	  "\n                                skip the first NUM lines from all input\r",
	  BLD,
	  "-S NUM",
	  REG,
	  " or ",
	  BLD,
	  "--skip-lines=NUM",
	  REG,

	  "\n                                output version and about information and exit\r",
	  BLD,
	  "-V",
	  REG,
	  " or ",
	  BLD,
	  "--version",
	  REG,

	  "\n                                don't load a piXmap of the first view of the plot\r"
	   BLD,
	  "-X",
	  REG,
	  " or ",
	  BLD,
	  "--no-pixmap",
	  REG,

	  "\n\nSEE the man page for X-options and more information\n"
	  );
}

