

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/
/*! \file sample.hpp
    \brief weighted sample

    \fullpath
    ql/MonteCarlo/%sample.hpp

*/

// $Id: sample.hpp,v 1.4 2002/01/16 14:42:18 nando Exp $

#ifndef quantlib_sample_h
#define quantlib_sample_h

#include <ql/qldefines.hpp>

namespace QuantLib {

    namespace MonteCarlo {

        //! weighted sample
        template <class T>
        struct Sample {
          public:
            Sample(const T& value, double weight)
            : value(value), weight(weight) {}
            T value;
            double weight;
        };

    }

}


#endif
