=begin
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
=end

# $Id: covariance.rb,v 1.4 2002/01/16 15:17:06 nando Exp $

require 'QuantLib'
require 'runit/testcase'
require 'runit/testsuite'
require 'runit/cui/testrunner'

def initCovariance(vol, corr)
    n = vol.length
    cov = QuantLib::Matrix.new(n,n)
    unless n == corr.rows()
        assert_fail("\ncorrelation matrix and volatility vector have different size\n")
    end
    0.upto(n-1) { |i|
        cov[i][i] = vol[i]*vol[i]
        0.upto(i-1) { |j|
            cov[i][j] = corr[i][j]*vol[i]*vol[j]
            cov[j][i] = cov[i][j]
        }
    }
    return cov
end

class CovarianceTest < RUNIT::TestCase
    def name
        "Testing covariance calculation..."
    end
    def test
        vol = QuantLib::Array.new([0.1, 0.5, 1.0])
        corr = QuantLib::Matrix.new(3,3)
        corr[0][0] = 1.0; corr[0][1] = 0.2; corr[0][2] = 0.5
        corr[1][0] = 0.2; corr[1][1] = 1.0; corr[1][2] = 0.8
        corr[2][0] = 0.5; corr[2][1] = 0.8; corr[2][2] = 1.0

        expectedCov = initCovariance(vol, corr)
        cov = QuantLib::getCovariance(vol, corr)

        0.upto(2) { |i|
        0.upto(2) { |j|
            unless (cov[i][j] - expectedCov[i][j]).abs <= 1e-10
                assert_fail(<<-MESSAGE

    cov[#{i}][#{j}]: #{cov[i][j]}
        expected   : #{expectedCov[i][j]}

                    MESSAGE
                )
            end
        }}
    end
end

if $0 == __FILE__
    RUNIT::CUI::TestRunner.run(CovarianceTest.suite)
end

