
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Null.i,v 1.10 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_null_i
#define quantlib_null_i

%{
#include <ql/null.hpp>
%}

// typedef Null<int> and Null<double> into None and viceversa

%inline %{
typedef int intOrNull;
typedef double doubleOrNull;
%}

%typemap(python,in) intOrNull {
    if ($source == Py_None) {
        $target = Null<int>();
    } else if (PyInt_Check($source) != 0) {
        $target = int(PyInt_AsLong($source));
    } else {
        PyErr_SetString(PyExc_TypeError,"int or None expected");
        return NULL;
    }
}

%typemap(python,out) intOrNull {
    if ($source == Null<int>()) {
        Py_INCREF(Py_None);
        $target = Py_None;
    } else {
        $target = PyInt_FromLong(long($source));
    }
}

%typemap(python,in) doubleOrNull {
    if ($source == Py_None) {
        $target = Null<double>();
    } else if (PyFloat_Check($source) != 0) {
        $target = PyFloat_AsDouble($source);
    } else {
        PyErr_SetString(PyExc_TypeError,"double or None expected");
        return NULL;
    }
}

%typemap(python,out) doubleOrNull {
    if ($source == Null<double>()) {
        Py_INCREF(Py_None);
        $target = Py_None;
    } else {
        $target = PyFloat_FromDouble($source);
    }
}




// typemap None to object returned from default constructor

%define AllowNoneAsInput(Type,TypeAlias)
%types(Type *);
%typemap(python,in) Type (Type temp), Type * (Type temp),
  const Type & (Type temp), Type & (Type temp) {
    Type* x;
    if ($source == Py_None) {
        temp = Type();
        $target = &temp;
    } else if ((SWIG_ConvertPtr($source,(void **) &x,
                                SWIGTYPE_p_##Type,0)) != -1) {
        $target = x;
    } else {
        PyErr_SetString(PyExc_TypeError,"TypeAlias" " expected");
        return NULL;
    }
};
%enddef


#endif
