inherit "module";
inherit "xmlrpc.pmod";

#include <module.h>

constant cvs_version = "$Id: xml-rpc.pike,v 1.4 2002/02/28 00:48:15 pit Exp $";
constant module_type = MODULE_LOCATION;
constant module_name = "XML-RPC Module";
constant module_doc =
"This module accepts XMLRPC requests "
"(see <a href='http://www.xmlrpc.org/'>http://www.xmlrpc.org/</a>) "
" and invokes the appropriate method.";

private object xml_rpc;
private mixed local_conf;

void create()
{
  defvar("mountpoint",
	 Variable.Location("/rpc/", 0,
			   "Mount point",
			   "This is where the module will be inserted "
			   "in the namespace of your server."));
}

void start(int occasion, Configuration conf)
{
	local_conf=conf;
	xml_rpc=xmlRPC();
}

void stop()
{
	destruct(xml_rpc);
}

string status() 
{
	string out="Provided Methods:<br>";
	
	array(RoxenModule) rpc_providers = local_conf->get_providers("XML-RPC");
	foreach(rpc_providers, RoxenModule provider) {
		out+=sprintf("Module <b>%s</b>:<br>",
				provider->module_name);
        	mapping functions;
	        functions = provider->query_rpc_functions();
		foreach(indices(functions), mixed f) {
			out+=f+" ";
		}
		out+="<br>";
	}
	return(out);	
}

mapping|Stdio.File|void find_file( string path, RequestID id )
{
  function    call;
  string xmlResult;
  mixed callResult;
  string     fcall;
  mixed       args;
  mapping      rpc;

  if(id->method != "POST") {
	if(has_value(id->request_headers->accept, "text/html") ) {
		return Roxen.http_low_answer(405, 
			sprintf("<html><head><title>405 - metod not allowed</title>"
					+ "</head><body><h1>405 - metod not allowed</h1>"
					+ "<p>'%s' ist not allowed on this object.</p></body></html>",
					id->method));
	} else {
		xmlResult = xml_rpc->compose_fault(3,
			sprintf("Method '%s' not allowed", id->method));
		return Roxen.http_string_answer(xmlResult, "text/xml");
	}
  }

  rpc = xml_rpc->parse(id->data);
  fcall = rpc["methodName"];
  args  = rpc["params"];

  array(RoxenModule) rpc_providers = id->conf->get_providers("XML-RPC");
  foreach(rpc_providers, RoxenModule provider) {
	mapping functions;

	functions = provider->query_rpc_functions();

	call = functions[fcall];
	if ( functionp(call) ) {
	   callResult = call(@args);
           if ( callResult != 0 ) {
	       xmlResult = xml_rpc->compose_response(callResult);
	       return Roxen.http_string_answer(xmlResult, "text/xml");
           }
        }
  }
  xmlResult = xml_rpc->compose_fault(4, sprintf("Function '%s' not found", fcall));
  return Roxen.http_string_answer(xmlResult, "text/xml");
}


string query_location()
{
  return query( "mountpoint" );
}

array(int)|Stat stat_file( string path, RequestID id )
{
  return ({ 0775, // mode
	    ({ 17, -2 })[random(2)], // size/special
	    963331858, // atime
	    963331858, // mtime
	    963331858, // ctime
	    0, // uid
	    0 /* gid */ });
} 

mapping(string:array(int)|Stat) find_dir_stat( string path, RequestID id );

string|void real_file( string path, RequestID id );

array(string)|void find_dir( string path, RequestID id )
{
  return ({ });
}

// vi: set ts=3:
