/*
 * @(#)BCELCreatorUtil.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2;

import java.io.IOException;

import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.MethodGen;


/**
 * Helper for creating BCEL objects.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:27 $
 * @since     January 23, 2003
 */
public class BCELCreatorUtil
{
    private static final Class THIS_CLASS = BCELCreatorUtil.class;
    
    
    public static JavaClass createJavaClass( Class c ) throws IOException
    {
        JavaClass jc = BytecodeLoaderUtil.loadJavaClass( c.getName() );
        return jc;
    }
    
    
    public static Method getMethod( JavaClass jc, int methodIndex )
    {
        Method mL[] = jc.getMethods();
        Method m = mL[ methodIndex ];
        return m;
    }
    
    
    public static MethodGen createMethodGen( JavaClass jc, int methodIndex )
    {
        MethodGen mg = createMethodGen( jc, getMethod( jc, methodIndex ) );
        return mg;
    }
    
    
    public static MethodGen createMethodGen( JavaClass jc, Method m )
    {
        ConstantPoolGen cpg = new ConstantPoolGen( jc.getConstantPool() );
        MethodGen mg = new MethodGen( m, jc.getClassName(), cpg );
        return mg;
    }
    
    
    public static InstructionList createInstructionList()
    {
        InstructionList il = new InstructionList();
        return il;
    }
    
    
    public static InstructionHandle addInstructionHandle(
            InstructionList il )
    {
        InstructionHandle ih = il.append( new LDC( 0 ) );
        return ih;
    }
    
    
    public static InstructionHandle createInstructionHandle()
    {
        return addInstructionHandle( createInstructionList() );
    }
}

